/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.dev.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class RemoteBranchSelectionDialog
extends SelectionDialog {
    private List<Ref> refs = null;
    private Combo initialCheckoutBranch = null;
    private Ref initialBranch;
    CheckboxTableViewer listViewer;
    private static IStructuredContentProvider gitContentProvider = new IStructuredContentProvider(){

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            List refs = (List)inputElement;
            return refs.toArray();
        }
    };
    private static ILabelProvider gitLabelProvider = new ILabelProvider(){

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            Ref ref = (Ref)element;
            return ref.getName();
        }

        public Image getImage(Object element) {
            return null;
        }
    };

    protected CheckboxTableViewer getViewer() {
        return this.listViewer;
    }

    private void initializeViewer() {
        this.listViewer.setInput(this.refs);
    }

    public RemoteBranchSelectionDialog(Shell parentShell, List<Ref> input) {
        super(parentShell);
        this.setMessage("Select branches to clone from remote repository");
        this.refs = input;
        this.setTitle("Clone Git Repository");
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)gitLabelProvider);
        this.listViewer.setContentProvider((IContentProvider)gitContentProvider);
        this.initializeViewer();
        Label label = new Label(composite, 0);
        label.setText("Initial branch");
        this.initialCheckoutBranch = new Combo(composite, 12);
        data = new GridData(1808);
        this.initialCheckoutBranch.setLayoutData((Object)data);
        this.getViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RemoteBranchSelectionDialog.this.updateIntialBranchCombo();
            }
        });
        this.getViewer().setAllChecked(true);
        this.updateIntialBranchCombo();
        return composite;
    }

    private void updateIntialBranchCombo() {
        Object[] checked = this.getViewer().getCheckedElements();
        ArrayList<String> list = new ArrayList<String>();
        int indexMain = -1;
        int i = 0;
        while (i < checked.length) {
            Ref ref = (Ref)checked[i];
            list.add(ref.getName());
            if (ref.getName().endsWith("/master")) {
                indexMain = i;
            }
            ++i;
        }
        if (list.size() > 0) {
            this.initialCheckoutBranch.setItems(list.toArray(new String[list.size()]));
            this.initialCheckoutBranch.select(indexMain < 0 ? 0 : indexMain);
        } else {
            this.initialCheckoutBranch.setItems(new String[0]);
        }
        if (this.getOkButton() != null) {
            this.getOkButton().setEnabled(list.size() > 0);
        }
    }

    protected void okPressed() {
        int initialBranchIndex;
        Object[] children = gitContentProvider.getElements(this.refs);
        if (children != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < children.length) {
                Object element = children[i];
                if (this.listViewer.getChecked(element)) {
                    list.add(element);
                }
                ++i;
            }
            this.setResult(list);
        }
        if ((initialBranchIndex = this.initialCheckoutBranch.getSelectionIndex()) >= 0 && this.getViewer().getCheckedElements().length > 0) {
            this.initialBranch = (Ref)this.getViewer().getCheckedElements()[initialBranchIndex];
        }
        super.okPressed();
    }

    public Ref getInitialCheckoutBranch() {
        return this.initialBranch;
    }
}

