/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.dev.view;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.cloud.dev.CloudProjectService;
import oracle.eclipse.tools.cloud.dev.CloudRepositoryNode;
import oracle.eclipse.tools.cloud.dev.GitRepoNode;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.IndexChangedEvent;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonViewer;

public class GitContentProvider {
    private Set<CloudRepositoryNode> gitRepoSet = new HashSet<CloudRepositoryNode>();
    private CommonViewer viewer;
    private final RepositoryUtil repositoryUtil;
    private final Set<Repository> repositories = new HashSet<Repository>();
    private final RefsChangedListener myRefsChangedListener;
    private final IndexChangedListener myIndexChangedListener;
    private final ConfigChangedListener myConfigChangeListener;
    private final List<ListenerHandle> myListeners = new LinkedList<ListenerHandle>();
    private static final long DEFAULT_REFRESH_DELAY = 1000L;
    private final RepositoryCache repositoryCache;
    private IEclipsePreferences.IPreferenceChangeListener configurationListener;

    public GitContentProvider() {
        this.repositoryUtil = Activator.getDefault().getRepositoryUtil();
        this.repositoryCache = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache();
        this.configurationListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                GitContentProvider.this.initRepositoriesAndListeners();
                GitContentProvider.this.scheduleRefresh(1000L);
            }
        };
        this.myRefsChangedListener = new RefsChangedListener(){

            public void onRefsChanged(RefsChangedEvent e) {
                GitContentProvider.this.scheduleRefresh(1000L);
            }
        };
        this.myIndexChangedListener = new IndexChangedListener(){

            public void onIndexChanged(IndexChangedEvent event) {
                GitContentProvider.this.scheduleRefresh(1000L);
            }
        };
        this.myConfigChangeListener = new ConfigChangedListener(){

            public void onConfigChanged(ConfigChangedEvent event) {
                GitContentProvider.this.scheduleRefresh(1000L);
            }
        };
        this.repositoryUtil.getPreferences().addPreferenceChangeListener(this.configurationListener);
        this.initRepositoriesAndListeners();
    }

    private void unregisterRepositoryListener() {
        for (ListenerHandle lh : this.myListeners) {
            lh.remove();
        }
        this.myListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepositoriesAndListeners() {
        Set<Repository> set = this.repositories;
        synchronized (set) {
            this.repositories.clear();
            this.unregisterRepositoryListener();
            for (String dir : this.repositoryUtil.getConfiguredRepositories()) {
                File repoDir = new File(dir);
                try {
                    Repository repo = this.repositoryCache.lookupRepository(repoDir);
                    this.myListeners.add(repo.getListenerList().addIndexChangedListener(this.myIndexChangedListener));
                    this.myListeners.add(repo.getListenerList().addRefsChangedListener(this.myRefsChangedListener));
                    this.myListeners.add(repo.getListenerList().addConfigChangedListener(this.myConfigChangeListener));
                    this.repositories.add(repo);
                }
                catch (IOException e) {
                    String message = "Exception looking up Git Repo " + repoDir.getPath();
                    CloudUiPlugin.log(4, message, e);
                    this.repositoryUtil.removeDir(repoDir);
                }
            }
        }
    }

    protected void scheduleRefresh(long defaultRefreshDelay) {
        Job refreshGitRepo = new Job("Refresh Git repo"){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Iterator it = GitContentProvider.this.gitRepoSet.iterator();
                        while (it.hasNext()) {
                            CloudRepositoryNode repo = (CloudRepositoryNode)it.next();
                            if (!repo.getGitRepoNode().isCloned()) {
                                CloudProjectService cps = repo.getGitRepoNode().getCloudProjectService();
                                it.remove();
                                repo.getGitRepoNode().reset();
                                GitContentProvider.this.viewer.refresh((Object)cps);
                                continue;
                            }
                            GitContentProvider.this.viewer.refresh((Object)repo);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        refreshGitRepo.schedule(defaultRefreshDelay);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (CommonViewer)viewer;
    }

    public void addToCache(CloudRepositoryNode repo) {
        this.gitRepoSet.add(repo);
    }

    public Object[] getChildren(CloudRepositoryNode repo) {
        GitRepoNode gitRepoNode = repo.getGitRepoNode();
        if (gitRepoNode != null) {
            return new Object[]{gitRepoNode.getProjectSolutions()};
        }
        return Collections.emptyList().toArray();
    }

    public CloudProjectService getParent(CloudRepositoryNode repoNode) {
        return repoNode.getGitRepoNode().getCloudProjectService();
    }

    public void dispose() {
        this.gitRepoSet.clear();
        this.unregisterRepositoryListener();
        this.repositories.clear();
    }
}

