/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.dev.view;

import com.tasktop.c2c.server.cloud.domain.ServiceType;
import com.tasktop.c2c.server.profile.domain.project.ProjectService;
import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.cloud.dev.BuildService;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.CloudProjectService;
import oracle.eclipse.tools.cloud.dev.DcsBuildPlan;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.DevServiceDesc;
import oracle.eclipse.tools.cloud.dev.GitRepoNode;
import oracle.eclipse.tools.cloud.dev.ProjectSolutions;
import oracle.eclipse.tools.cloud.dev.SolutionNode;
import oracle.eclipse.tools.cloud.dev.TaskService;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.cloud.ui.dev.view.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.internal.builds.ui.view.BuildLabelProvider;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.cnf.ServerContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.BaseCellLabelProvider;
import org.osgi.framework.Bundle;

public class DevCloudLabelProvider
extends BaseCellLabelProvider {
    private DecoratingStyledCellLabelProvider buildElementLabelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new BuildLabelProvider(true), null, null);
    private ImageRegistry imageRegistry = null;
    private final String IMG_DEV_SERVICE = "images/cloud.png";
    private final String IMG_DEV_SERVICE_INACTIVE = "images/cloud-inactive.png";
    private final String IMG_SCM_SERVICE = "images/repo_rep.gif";
    private final String IMG_SCM_SERVICE_DSIABLED = "images/repo_disabled.gif";
    private final String IMG_WIKI_SERVICE = "images/wiki.gif";
    private final String IMG_TASK_SERVICE = "images/task.png";
    private final String IMG_TASK_SERVICE_INACTVIE = "images/task-disabled.png";
    private final String IMG_BUILD_SERVICE = "images/build.png";
    private final String IMG_BUILD_SERVICE_INACTIVE = "images/build-disabled.png";

    public DevCloudLabelProvider() {
        this.initImages();
    }

    public String getText(Object element) {
        if (element instanceof DevServiceDesc) {
            return "Developer Cloud Service";
        }
        if (element instanceof CloudProject) {
            CloudProject p = (CloudProject)element;
            return this.notNull(p.getProject().getName());
        }
        if (element instanceof CloudProjectService) {
            CloudProjectService cps = (CloudProjectService)element;
            ProjectService ps = cps.getProjectService();
            ServiceType type = ps.getServiceType();
            switch (type) {
                case SCM: {
                    return "Source";
                }
                case BUILD: {
                    return "Build";
                }
                case MAVEN: {
                    return "Remote Maven Repository";
                }
                case WIKI: {
                    return "Documentation";
                }
                case TASKS: {
                    return "Tasks";
                }
                case DEPLOYMENT: {
                    return "Deployment";
                }
                case REVIEWS: {
                    return "Reviews";
                }
            }
            return type.toString();
        }
        if (element == ServerContentProvider.INITIALIZING) {
            return Messages.viewInitializing;
        }
        if (element instanceof IWorkspaceRoot) {
            return Platform.getResourceString((Bundle)ServerUIPlugin.getInstance().getBundle(), (String)"%viewServers");
        }
        if (element instanceof DcsBuildPlan) {
            DcsBuildPlan dcsPlan = (DcsBuildPlan)element;
            return dcsPlan.plan().getLabel();
        }
        if (element instanceof IBuild) {
            IBuild job = (IBuild)element;
            long timeStamp = job.getTimestamp();
            Date date = new Date(timeStamp);
            DateFormat dateFormat = SimpleDateFormat.getDateTimeInstance();
            return "#" + job.getLabel() + " (" + dateFormat.format(date) + ") " + job.getSummary();
        }
        if (element instanceof GitRepoNode) {
            return ((GitRepoNode)element).getLabel();
        }
        if (element instanceof RepositoryTreeNode) {
            return null;
        }
        if (element instanceof SolutionNode) {
            SolutionNode node = (SolutionNode)element;
            return node.getProjRec().getProjectLabel();
        }
        if (element instanceof ProjectSolutions) {
            return element.toString();
        }
        if (element instanceof String) {
            return element.toString();
        }
        return null;
    }

    private Image createImage(String path) {
        URL url = CloudUiPlugin.bundle().getEntry(path);
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
        return descriptor.createImage();
    }

    protected void getImageRegistry() {
        if (this.imageRegistry == null) {
            if (Display.getCurrent() != null) {
                this.imageRegistry = new ImageRegistry(Display.getCurrent());
            } else if (PlatformUI.isWorkbenchRunning()) {
                this.imageRegistry = new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
            } else {
                throw new SWTError(22);
            }
        }
    }

    private void initImages() {
        if (this.imageRegistry == null) {
            this.getImageRegistry();
            this.imageRegistry.put("images/cloud.png", this.createImage("images/cloud.png"));
            this.imageRegistry.put("images/cloud-inactive.png", this.createImage("images/cloud-inactive.png"));
            this.imageRegistry.put("images/repo_rep.gif", this.createImage("images/repo_rep.gif"));
            this.imageRegistry.put("images/repo_disabled.gif", this.createImage("images/repo_disabled.gif"));
            this.imageRegistry.put("images/wiki.gif", this.createImage("images/wiki.gif"));
            this.imageRegistry.put("images/task.png", this.createImage("images/task.png"));
            this.imageRegistry.put("images/task-disabled.png", this.createImage("images/task-disabled.png"));
            this.imageRegistry.put("images/build.png", this.createImage("images/build.png"));
            this.imageRegistry.put("images/build-disabled.png", this.createImage("images/build-disabled.png"));
        }
    }

    public void dispose() {
        super.dispose();
        this.imageRegistry.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof DevServiceDesc) {
            DevServiceDesc devSvc = (DevServiceDesc)element;
            return devSvc.isActivated() ? this.imageRegistry.get("images/cloud.png") : this.imageRegistry.get("images/cloud-inactive.png");
        }
        if (element instanceof CloudProject) {
            CloudProject p = (CloudProject)element;
            return p.isActivated() ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT") : PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT_CLOSED");
        }
        if (element instanceof CloudProjectService) {
            CloudProjectService ps = (CloudProjectService)element;
            switch (ps.getProjectService().getServiceType()) {
                case SCM: {
                    return this.imageRegistry.get("images/repo_rep.gif");
                }
                case BUILD: {
                    return DevCloudCore.findBuildServer((BuildService)((BuildService)ps)) != null ? this.imageRegistry.get("images/build.png") : this.imageRegistry.get("images/build-disabled.png");
                }
                case TASKS: {
                    return ((TaskService)ps).isActivated() ? this.imageRegistry.get("images/task.png") : this.imageRegistry.get("images/task-disabled.png");
                }
                case WIKI: {
                    return this.imageRegistry.get("images/wiki.gif");
                }
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_FORWARD");
        }
        if (element instanceof GitRepoNode) {
            GitRepoNode gitRepoNode = (GitRepoNode)element;
            if (gitRepoNode.isCloned()) {
                return RepositoryTreeNodeType.REPO.getIcon();
            }
            return this.imageRegistry.get("images/repo_disabled.gif");
        }
        if (element instanceof SolutionNode) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT_CLOSED");
        }
        if (element instanceof ProjectSolutions) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (element instanceof DcsBuildPlan) {
            DcsBuildPlan dcsPlan = (DcsBuildPlan)element;
            return this.buildElementLabelProvider.getImage((Object)dcsPlan.plan());
        }
        if (element instanceof IBuild) {
            return this.buildElementLabelProvider.getImage(element);
        }
        return null;
    }

    Set<File> getWorkspaceProjectFolders() {
        HashSet<File> ret = new HashSet<File>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            File f = p.getLocation().toFile();
            ret.add(f);
            ++n2;
        }
        return ret;
    }

    protected String notNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public boolean isLabelProperty(Object element, String property) {
        if (element instanceof IServer && property.equalsIgnoreCase("ICON")) {
            return true;
        }
        return true;
    }

    public Image getColumnImage(Object element, int index) {
        return null;
    }

    public String getColumnText(Object element, int index) {
        return null;
    }
}

