/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.dev.view;

import com.tasktop.c2c.server.cloud.domain.ServiceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.dev.BuildPlans;
import oracle.eclipse.tools.cloud.dev.BuildService;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.CloudProjectService;
import oracle.eclipse.tools.cloud.dev.CloudProjectServices;
import oracle.eclipse.tools.cloud.dev.CloudRepositoryNode;
import oracle.eclipse.tools.cloud.dev.DcsBuildPlan;
import oracle.eclipse.tools.cloud.dev.DcsBuilds;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.DevCloudProjects;
import oracle.eclipse.tools.cloud.dev.DevServiceDesc;
import oracle.eclipse.tools.cloud.dev.GitRepoNode;
import oracle.eclipse.tools.cloud.dev.GitRepos;
import oracle.eclipse.tools.cloud.dev.ProjectSolutions;
import oracle.eclipse.tools.cloud.dev.ScmService;
import oracle.eclipse.tools.cloud.dev.SolutionNode;
import oracle.eclipse.tools.cloud.dev.TaskService;
import oracle.eclipse.tools.cloud.ui.dev.view.GitContentProvider;
import oracle.eclipse.tools.cloud.ui.internal.FetchingRemoteDataNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.server.ui.internal.viewers.BaseContentProvider;

public class DevCloudContentProvider
extends BaseContentProvider
implements ITreeContentProvider {
    public static Object INITIALIZING = new Object();
    private GitContentProvider gitContentProvider = new GitContentProvider();
    private CommonViewer viewer;
    private Listener devCloudRemoteDataListener;
    private Set<RemoteData<?>> remoteDataSet = new HashSet();

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (CommonViewer)viewer;
        this.gitContentProvider.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getElements(Object element) {
        ArrayList list = new ArrayList();
        return list.toArray();
    }

    private void initRemoteListener() {
        if (this.devCloudRemoteDataListener != null) {
            return;
        }
        this.devCloudRemoteDataListener = new FilteredListener<RemoteData.ContentEvent>(){

            protected void handleTypedEvent(RemoteData.ContentEvent event) {
                DevServiceDesc parent;
                if (event.data() instanceof DevCloudProjects) {
                    DevServiceDesc dcs;
                    parent = dcs = ((DevCloudProjects)event.data()).devServiceDesc();
                } else if (event.data() instanceof CloudProjectServices) {
                    CloudProjectServices cps = (CloudProjectServices)event.data();
                    parent = cps.cloudProject();
                    cps.cloudProject().getRemoteGitUrls();
                } else if (event.data() instanceof GitRepos) {
                    GitRepos gitRepos = (GitRepos)event.data();
                    parent = gitRepos.scmService();
                } else if (event.data() instanceof BuildPlans) {
                    BuildPlans buildPlans = (BuildPlans)event.data();
                    parent = buildPlans.getBuildService();
                } else if (event.data() instanceof DcsBuilds) {
                    DcsBuilds buildJobs = (DcsBuilds)event.data();
                    parent = buildJobs.buildPlan();
                } else {
                    parent = null;
                }
                if (parent == null || DevCloudContentProvider.this.viewer.getControl().isDisposed()) {
                    return;
                }
                DevCloudContentProvider.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DevCloudContentProvider.this.viewer.refresh(parent);
                    }
                });
            }
        };
    }

    public Object[] getChildren(Object element) {
        this.initRemoteListener();
        if (element instanceof DevServiceDesc) {
            DevServiceDesc devSvcDesc = (DevServiceDesc)element;
            DevCloudProjects devCloudProjects = devSvcDesc.cloudProjects();
            devCloudProjects.attach(this.devCloudRemoteDataListener);
            this.remoteDataSet.add((RemoteData<?>)devCloudProjects);
            if (!devCloudProjects.available()) {
                devCloudProjects.fetch(true, null);
                return new Object[]{FetchingRemoteDataNode.INSTANCE};
            }
            return ListFactory.unmodifiable((Collection)((Collection)devCloudProjects.content())).toArray();
        }
        if (element instanceof CloudProject) {
            CloudProject p = (CloudProject)element;
            if (p.isActivated()) {
                CloudProjectServices cps = p.projectServices();
                cps.attach(this.devCloudRemoteDataListener);
                this.remoteDataSet.add((RemoteData<?>)cps);
                if (!cps.available()) {
                    cps.fetch(true, null);
                    return new Object[]{FetchingRemoteDataNode.INSTANCE};
                }
                return ListFactory.unmodifiable((Collection)((Collection)cps.content())).toArray();
            }
            return new Object[0];
        }
        if (element instanceof CloudProjectService) {
            CloudProjectService ps = (CloudProjectService)element;
            if (ps instanceof ScmService) {
                ScmService scmSvc = (ScmService)ps;
                GitRepos gitRepos = scmSvc.gitRepos();
                gitRepos.attach(this.devCloudRemoteDataListener);
                this.remoteDataSet.add((RemoteData<?>)gitRepos);
                if (gitRepos.available()) {
                    ArrayList<Object> ret = new ArrayList<Object>();
                    Object[] objectArray = ((List)gitRepos.content()).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        GitRepoNode gitRepoNode = (GitRepoNode)obj;
                        CloudRepositoryNode repo = gitRepoNode.getRepositoryNode();
                        if (repo != null) {
                            this.gitContentProvider.addToCache(repo);
                            ret.add(repo);
                        } else {
                            ret.add(gitRepoNode);
                        }
                        ++n2;
                    }
                    return ret.toArray();
                }
                gitRepos.fetch(true, null);
                return new Object[]{FetchingRemoteDataNode.INSTANCE};
            }
            if (ps instanceof TaskService) {
                return null;
            }
            if (ps instanceof BuildService) {
                BuildService buildSvc = (BuildService)ps;
                if (DevCloudCore.findBuildServer((BuildService)buildSvc) == null) {
                    return new Object[0];
                }
                BuildPlans buildJobs = buildSvc.buildPlans();
                buildJobs.attach(this.devCloudRemoteDataListener);
                this.remoteDataSet.add((RemoteData<?>)buildJobs);
                if (buildJobs.available()) {
                    return ((List)buildJobs.content()).toArray();
                }
                buildJobs.fetch(true, null);
                return new Object[]{FetchingRemoteDataNode.INSTANCE};
            }
        } else {
            if (element instanceof CloudRepositoryNode) {
                CloudRepositoryNode gitRepoNode = (CloudRepositoryNode)element;
                return this.gitContentProvider.getChildren(gitRepoNode);
            }
            if (element instanceof DcsBuildPlan) {
                DcsBuildPlan plan = (DcsBuildPlan)element;
                DcsBuilds buildsFetcher = plan.dcsBuilds();
                buildsFetcher.attach(this.devCloudRemoteDataListener);
                this.remoteDataSet.add((RemoteData<?>)buildsFetcher);
                if (buildsFetcher.available()) {
                    return ((List)buildsFetcher.content()).toArray();
                }
                buildsFetcher.fetch(true, null);
                return new Object[]{FetchingRemoteDataNode.INSTANCE};
            }
            if (element instanceof ProjectSolutions) {
                List ret = ((ProjectSolutions)element).getSolutions();
                return ret.toArray();
            }
        }
        return Collections.emptyList().toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof DevServiceDesc) {
            return ((DevServiceDesc)element).connection();
        }
        if (element instanceof CloudProject) {
            return ((CloudProject)element).getDevServiceDesc();
        }
        if (element instanceof CloudProjectService) {
            return ((CloudProjectService)element).getCloudProject();
        }
        if (element instanceof GitRepoNode) {
            return ((GitRepoNode)element).getCloudProjectService();
        }
        if (element instanceof CloudRepositoryNode) {
            return this.gitContentProvider.getParent((CloudRepositoryNode)element);
        }
        if (element instanceof ProjectSolutions) {
            return ((ProjectSolutions)element).getGitRepoNode();
        }
        if (element instanceof SolutionNode) {
            return ((SolutionNode)element).getCloudProjSolution();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof SolutionNode || element instanceof IBuild) {
            return false;
        }
        if (element instanceof BuildService) {
            return DevCloudCore.findBuildServer((BuildService)((BuildService)element)) != null;
        }
        if (element instanceof CloudProject) {
            CloudProject p = (CloudProject)element;
            return p.isActivated();
        }
        if (element instanceof CloudProjectService) {
            CloudProjectService ps = (CloudProjectService)element;
            if (ps.getProjectService().getServiceType() != ServiceType.SCM && ps.getProjectService().getServiceType() != ServiceType.TASKS) {
                return false;
            }
            return ((CloudProjectService)element).isActivated();
        }
        if (element instanceof FetchingRemoteDataNode) {
            return false;
        }
        if (element instanceof GitRepoNode) {
            GitRepoNode node = (GitRepoNode)element;
            return node.getRepositoryNode() != null;
        }
        if (element instanceof DevServiceDesc) {
            DevServiceDesc devSvc = (DevServiceDesc)element;
            return devSvc.isActivated();
        }
        return true;
    }

    public void dispose() {
        super.dispose();
        if (this.devCloudRemoteDataListener != null) {
            for (RemoteData<?> rmd : this.remoteDataSet) {
                if (rmd.disposed()) continue;
                rmd.detach(this.devCloudRemoteDataListener);
            }
            this.devCloudRemoteDataListener = null;
        }
        this.gitContentProvider.dispose();
    }
}

