/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.dev.view;

import com.tasktop.c2c.server.cloud.domain.ServiceType;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.CloudProjectService;
import oracle.eclipse.tools.cloud.dev.CloudRepositoryNode;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.GitRepoNode;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.cloud.ui.dev.wizard.AddNewProjectsToCloudWizard;
import oracle.eclipse.tools.cloud.ui.profile.CloudProfileView;
import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.componentcore.internal.util.FacetedProjectUtilities;

public class CloudViewDropAdapterAssistant
extends CommonDropAdapterAssistant {
    private List<IProject> dndElementList;
    private CloudProject cloudProj = null;

    public IStatus validatePluginTransferDrop(IStructuredSelection aDragSelection, Object aDropTarget) {
        this.initializeSelection((ISelection)aDragSelection);
        return this.internalValidate(aDropTarget, this.dndElementList);
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            ISelection s = LocalSelectionTransfer.getTransfer().getSelection();
            this.initializeSelection(s);
            if (this.dndElementList.isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            return this.internalValidate(target, this.dndElementList);
        }
        return Status.CANCEL_STATUS;
    }

    protected void initializeSelection(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            this.dndElementList = Collections.emptyList();
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)s;
        this.dndElementList = new ArrayList<IProject>();
        for (Object data : sel.toList()) {
            IProject project = (IProject)Platform.getAdapterManager().getAdapter(data, IProject.class);
            if (project == null) {
                this.dndElementList = Collections.emptyList();
                return;
            }
            this.dndElementList.add(project);
        }
    }

    protected IStatus internalValidate(Object target, List<IProject> elements) {
        boolean isSourceNode = false;
        if (target instanceof CloudProject) {
            isSourceNode = true;
            this.cloudProj = (CloudProject)target;
        } else if (target instanceof CloudProjectService) {
            CloudProjectService cps = (CloudProjectService)target;
            this.cloudProj = cps.getCloudProject();
            if (cps.getProjectService().getServiceType() == ServiceType.SCM) {
                isSourceNode = true;
            }
        } else if (target instanceof GitRepoNode) {
            GitRepoNode gitRepo = (GitRepoNode)target;
            this.cloudProj = gitRepo.getCloudProjectService().getCloudProject();
            isSourceNode = true;
        } else if (target instanceof CloudRepositoryNode) {
            CloudRepositoryNode cnode = (CloudRepositoryNode)target;
            GitRepoNode gitRepo = cnode.getGitRepoNode();
            this.cloudProj = gitRepo.getCloudProjectService().getCloudProject();
            isSourceNode = true;
        }
        if (isSourceNode) {
            for (IProject project : elements) {
                String cloudProjId = DevCloudCore.findCloudProjectIdFor((IProject)project);
                if (cloudProjId == null) continue;
                return Status.CANCEL_STATUS;
            }
            this.clear();
            return Status.OK_STATUS;
        }
        this.clear();
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        if (dropTargetEvent.data instanceof TreeSelection && this.dndElementList == null) {
            this.dndElementList = new ArrayList<IProject>();
            for (Object data : ((TreeSelection)dropTargetEvent.data).toList()) {
                String cloudProjId;
                IProject project = (IProject)Platform.getAdapterManager().getAdapter(data, IProject.class);
                if (project == null || (cloudProjId = DevCloudCore.findCloudProjectIdFor((IProject)project)) != null) continue;
                this.dndElementList.add(project);
            }
            IStatus status = this.internalHandleDrop(target);
            if (status.isOK()) {
                dropTargetEvent.detail = 0;
            }
            return status;
        }
        return Status.OK_STATUS;
    }

    public IStatus handlePluginTransferDrop(IStructuredSelection aDragSelection, Object aDropTarget) {
        return this.internalHandleDrop(aDropTarget);
    }

    protected IStatus internalHandleDrop(Object target) {
        boolean success = false;
        String remoteUrl = null;
        if (target instanceof GitRepoNode) {
            GitRepoNode gpn = (GitRepoNode)target;
            remoteUrl = gpn.getUrl();
        } else if (target instanceof CloudRepositoryNode) {
            CloudRepositoryNode cnode = (CloudRepositoryNode)target;
            GitRepoNode gitRepo = cnode.getGitRepoNode();
            remoteUrl = gitRepo.getUrl();
        }
        if (this.cloudProj != null) {
            if (remoteUrl == null) {
                final ArrayList urls = new ArrayList();
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask("Connecting to remote Git repository...", -1);
                        urls.addAll(CloudViewDropAdapterAssistant.this.cloudProj.getRemoteGitUrls());
                    }
                };
                try {
                    new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, false, op);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (urls.size() == 1) {
                    remoteUrl = (String)urls.get(0);
                } else {
                    String msg = "Multiple Git repositories have been found. Please drag the project to the target Git repo.";
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)msg);
                    return CloudPlugin.createErrorStatus((String)msg, null);
                }
            }
            success = true;
            if (this.dndElementList != null && !this.doTakeProjectToCloudAction(this.cloudProj, remoteUrl)) {
                success = false;
            }
        }
        this.clear();
        return success ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }

    private void clear() {
        this.dndElementList = null;
    }

    private Set<IProject> constructProjectList(String remoteUrl) throws CoreException {
        LinkedHashSet<IProject> projectsToPush = new LinkedHashSet<IProject>();
        if (this.dndElementList.size() > 0) {
            for (IProject p : this.dndElementList) {
                projectsToPush.add(p);
            }
            LinkedList<IProject> list = new LinkedList<IProject>();
            for (IProject p : this.dndElementList) {
                String cloudProjId = DevCloudCore.findCloudProjectIdFor((IProject)p);
                if (cloudProjId != null) continue;
                if (WtpProjectUtil.isEarProject((IProject)p)) {
                    this.checkProject(p, remoteUrl);
                    list.addFirst(p);
                    for (IProject childModule : WtpProjectUtil.findProjectsReferencedByEar((IProject)p)) {
                        this.checkProject(childModule, remoteUrl);
                    }
                    continue;
                }
                if (JavaProjectUtil.isJavaProject((IProject)p)) {
                    this.checkProject(p, remoteUrl);
                    Set parentProjects = WtpProjectUtil.findReferencingEarProjects((IProject)p);
                    if (parentProjects.size() > 0) {
                        boolean parentProjectIncluded = false;
                        for (IProject parentProj : parentProjects) {
                            cloudProjId = DevCloudCore.findCloudProjectIdFor((IProject)p);
                            if (cloudProjId != null || !projectsToPush.contains(parentProj)) continue;
                            parentProjectIncluded = true;
                            break;
                        }
                        if (parentProjectIncluded) continue;
                        list.add(p);
                        continue;
                    }
                    list.add(p);
                    continue;
                }
                this.checkProject(p, remoteUrl);
                list.addLast(p);
            }
            for (IProject p : list) {
                projectsToPush.add(p);
            }
        }
        return projectsToPush;
    }

    private void checkProject(IProject p, String remoteUrl) throws CoreException {
        File projDir;
        File root;
        if (FacetedProjectUtilities.isProjectOfType((IProject)p, (String)"oracle.coherence.gar")) {
            String message = String.format("Maven build is not supported on Coherence project: '%s'. ", p.getName());
            message = String.valueOf(message) + "Do you want to continue and push it as Java project?";
            if (!MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Warning", (String)message)) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
        if ((root = DevCloudCore.getLocalGitRoot((String)remoteUrl)).exists() && (projDir = new File(root, p.getName())).exists()) {
            String msg = String.format("Project '%s' already existings in Git repository.", p.getName());
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)msg);
            throw new RuntimeException(msg);
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorRef = iEditorReferenceArray[n2];
            try {
                FileEditorInput fin;
                IEditorInput in = editorRef.getEditorInput();
                if (in instanceof FileEditorInput && p == (fin = (FileEditorInput)in).getFile().getProject()) {
                    page.closeEditor(editorRef.getEditor(false), true);
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    protected boolean doTakeProjectToCloudAction(CloudProject cloudProject, String remoteUrl) {
        if (this.dndElementList.size() > 0) {
            try {
                final Set<IProject> projectToPush = this.constructProjectList(remoteUrl);
                AddNewProjectsToCloudWizard wizard = new AddNewProjectsToCloudWizard();
                wizard.setProjectsToPush(projectToPush, cloudProject, remoteUrl);
                WizardDialog dlg = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                if (dlg.open() == 0) {
                    WorkspaceJob job = new WorkspaceJob("Refresh"){

                        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                            for (IProject project : projectToPush) {
                                project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule(1000L);
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    CloudProfileView cloudView = (CloudProfileView)page.findView("oracle.eclipse.tools.cloud.ui.CloudProfileView");
                    cloudView.refresh(cloudProject);
                    return true;
                }
            }
            catch (CoreException e) {
                if (e.getStatus() == Status.CANCEL_STATUS) {
                    return false;
                }
                CloudUiPlugin.log((Exception)((Object)e));
            }
            catch (Exception e) {
                CloudUiPlugin.log(e);
            }
        }
        return false;
    }
}

