/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.dev.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.IGitConfig;
import oracle.eclipse.tools.cloud.dev.IHudsonConfig;
import oracle.eclipse.tools.cloud.dev.IMavenConfig;
import oracle.eclipse.tools.cloud.dev.IModulePomGenConfig;
import oracle.eclipse.tools.cloud.dev.IPushProjectsToCloudOp;
import oracle.eclipse.tools.cloud.dev.internal.GitCommitUtil;
import oracle.eclipse.tools.cloud.maven.pom.IMavenProjectModel;
import oracle.eclipse.tools.cloud.maven.pom.PomModelFactory;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.cloud.ui.dev.wizard.CommitMessageDialog;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.ui.internal.commit.CommitHelper;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.componentcore.ComponentCore;

public class SyncProjectsWithDevCloudAction
implements IObjectActionDelegate {
    private Set<IProject> selectedProjects = new HashSet<IProject>();
    private Repository repository;

    public void setActivePart(IAction action, IWorkbenchPart part) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedProjects.clear();
        this.repository = null;
        ICloudProfile cloudTarget = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ts = (IStructuredSelection)selection;
            Object[] objectArray = ts.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof IProject) {
                    IProject project = (IProject)obj;
                    cloudTarget = DevCloudCore.getConnection((IProject)project);
                    if (cloudTarget == null) {
                        action.setEnabled(false);
                        return;
                    }
                    Repository gitRepo = GitCommitUtil.getRepositoriesFor((IProject)project);
                    if (gitRepo == null) {
                        action.setEnabled(false);
                        return;
                    }
                    if (this.repository != null) {
                        if (this.repository != gitRepo) {
                            action.setEnabled(false);
                            return;
                        }
                    } else {
                        this.repository = gitRepo;
                    }
                } else {
                    action.setEnabled(false);
                    return;
                }
                this.selectedProjects.add((IProject)obj);
                ++n2;
            }
            action.setEnabled(true);
            return;
        }
        action.setEnabled(false);
    }

    public void run(IAction action) {
        if (this.selectedProjects.size() > 0) {
            SyncProjectsWithDevCloudAction.saveAllEditors();
            String commitMessage = null;
            String previousCommitMsgs = null;
            GitCommitUtil util = new GitCommitUtil(this.repository, (IResource[])this.selectedProjects.toArray(new IProject[this.selectedProjects.size()]), false);
            if (!util.prepareCommit((IProgressMonitor)new NullProgressMonitor())) {
                boolean result = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"No files to commit", (String)"No changed items were found. Do you wish to continue and amend the last commit?");
                if (!result) {
                    return;
                }
                CommitHelper.CommitInfo headCommitInfo = CommitHelper.getHeadCommitInfo((Repository)this.repository);
                previousCommitMsgs = headCommitInfo.getCommitMessage();
            }
            IProject project = this.selectedProjects.iterator().next();
            String cloudProjId = DevCloudCore.findCloudProjectIdFor((IProject)project);
            ICloudProfile cloudTarget = DevCloudCore.getConnection((IProject)project);
            try {
                Repository repo = GitCommitUtil.getRepositoriesFor((IProject)project);
                if (commitMessage == null) {
                    commitMessage = SyncProjectsWithDevCloudAction.getCommitMessage(repo, previousCommitMsgs);
                }
                if (commitMessage == null) {
                    return;
                }
                IStatus sts = SyncProjectsWithDevCloudAction.syncProjects(this.selectedProjects, cloudProjId, cloudTarget, commitMessage);
                sts.isOK();
            }
            catch (Exception e) {
                CloudUiPlugin.log(e);
            }
        }
    }

    static String getCommitMessage(Repository repo, String msg) {
        CommitMessageDialog wizard = new CommitMessageDialog(repo, msg);
        WizardDialog dlg = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        if (dlg.open() == 0) {
            return wizard.getCommitMsg();
        }
        return null;
    }

    public static IStatus syncProjects(final Set<IProject> selectedProjects, final String cloudProjId, final ICloudProfile cloudTarget, final String commitMessage) {
        final Status[] status = new Status[1];
        final IProject project = selectedProjects.iterator().next();
        try {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("oracle.eclipse.tools.cloud");
                    monitor.beginTask("Synchronize projects ", 10);
                    IPushProjectsToCloudOp modelElm = (IPushProjectsToCloudOp)IPushProjectsToCloudOp.TYPE.instantiate();
                    modelElm.setProjectsToPush(selectedProjects);
                    modelElm.setCloudProjectId(cloudProjId.toLowerCase());
                    monitor.worked(1);
                    String connectionName = (String)cloudTarget.getConnectionName().content();
                    modelElm.setConnectionName(connectionName);
                    monitor.worked(1);
                    URIish uri = DevCloudCore.getRemoteGitUrl((IProject)project).setUser(null);
                    String remoteGitUrl = uri.toString();
                    IGitConfig gitCfg = modelElm.getGitConfig();
                    gitCfg.setCommitMessage(commitMessage);
                    gitCfg.setRemoteUrl(remoteGitUrl);
                    IHudsonConfig hudsonCfg = modelElm.getHudsonConfig();
                    String updateHudsonJobs = pref.get("CreateHudsonJob", "false");
                    hudsonCfg.setCreateHudsonBuildJob(updateHudsonJobs);
                    monitor.worked(1);
                    if (OracleCloudTools.isDebugMode()) {
                        System.out.println("GIT repo URL: " + remoteGitUrl);
                    }
                    if (ComponentCore.createComponent((IProject)project) != null) {
                        IFile pom = project.getFile("pom.xml");
                        String existingGroupId = null;
                        if (pom.exists()) {
                            try {
                                IMavenProjectModel pomModel = PomModelFactory.loadWorkspaceFile((IFile)pom);
                                existingGroupId = (String)pomModel.getGroupId().content();
                                pomModel.dispose();
                            }
                            catch (ResourceStoreException resourceStoreException) {}
                        }
                        String mavenGroupId = pref.get("DevCloudGroupId", null);
                        if (existingGroupId == null && (mavenGroupId == null || mavenGroupId.length() == 0)) {
                            final String[] groupId = new String[1];
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    InputDialog dlg = new InputDialog(Display.getDefault().getActiveShell(), "Maven group ID", "Please specify a Maven group ID", "group1", new IInputValidator(){

                                        public String isValid(String newText) {
                                            if (!JavaConventions.validatePackageName((String)newText).isOK()) {
                                                return "The Maven group ID is not valid.";
                                            }
                                            return null;
                                        }
                                    });
                                    if (dlg.open() != 0) {
                                        return;
                                    }
                                    groupId[0] = dlg.getValue();
                                }
                            });
                            if (groupId[0] == null) {
                                throw new InvocationTargetException(new Exception("Push to Cloud operation canceled."));
                            }
                            mavenGroupId = groupId[0];
                            pref.put("DevCloudGroupId", mavenGroupId);
                        }
                        IMavenConfig mavenConfig = modelElm.getMavenBuildArtifactsGenConfig();
                        mavenConfig.setGroupId(mavenGroupId);
                        if (OracleCloudTools.isDebugMode()) {
                            System.out.println("Maven repo URL: " + (String)mavenConfig.getMavenRepositoryUrl().content());
                        }
                        String val = pref.get("GenerateMavenBuildFile", "true");
                        mavenConfig.setGenerateBuildFiles(Boolean.valueOf(val));
                        monitor.worked(1);
                        Set list = WtpProjectUtil.findReferencedProjects((IProject)project);
                        for (IProject p : list) {
                            ElementList modulePomGenCfgList = mavenConfig.getProjectModules();
                            IModulePomGenConfig modulePomGenCfg = (IModulePomGenConfig)modulePomGenCfgList.insert();
                            modulePomGenCfg.setProjectName(p.getName());
                            IFile pomFile = p.getFile("pom.xml");
                            if (pomFile.exists()) {
                                try {
                                    IMavenProjectModel pomModel = PomModelFactory.loadWorkspaceFile((IFile)pomFile);
                                    modulePomGenCfg.setArtifactId((String)pomModel.getArtifactId().content());
                                    continue;
                                }
                                catch (ResourceStoreException resourceStoreException) {}
                            }
                            modulePomGenCfg.setArtifactId(p.getName());
                        }
                    }
                    status[0] = modelElm.execute(ProgressMonitorBridge.create((IProgressMonitor)monitor));
                    monitor.done();
                }
            };
            Shell activeShell = Display.getDefault().getActiveShell();
            new ProgressMonitorDialog(activeShell).run(true, true, op);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            status[0] = StatusBridge.create((IStatus)CloudPlugin.createErrorStatus((String)"Error pushing projects to Cloud", (Exception)e));
        }
        catch (InterruptedException interruptedException) {}
        return StatusBridge.create((Status)status[0]);
    }

    private static void saveAllEditors() {
        IProject[] projs;
        ArrayList<IProject> list = new ArrayList<IProject>();
        IProject[] iProjectArray = projs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projs.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (p.isOpen()) {
                list.add(p);
            }
            ++n2;
        }
        IResource[] resourceRoots = new IResource[list.size()];
        int i = 0;
        while (i < list.size()) {
            resourceRoots[i] = (IResource)list.get(i);
            ++i;
        }
        IDE.saveAllEditors((IResource[])resourceRoots, (boolean)true);
    }
}

