/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.dev.action;

import com.tasktop.c2c.server.cloud.domain.ServiceType;
import com.tasktop.c2c.server.profile.domain.project.ProjectService;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.CloudRepositoryNode;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.GitRepoNode;
import oracle.eclipse.tools.cloud.dev.ProjectSolutions;
import oracle.eclipse.tools.cloud.dev.SolutionNode;
import oracle.eclipse.tools.cloud.dev.internal.GitCommitUtil;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.ui.dev.action.SyncProjectsWithDevCloudAction;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.ui.internal.commit.CommitHelper;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.common.componentcore.ComponentCore;

public class SyncCloudProjectActionDelegate
implements IViewActionDelegate {
    private Object element = null;

    public void run(IAction action) {
        if (this.element != null) {
            SolutionNode node;
            CloudProject cp = null;
            GitRepoNode gitRepo = null;
            if (this.element instanceof CloudProject) {
                cp = (CloudProject)this.element;
            } else if (this.element instanceof CloudRepositoryNode) {
                gitRepo = ((CloudRepositoryNode)this.element).getGitRepoNode();
                cp = gitRepo.getCloudProjectService().getCloudProject();
            } else if (this.element instanceof SolutionNode) {
                node = (SolutionNode)this.element;
                cp = node.getCloudProj();
            } else if (this.element instanceof ProjectSolutions) {
                node = (ProjectSolutions)this.element;
                cp = node.getCloudProject();
                gitRepo = node.getGitRepoNode();
            }
            try {
                HashSet<IProject> refProjects = new HashSet<IProject>();
                Set<IProject> projects = this.getWorkspaceProjects(cp, gitRepo, refProjects);
                if (!projects.iterator().hasNext()) {
                    return;
                }
                String commitMessage = null;
                Repository repo = GitCommitUtil.getRepositoriesFor((IProject)projects.iterator().next());
                GitCommitUtil util = new GitCommitUtil(repo, (IResource[])projects.toArray(new IProject[projects.size()]), false);
                if (!util.prepareCommit((IProgressMonitor)new NullProgressMonitor())) {
                    boolean result = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"No files to commit", (String)"No changed items were found. Do you wish to continue and amend the last commit?");
                    if (!result) {
                        return;
                    }
                    Repository repository = GitCommitUtil.getRepositoriesFor((IProject)projects.iterator().next());
                    CommitHelper.CommitInfo headCommitInfo = CommitHelper.getHeadCommitInfo((Repository)repository);
                    commitMessage = headCommitInfo.getCommitMessage();
                }
                if ((commitMessage = SyncProjectsWithDevCloudAction.getCommitMessage(repo, commitMessage)) == null) {
                    return;
                }
                String cloudProjectId = cp.getProject().getIdentifier();
                IStatus sts = SyncProjectsWithDevCloudAction.syncProjects(projects, cloudProjectId, cp.getProfile(), commitMessage);
                if (sts == Status.CANCEL_STATUS) {
                    return;
                }
                if (!sts.isOK()) {
                    String message = sts.getMessage();
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)message);
                    return;
                }
            }
            catch (Exception e) {
                String message = e.getMessage();
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)message);
            }
        }
    }

    private Set<IProject> getWorkspaceProjects(CloudProject cp, GitRepoNode gitRepo, Set<IProject> refProjects) {
        if (cp == null) {
            return Collections.emptySet();
        }
        String gitUrl = null;
        for (ProjectService ps : cp.getProject().getProjectServices()) {
            if (!ps.getServiceType().equals((Object)ServiceType.SCM)) continue;
            gitUrl = ps.getUrl();
            break;
        }
        if (gitUrl == null) {
            return Collections.emptySet();
        }
        String targetCloudProjId = cp.getProject().getIdentifier();
        HashSet<IProject> projects = new HashSet<IProject>();
        ICloudProfile profile = cp.getProfile();
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] iProjectArray = root.getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                URIish remoteGitUrl;
                String path;
                String gitRepoUrl;
                String cloudProjId;
                IProject proj = iProjectArray[n2];
                ICloudProfile projCloudTarget = DevCloudCore.getConnection((IProject)proj);
                if (projCloudTarget == profile && (cloudProjId = DevCloudCore.findCloudProjectIdFor((IProject)proj)) != null && cloudProjId.toLowerCase().indexOf(targetCloudProjId.toLowerCase()) >= 0 && (gitRepo == null || (gitRepoUrl = gitRepo.getUrl()).indexOf(path = (remoteGitUrl = DevCloudCore.getRemoteGitUrl((IProject)proj)).getPath()) >= 0)) {
                    projects.add(proj);
                    if (ComponentCore.createComponent((IProject)proj) != null) {
                        Set refs = WtpProjectUtil.findReferencedProjects((IProject)proj);
                        for (IProject refp : refs) {
                            if (refp == proj) continue;
                            refProjects.add(refp);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)message);
        }
        return projects;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable = false;
        TreeSelection ts = null;
        ts = (TreeSelection)selection;
        if (ts.size() == 1) {
            this.element = ts.getFirstElement();
            if (this.element instanceof IProject) {
                enable = false;
            } else {
                SolutionNode node;
                CloudProject cp = null;
                GitRepoNode gitRepo = null;
                if (this.element instanceof CloudProject) {
                    cp = (CloudProject)this.element;
                } else if (this.element instanceof CloudRepositoryNode) {
                    gitRepo = ((CloudRepositoryNode)this.element).getGitRepoNode();
                    cp = gitRepo.getCloudProjectService().getCloudProject();
                } else if (this.element instanceof SolutionNode) {
                    node = (SolutionNode)this.element;
                    cp = node.getCloudProj();
                } else if (this.element instanceof ProjectSolutions) {
                    node = (ProjectSolutions)this.element;
                    cp = node.getCloudProject();
                    gitRepo = node.getGitRepoNode();
                }
                HashSet<IProject> refProjects = new HashSet<IProject>();
                Set<IProject> projects = this.getWorkspaceProjects(cp, gitRepo, refProjects);
                enable = projects.size() > 0;
            }
        }
        action.setEnabled(enable);
    }

    public void init(IViewPart view) {
    }
}

