/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.dev.action;

import java.io.File;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.command.OpenInEditorCommand;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;

public class OpenFileInEditorCommand
extends OpenInEditorCommand {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart viewPart = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        FileNode node = (FileNode)this.getSelectedNodes(event).get(0);
        Path path = new Path(((File)node.getObject()).getAbsolutePath());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (file == null) {
            IFileStore store = EFS.getLocalFileSystem().getStore((IPath)path);
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)viewPart.getSite().getPage(), (IFileStore)store);
            }
            catch (PartInitException e) {
                Activator.handleError((String)UIText.RepositoriesView_Error_WindowTitle, (Throwable)e, (boolean)true);
            }
        } else {
            try {
                IDE.openEditor((IWorkbenchPage)viewPart.getSite().getPage(), (IFile)file);
            }
            catch (PartInitException e) {
                Activator.handleError((String)UIText.RepositoriesView_Error_WindowTitle, (Throwable)e, (boolean)true);
            }
        }
        return null;
    }
}

