/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.ui.dev.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.cloud.dev.ProjectSolutions;
import oracle.eclipse.tools.cloud.dev.SolutionNode;
import oracle.eclipse.tools.cloud.ui.CloudUiPlugin;
import oracle.eclipse.tools.cloud.ui.profile.CloudProfileView;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.ProjectRecord;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ImportProjectActionDelegate
implements IViewActionDelegate {
    CloudProfileView cloudView = null;
    List<SolutionNode> elements = new ArrayList<SolutionNode>();
    private boolean running = false;

    public void run(IAction action) {
        this.running = true;
        if (!this.elements.isEmpty()) {
            int size = this.elements.size();
            int index = 0;
            while (index < size) {
                ImportProjectActionDelegate.importProject(this.elements.get(index));
                ++index;
            }
            ProjectSolutions ps = this.elements.get(0).getCloudProjSolution();
            this.cloudView.refresh(ps);
            this.cloudView.getViewer().setExpandedState((Object)ps, true);
        }
        this.running = false;
    }

    public static void importProject(final SolutionNode node) {
        IRunnableWithProgress prog = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    ImportProjectActionDelegate.createExistingProject(node.getProjRec(), true, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        ProgressMonitorDialog pd = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        try {
            pd.run(false, false, prog);
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)e.getCause().getMessage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.running) {
            return;
        }
        TreeSelection ts = (TreeSelection)selection;
        Object lastSegment = null;
        this.elements.clear();
        for (Object obj : ts) {
            if (!(obj instanceof SolutionNode)) continue;
            TreePath[] path = ts.getPaths();
            TreePath path1 = path[0];
            TreePath tp = path1.getParentPath().getParentPath();
            if (lastSegment == null) {
                lastSegment = tp.getLastSegment();
            }
            if (lastSegment != tp.getLastSegment()) {
                this.elements.clear();
                break;
            }
            this.elements.add((SolutionNode)obj);
        }
        action.setEnabled(!this.elements.isEmpty());
    }

    public void init(IViewPart view) {
        this.cloudView = (CloudProfileView)view;
    }

    private static IProject createExistingProject(ProjectRecord record, boolean open, IProgressMonitor monitor) throws CoreException {
        String projectName = record.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (project.exists()) {
            String msg = String.format("Project '%s' already exists in workspace. ", project.getName());
            throw new CoreException(CloudUiPlugin.createErrorStatus(msg, null));
        }
        if (record.getProjectDescription() == null) {
            record.setProjectDescription(workspace.newProjectDescription(projectName));
            Path locationPath = new Path(record.getProjectSystemFile().getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                record.getProjectDescription().setLocation(null);
            } else {
                record.getProjectDescription().setLocation((IPath)locationPath);
            }
        } else {
            record.getProjectDescription().setName(projectName);
        }
        try {
            monitor.beginTask(UIText.WizardProjectsImportPage_CreateProjectsTask, 100);
            project.create(record.getProjectDescription(), (IProgressMonitor)new SubProgressMonitor(monitor, 30));
            project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            IProject iProject = project;
            return iProject;
        }
        finally {
            monitor.done();
        }
    }
}

