/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.TransformerAnnotation;

abstract class EclipseLinkSourceTransformerAnnotation
extends SourceAnnotation
implements TransformerAnnotation {
    final DeclarationAnnotationElementAdapter<String> transformerClassDeclarationAdapter;
    final AnnotationElementAdapter<String> transformerClassAdapter;
    String transformerClass;
    TextRange transformerClassTextRange;
    final DeclarationAnnotationElementAdapter<String> methodDeclarationAdapter;
    final AnnotationElementAdapter<String> methodAdapter;
    String method;
    TextRange methodTextRange;

    EclipseLinkSourceTransformerAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        super((JavaResourceModel)parent, element, daa);
        this.transformerClassDeclarationAdapter = new ConversionDeclarationAnnotationElementAdapter(daa, this.getTransformerClassElementName(), SimpleTypeStringExpressionConverter.instance());
        this.transformerClassAdapter = new AnnotatedElementAnnotationElementAdapter(element, this.transformerClassDeclarationAdapter);
        this.methodDeclarationAdapter = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)this.getMethodElementName());
        this.methodAdapter = new AnnotatedElementAnnotationElementAdapter(element, this.methodDeclarationAdapter);
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.transformerClass = this.buildTransformerClass(astAnnotation);
        this.transformerClassTextRange = this.buildTransformerClassTextRange(astAnnotation);
        this.method = this.buildMethod(astAnnotation);
        this.methodTextRange = this.buildMethodTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncTransformerClass(this.buildTransformerClass(astAnnotation));
        this.transformerClassTextRange = this.buildTransformerClassTextRange(astAnnotation);
        this.syncMethod(this.buildMethod(astAnnotation));
        this.methodTextRange = this.buildMethodTextRange(astAnnotation);
    }

    public boolean isUnset() {
        return super.isUnset() && this.transformerClass == null && this.method == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.transformerClass);
    }

    public String getTransformerClass() {
        return this.transformerClass;
    }

    public void setTransformerClass(String transformerClass) {
        if (ObjectTools.notEquals((Object)this.transformerClass, (Object)transformerClass)) {
            this.transformerClass = transformerClass;
            this.transformerClassAdapter.setValue((Object)transformerClass);
        }
    }

    private void syncTransformerClass(String astTransformerClass) {
        String old = this.transformerClass;
        this.transformerClass = astTransformerClass;
        this.firePropertyChanged("transformerClass", old, astTransformerClass);
    }

    private String buildTransformerClass(Annotation astAnnotation) {
        return (String)this.transformerClassAdapter.getValue(astAnnotation);
    }

    public TextRange getTransformerClassTextRange() {
        return this.transformerClassTextRange;
    }

    private TextRange buildTransformerClassTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.transformerClassDeclarationAdapter, astAnnotation);
    }

    abstract String getTransformerClassElementName();

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        if (ObjectTools.notEquals((Object)this.method, (Object)method)) {
            this.method = method;
            this.methodAdapter.setValue((Object)method);
        }
    }

    private void syncMethod(String astMethod) {
        String old = this.method;
        this.method = astMethod;
        this.firePropertyChanged("method", old, astMethod);
    }

    private String buildMethod(Annotation astAnnotation) {
        return (String)this.methodAdapter.getValue(astAnnotation);
    }

    public TextRange getMethodTextRange() {
        return this.methodTextRange;
    }

    private TextRange buildMethodTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.methodDeclarationAdapter, astAnnotation);
    }

    abstract String getMethodElementName();
}

