/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.java.JavaGeneratorContainer;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaGeneratorContainer;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkGeneratorContainer;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaUuidGenerator;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.EclipseLinkJavaUuidGeneratorImpl;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.UuidGeneratorAnnotation2_4;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkJavaGeneratorContainer
extends GenericJavaGeneratorContainer
implements EclipseLinkGeneratorContainer {
    protected EclipseLinkJavaUuidGenerator uuidGenerator = this.buildUuidGenerator();

    public EclipseLinkJavaGeneratorContainer(JavaGeneratorContainer.Parent parentAdapter) {
        super(parentAdapter);
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncUuidGenerator();
    }

    public void update() {
        super.update();
        if (this.uuidGenerator != null) {
            this.uuidGenerator.update();
        }
    }

    @Override
    public EclipseLinkJavaUuidGenerator getUuidGenerator() {
        return this.uuidGenerator;
    }

    @Override
    public EclipseLinkJavaUuidGenerator addUuidGenerator() {
        if (this.uuidGenerator != null) {
            throw new IllegalStateException("UUID generator already exists: " + this.uuidGenerator);
        }
        UuidGeneratorAnnotation2_4 annotation = this.buildUuidGeneratorAnnotation();
        EclipseLinkJavaUuidGenerator generator = this.buildUuidGenerator(annotation);
        this.setUuidGenerator(generator);
        return generator;
    }

    protected UuidGeneratorAnnotation2_4 buildUuidGeneratorAnnotation() {
        return (UuidGeneratorAnnotation2_4)((JavaGeneratorContainer.Parent)this.parent).getResourceAnnotatedElement().addAnnotation("org.eclipse.persistence.annotations.UuidGenerator");
    }

    @Override
    public void removeUuidGenerator() {
        if (this.uuidGenerator == null) {
            throw new IllegalStateException("UUID generator does not exist");
        }
        ((JavaGeneratorContainer.Parent)this.parent).getResourceAnnotatedElement().removeAnnotation("org.eclipse.persistence.annotations.UuidGenerator");
        this.setUuidGenerator(null);
    }

    protected EclipseLinkJavaUuidGenerator buildUuidGenerator() {
        UuidGeneratorAnnotation2_4 annotation = this.getUuidGeneratorAnnotation();
        return annotation == null ? null : this.buildUuidGenerator(annotation);
    }

    protected UuidGeneratorAnnotation2_4 getUuidGeneratorAnnotation() {
        return (UuidGeneratorAnnotation2_4)((JavaGeneratorContainer.Parent)this.parent).getResourceAnnotatedElement().getAnnotation("org.eclipse.persistence.annotations.UuidGenerator");
    }

    protected EclipseLinkJavaUuidGenerator buildUuidGenerator(UuidGeneratorAnnotation2_4 uuidGeneratorAnnotation) {
        return ((JavaGeneratorContainer.Parent)this.parent).supportsGenerators() ? new EclipseLinkJavaUuidGeneratorImpl(this, uuidGeneratorAnnotation) : null;
    }

    protected void syncUuidGenerator() {
        UuidGeneratorAnnotation2_4 annotation = this.getUuidGeneratorAnnotation();
        if (annotation == null) {
            if (this.uuidGenerator != null) {
                this.setUuidGenerator(null);
            }
        } else if (this.uuidGenerator != null && this.uuidGenerator.getGeneratorAnnotation() == annotation) {
            this.uuidGenerator.synchronizeWithResourceModel();
        } else {
            this.setUuidGenerator(this.buildUuidGenerator(annotation));
        }
    }

    protected void setUuidGenerator(EclipseLinkJavaUuidGenerator uuidGenerator) {
        EclipseLinkJavaUuidGenerator old = this.uuidGenerator;
        this.uuidGenerator = uuidGenerator;
        this.firePropertyChanged("uuidGenerator", old, uuidGenerator);
    }

    public Iterable<String> getCompletionProposals(int pos) {
        Iterable result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.uuidGenerator != null && (result = this.uuidGenerator.getCompletionProposals(pos)) != null) {
            return result;
        }
        return null;
    }

    protected Iterable<Generator> getGenerators_() {
        return IterableTools.iterable((Object[])new Generator[]{this.sequenceGenerator, this.tableGenerator, this.uuidGenerator});
    }
}

