/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.webapp.javasrc;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.webapp.javasrc.ParentAndResource;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.Activator;
import oracle.eclipse.tools.webtier.common.services.webapp.javasrc.JDTUtil;
import oracle.eclipse.tools.webtier.common.services.webapp.javasrc.JarParentAndResource;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;

public class JarUriAndParentResolver {
    private final IProject _project;
    private final List<IPackageFragmentRoot> _jarRoots;

    public JarUriAndParentResolver(IProject project) {
        this._project = project;
        this._jarRoots = JDTUtil.getJarRoots(this._project, 1);
    }

    public Set<ParentAndResource> getResources(String fileExtension) {
        Assert.isNotNull((Object)fileExtension);
        HashSet<ParentAndResource> result = new HashSet<ParentAndResource>();
        try {
            for (IPackageFragmentRoot jarRoot : this._jarRoots) {
                Object[] resources = jarRoot.getNonJavaResources();
                this.addResources(resources, fileExtension, result);
                IJavaElement[] iJavaElementArray = jarRoot.getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragment pkg;
                    IJavaElement elem = iJavaElementArray[n2];
                    if (elem.getElementType() == 4 && (pkg = (IPackageFragment)elem).exists()) {
                        this.addResources(pkg.getNonJavaResources(), fileExtension, result);
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)((Object)e));
        }
        return result;
    }

    protected void addResources(Object[] nonJavaResources, String fileExtension, Set<ParentAndResource> paths) {
        Assert.isNotNull((Object)fileExtension);
        Object[] objectArray = nonJavaResources;
        int n = nonJavaResources.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path;
            IJarEntryResource jarEntry;
            Object object = objectArray[n2];
            if (object instanceof IJarEntryResource && (jarEntry = (IJarEntryResource)object).isFile() && fileExtension.equalsIgnoreCase((path = jarEntry.getFullPath()).getFileExtension())) {
                paths.add(new JarParentAndResource(this.getParentPath(jarEntry), path.makeRelative()));
            }
            ++n2;
        }
    }

    protected IPath getParentPath(IJarEntryResource jarEntry) {
        IPackageFragmentRoot root = jarEntry.getPackageFragmentRoot();
        return root == null ? null : root.getPath();
    }
}

