/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.webapp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IAppClassLoaderProvider;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.util.FileUtil;
import oracle.eclipse.tools.application.common.services.util.LogMgr;
import oracle.eclipse.tools.application.common.services.util.UrlUtil;
import oracle.eclipse.tools.application.common.services.webapp.javasrc.ParentAndResource;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.util.ObjectUtil;
import oracle.eclipse.tools.common.services.util.StringUtil;
import oracle.eclipse.tools.webtier.common.services.webapp.Localizer;
import oracle.eclipse.tools.webtier.common.services.webapp.javasrc.JDTUtil;
import oracle.eclipse.tools.webtier.common.services.webapp.javasrc.JarUriAndParentResolver;
import oracle.eclipse.tools.webtier.common.services.webapp.javasrc.JarUriResolver;
import oracle.eclipse.tools.webtier.common.services.webapp.javasrc.JavaSrcUriAndParentResolver;
import oracle.eclipse.tools.webtier.common.services.webapp.javasrc.JavaSrcUriResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public abstract class JavaLocalizer
extends Localizer {
    private static final boolean DEBUG = false;

    public JavaLocalizer(Project project, Localizer.ChangeNotifierControl notifierControl) {
        super(project.getEclipseProject(), notifierControl);
    }

    public JavaLocalizer(Project project) {
        super(project);
    }

    private Collection<URL> getBundleUrls(String basename, File rsrcDir, Collection<String> extensions) {
        ArrayList<URL> bundleUrls = new ArrayList<URL>(2);
        String translatedBaseName = ObjectUtil.getClassName((String)basename);
        File[] files = rsrcDir.listFiles();
        if (files == null) {
            return bundleUrls;
        }
        int count = files.length;
        int i = 0;
        while (i < count) {
            String localeStr;
            String fileName;
            String extension;
            File file = files[i];
            if (file.isFile() && (extension = FileUtil.getFileExtension((String)(fileName = file.getName()))) != null && extensions.contains(extension) && (fileName = FileUtil.removeFileExtension((String)fileName)).startsWith(translatedBaseName) && ((localeStr = fileName.substring(translatedBaseName.length())).length() == 0 || localeStr.charAt(0) == '_')) {
                try {
                    bundleUrls.add(file.toURL());
                }
                catch (MalformedURLException ex) {
                    LogMgr.getUnhandledExceptionLogger().error("JavaLocalizer.getBundleFiles", ex);
                }
            }
            ++i;
        }
        return bundleUrls;
    }

    /*
     * Exception decompiling
     */
    private Collection<URL> getBundleUrls(String basename, URL url, Collection<String> extensions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void getBundleLocales(String baseName, Collection<URL> bundleUrls, Collection<Locale> locales) {
        for (URL url : bundleUrls) {
            Locale locale = this.getLocaleFromUrl(url, baseName);
            if (locale == null || locales.contains(locale)) continue;
            locales.add(locale);
        }
    }

    protected final Locale getLocaleFromUrl(URL url, String basename) {
        String translatedBaseName = ObjectUtil.getClassName((String)basename);
        String fileName = UrlUtil.getUrlFileName((URL)url);
        String localeStr = (fileName = FileUtil.removeFileExtension((String)fileName)).substring(translatedBaseName.length());
        if (localeStr.length() == 0) {
            return new Locale("");
        }
        if (localeStr.charAt(0) != '_') {
            return null;
        }
        return JavaLocalizer.parse(localeStr);
    }

    public static final Locale parse(String localeString) {
        List localeParts;
        String parsableString = localeString;
        if (localeString.startsWith("_")) {
            parsableString = localeString.substring(1);
        }
        if ((localeParts = StringUtil.strToList((String)parsableString, (char)'_', (boolean)true)) == null || localeParts.isEmpty()) {
            return null;
        }
        String lang = (String)localeParts.get(0);
        String country = "";
        if (localeParts.size() > 1) {
            country = (String)localeParts.get(1);
        }
        String variant = "";
        if (localeParts.size() > 2) {
            variant = (String)localeParts.get(2);
        }
        return new Locale(lang, country, variant);
    }

    private String getJavaResourceNameFromUrl(URL url, String baseName) {
        String translatedBaseName = baseName.replace('.', '/');
        String urlStr = url.getFile();
        int index = urlStr.lastIndexOf(translatedBaseName);
        assert (index >= 0);
        return urlStr.substring(index);
    }

    @Override
    public Collection<URL> computeBundleUrls(String baseName, Collection<String> extensions) {
        this.assertNotDisposed();
        HashSet<URL> bundleUrls = new HashSet<URL>(3);
        IAppClassLoaderProvider clProvider = this.tryToGetIAppClassLoaderProvider();
        IAppClassLoaderProvider.IClassLoader loader = null;
        if (clProvider != null) {
            loader = clProvider.getAppClassLoader();
        }
        try {
            URL url;
            String packageName = ObjectUtil.getPackageName((String)baseName);
            String string = packageName = packageName != null ? packageName : "";
            if (loader != null && (url = loader.getResource(packageName.replace('.', '/'))) != null) {
                if (UrlUtil.isFileUrl((URL)url)) {
                    File rsrcDir = UrlUtil.getUrlFile((URL)url);
                    if (rsrcDir != null && rsrcDir.isDirectory()) {
                        bundleUrls.addAll(this.getBundleUrls(baseName, rsrcDir, extensions));
                    }
                } else if (UrlUtil.isJarUrl((URL)url)) {
                    bundleUrls.addAll(this.getBundleUrls(baseName, url, extensions));
                }
            }
        }
        finally {
            if (loader != null) {
                loader.close();
            }
        }
        return bundleUrls;
    }

    public final List<IFile> getAllResourceFiles(String baseName) {
        Collection<URL> urls = this.getBundleUrls(baseName);
        if (urls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IFile> resourceFiles = new ArrayList<IFile>();
        for (URL url : urls) {
            String fileName;
            Path rawCPAsPath;
            int numSegments;
            Path packageNamePath;
            String packageName;
            IFile findResource;
            String rawClasspathToFile = this.getJavaResourceNameFromUrl(url, baseName);
            if (rawClasspathToFile == null || (findResource = JDTUtil.findResource(this._project, packageName = (packageNamePath = (numSegments = (rawCPAsPath = new Path(rawClasspathToFile)).segmentCount()) > 1 ? rawCPAsPath.removeLastSegments(1) : new Path("")).toString().replace('/', '.'), fileName = rawCPAsPath.removeFirstSegments(numSegments - 1).toString())) == null) continue;
            resourceFiles.add(findResource);
        }
        return resourceFiles;
    }

    public final IFile getResourceFile(String baseName, Locale locale) {
        String fileName;
        URL bestUrl = this.getBestMatch(baseName, locale);
        if (bestUrl == null) {
            return null;
        }
        String rawClasspathToFile = this.getJavaResourceNameFromUrl(bestUrl, baseName);
        if (rawClasspathToFile == null) {
            return null;
        }
        Path rawCPAsPath = new Path(rawClasspathToFile);
        int numSegments = rawCPAsPath.segmentCount();
        Object packageNamePath = numSegments > 1 ? rawCPAsPath.removeLastSegments(1) : new Path("");
        String packageName = packageNamePath.toString().replace('/', '.');
        IFile findResource = JDTUtil.findResource(this._project, packageName, fileName = rawCPAsPath.removeFirstSegments(numSegments - 1).toString());
        if (findResource != null) {
            return findResource;
        }
        return null;
    }

    protected final URL getBestMatch(String baseName, Locale locale) {
        Collection<URL> urls = this.getBundleUrls(baseName);
        if (urls.isEmpty()) {
            return null;
        }
        return this.getBestMatch(urls, baseName, locale);
    }

    private URL getBestMatch(Collection<URL> urls, String baseName, Locale locale) {
        BestURL bestURL = this.getBestMatch2(urls, baseName, locale, 1.0);
        if (!this.isDefaultLocale(locale)) {
            BestURL defaultURL = this.getBestMatch2(urls, baseName, Locale.getDefault(), 0.5);
            if (bestURL.getScore() > defaultURL.getScore()) {
                return bestURL.getUrl();
            }
            return defaultURL.getUrl();
        }
        return bestURL.getUrl();
    }

    private BestURL getBestMatch2(Collection<URL> urls, String baseName, Locale locale, double multiplier) {
        URL currentBestMatch = null;
        int curBestScore = 0;
        for (URL url : urls) {
            Locale checkLocale = this.getLocaleFromUrl(url, baseName);
            int score = 0;
            score = checkLocale == null ? 100 : this.getScore(locale, checkLocale);
            if (score <= curBestScore) continue;
            currentBestMatch = url;
            curBestScore = score;
        }
        return new BestURL(currentBestMatch, (int)((double)curBestScore * multiplier));
    }

    protected final int getScore(Locale matchMe, Locale tryMatch) {
        int score = 0;
        if (this.isDefaultLocale(tryMatch)) {
            return 5;
        }
        if (matchMe.getVariant() == tryMatch.getVariant()) {
            score += 10;
        } else {
            return 0;
        }
        if (matchMe.getCountry() == tryMatch.getCountry()) {
            score += 100;
        } else {
            return 0;
        }
        if (matchMe.getLanguage() != tryMatch.getLanguage()) {
            return 0;
        }
        return score += 1000;
    }

    private boolean isDefaultLocale(Locale locale) {
        return "".equals(locale.getLanguage()) && "".equals(locale.getCountry()) && "".equals(locale.getVariant());
    }

    @Override
    public Collection<Locale> getAvailableLocales(String baseName) {
        HashSet<Locale> locales = new HashSet<Locale>();
        Collection<String> baseNames = this.getBaseNames();
        if (baseNames == null) {
            throw new IllegalStateException("getBaseNames may return empty collection but never null");
        }
        if (baseName != null && !baseNames.contains(baseName)) {
            baseNames = new ArrayList<String>(baseNames);
            baseNames.add(baseName);
        }
        for (String iterName : baseNames) {
            Collection<URL> bundleUrls = this.getBundleUrls(iterName);
            this.getBundleLocales(iterName, bundleUrls, locales);
        }
        return locales;
    }

    @Override
    protected IBundleResource createBundleResource(final String baseName, final Locale locale) {
        return new IBundleResource(){

            public ResourceBundle loadBundle() {
                return JavaLocalizer.this.createResourceBundle(baseName, locale);
            }

            public IFile getUnderlyingResource() {
                return JavaLocalizer.this.getResourceFile(baseName, locale);
            }

            public URL getBestMatchURL() {
                return JavaLocalizer.this.getBestMatch(baseName, locale);
            }

            public IStatus addKey(final String key, final String value, IProgressMonitor progressMonitor) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                final IFile file = this.getUnderlyingResource();
                if (file == null || !file.exists() || !file.isSynchronized(1)) {
                    return new Status(2, "oracle.eclipse.tools.webtier.common.services", "file either doesn't exist or is not synchronized: " + (file != null ? file.toString() : "<null>"));
                }
                final IStatus[] result = new IStatus[1];
                try {
                    workspace.run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            try {
                                InputStream contents = file.getContents();
                                Properties props = new Properties();
                                props.load(contents);
                                props.put(key, value);
                                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                                props.store(outStream, null);
                                file.setContents((InputStream)new ByteArrayInputStream(outStream.toByteArray()), 2, null);
                                result[0] = Status.OK_STATUS;
                            }
                            catch (IOException ioe) {
                                result[0] = new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.webtier.common.services", "During addKey", (Throwable)ioe)).getStatus();
                            }
                        }
                    }, workspace.getRuleFactory().deleteRule((IResource)file), 1, progressMonitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return result[0];
            }
        };
    }

    private ResourceBundle createResourceBundle(String baseName, Locale locale) {
        IAppClassLoaderProvider clProvider = this.tryToGetIAppClassLoaderProvider();
        IAppClassLoaderProvider.IClassLoader loader = null;
        if (clProvider != null) {
            loader = clProvider.getAppClassLoader();
        }
        try {
            if (loader != null) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(baseName, locale, loader.getClassLoader());
                return resourceBundle;
            }
            return null;
        }
        catch (MissingResourceException ex) {
            return null;
        }
        finally {
            if (loader != null) {
                loader.close();
            }
        }
    }

    private IAppClassLoaderProvider tryToGetIAppClassLoaderProvider() {
        Project project = (Project)this._project.getAdapter(Project.class);
        if (project == null) {
            return null;
        }
        IAppClassLoaderProvider ext = (IAppClassLoaderProvider)project.getAppService(IAppClassLoaderProvider.class);
        return ext;
    }

    @Override
    public Set<String> getAllBaseNames() {
        return this.getAllBaseNames(false);
    }

    @Override
    public final Set<String> getAllBaseNames(boolean includeJarFiles) {
        this.assertNotDisposed();
        HashSet<String> baseNames = new HashSet<String>();
        Set<IPath> resources = new JavaSrcUriResolver(this._project).getResources("properties");
        if (includeJarFiles) {
            resources.addAll(new JarUriResolver(this._project).getResources("properties"));
        }
        for (IPath resourcePath : resources) {
            IPath base = resourcePath.removeFileExtension();
            String fileName = base.lastSegment();
            String path = base.toString().replace('/', '.');
            int idxOfFirstUnderscore = fileName.indexOf(95);
            if (idxOfFirstUnderscore > -1) {
                IPath modified = base.removeLastSegments(1);
                fileName = fileName.substring(0, idxOfFirstUnderscore);
                modified = modified.append(fileName);
                path = modified.toString().replace('/', '.');
            }
            if (path == null || path.length() <= 0) continue;
            baseNames.add(path);
        }
        return baseNames;
    }

    @Override
    public final Set<ParentAndResource> getAllBaseNamesWithParents(boolean includeJarFiles) {
        this.assertNotDisposed();
        HashSet<ParentAndResource> baseNames = new HashSet<ParentAndResource>();
        Set<ParentAndResource> resources = new JavaSrcUriAndParentResolver(this._project).getResources("properties");
        if (includeJarFiles) {
            resources.addAll(new JarUriAndParentResolver(this._project).getResources("properties"));
        }
        for (ParentAndResource parentAndResource : resources) {
            IPath resourcePath = parentAndResource.getResource();
            IPath base = resourcePath.removeFileExtension();
            String fileName = base.lastSegment();
            String path = base.toString().replace('/', '.');
            int idxOfFirstUnderscore = fileName.indexOf(95);
            if (idxOfFirstUnderscore > -1) {
                IPath modified = base.removeLastSegments(1);
                fileName = fileName.substring(0, idxOfFirstUnderscore);
                modified = modified.append(fileName);
                path = modified.toString().replace('/', '.');
            }
            if (path == null || path.length() <= 0) continue;
            parentAndResource.setBaseName(path);
            baseNames.add(parentAndResource);
        }
        return baseNames;
    }

    @Override
    public IBundleResource resolveBundle(IDocument doc, int offset, String bundleName, List<Locale> preferredLocales) {
        this.assertNotDisposed();
        Locale locale = this.resolveLocale(preferredLocales);
        return this.getResourceBundle(bundleName, locale);
    }

    private static class BestURL {
        private final URL _url;
        private final int _score;

        public BestURL(URL url, int score) {
            this._url = url;
            this._score = score;
        }

        public URL getUrl() {
            return this._url;
        }

        public int getScore() {
            return this._score;
        }
    }
}

