/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.jsp.include.model;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.webtier.common.services.TraceOptions;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedTLDCMDocumentManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.parser.JSPSourceParser;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexDelta;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexListener;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;

public class MergedTaglibController {
    private static final MergedTaglibController _instance = new MergedTaglibController();
    private final Map<IStructuredDocument, DocumentInfo> _documentMap = new HashMap<IStructuredDocument, DocumentInfo>();
    private final Map<IStructuredDocument, Integer> _documentRefCountMap = new HashMap<IStructuredDocument, Integer>();

    public static MergedTaglibController getInstance() {
        return _instance;
    }

    private MergedTaglibController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStructuredDocument(IStructuredDocument document, IPath location) {
        DocumentInfo info = new DocumentInfo();
        info.document = document;
        info.tldDocumentManager = new MergedTLDCMDocumentManager(location);
        Map<IStructuredDocument, DocumentInfo> map = this._documentMap;
        synchronized (map) {
            Integer refCount = this._documentRefCountMap.get(document);
            if (refCount == null || refCount < 1) {
                if (TraceOptions.MERGED_MODEL_REF_COUNTS) {
                    TraceOptions.log("MergedTaglibController.addStructuredDocument(" + document + ", " + location.toString() + ")");
                }
            } else {
                this._documentRefCountMap.put(document, new Integer(refCount + 1));
                return;
            }
            this._documentMap.put(document, info);
            this._documentRefCountMap.put(document, new Integer(1));
        }
        info.tldDocumentManager.setSourceParser((JSPSourceParser)info.document.getParser());
        if (document instanceof BasicStructuredDocument && document.getLength() > 0) {
            ((BasicStructuredDocument)document).reparse((Object)this);
        }
        TaglibIndex.addTaglibIndexListener((ITaglibIndexListener)info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocumentInfo removeStructuredDocument(IStructuredDocument document) {
        DocumentInfo info = null;
        Map<IStructuredDocument, DocumentInfo> map = this._documentMap;
        synchronized (map) {
            Integer refCount = this._documentRefCountMap.get(document);
            if (refCount != null) {
                if (refCount <= 1) {
                    if (TraceOptions.MERGED_MODEL_REF_COUNTS) {
                        TraceOptions.log("MergedTaglibController.removeStructuredDocument(" + document + ")");
                    }
                    info = this._documentMap.remove(document);
                    this._documentRefCountMap.remove(document);
                } else {
                    this._documentRefCountMap.put(document, new Integer(refCount - 1));
                }
            }
        }
        if (info != null) {
            info.tldDocumentManager.clearCache();
            TaglibIndex.removeTaglibIndexListener(info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergedTLDCMDocumentManager getTldManager(IStructuredDocument document) {
        Map<IStructuredDocument, DocumentInfo> map = this._documentMap;
        synchronized (map) {
            DocumentInfo info = this._documentMap.get(document);
            if (info != null) {
                return info.tldDocumentManager;
            }
            return null;
        }
    }

    static class DocumentInfo
    implements ITaglibIndexListener {
        IStructuredDocument document;
        MergedTLDCMDocumentManager tldDocumentManager;

        DocumentInfo() {
        }

        public void indexChanged(ITaglibIndexDelta delta) {
            int type = delta.getKind();
            if (type == 4 || type == 2) {
                ITaglibIndexDelta[] deltas = delta.getAffectedChildren();
                boolean affected = false;
                int i = 0;
                while (i < deltas.length) {
                    Object key = TLDCMDocumentManager.getUniqueIdentifier((ITaglibRecord)deltas[i].getTaglibRecord());
                    if (this.tldDocumentManager.getDocuments().containsKey(key)) {
                        affected = true;
                    }
                    ++i;
                }
                if (affected) {
                    if (TraceOptions.MERGED_MODEL_TLDCMDOCUMENT_MANAGER) {
                        TraceOptions.log("MergedTLDCMDocumentManager cleared its private CMDocument cache");
                    }
                    this.tldDocumentManager.getDocuments().clear();
                    this.tldDocumentManager.getSourceParser().resetHandlers();
                    if (this.document instanceof BasicStructuredDocument) {
                        ((BasicStructuredDocument)this.document).reparse((Object)this);
                    }
                }
            }
            this.tldDocumentManager.indexChanged(delta);
        }
    }
}

