/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.jsp.include.model;

import oracle.eclipse.tools.webtier.common.services.jsp.include.model.IncludeContext;
import org.eclipse.jface.text.TypedRegion;

class MergedModelTypedRegion
extends TypedRegion {
    public static final String SOURCE = "__source";
    public static final String INCLUDE = "__include";
    private final IncludeContext _context;
    private final int _contentOffset;

    MergedModelTypedRegion(int offset, int length, String type, IncludeContext context, int contentOffset) {
        super(offset, length, MergedModelTypedRegion.normalizeTypeValue(type));
        if (context == null) {
            throw new IllegalArgumentException("Program Error: IncludeContext is null");
        }
        this._context = context;
        this._contentOffset = contentOffset;
    }

    public IncludeContext getIncludeContext() {
        return this._context;
    }

    public int getContentOffset() {
        return this._contentOffset;
    }

    private static String normalizeTypeValue(String type) {
        if (SOURCE.equals(type)) {
            return SOURCE;
        }
        if (INCLUDE.equals(type)) {
            return INCLUDE;
        }
        return null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this._contentOffset;
        result = 31 * result + (this._context == null ? 0 : this._context.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MergedModelTypedRegion)) {
            return false;
        }
        MergedModelTypedRegion other = (MergedModelTypedRegion)((Object)obj);
        if (this._contentOffset != other._contentOffset) {
            return false;
        }
        return !(this._context == null ? other._context != null : !this._context.equals(other._context));
    }
}

