/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.jsp.include.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.eclipse.tools.application.common.services.include.model.IMergedModelNode;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.TraceOptions;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.ContentMerger;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.IMergedModel;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.IncludeContext;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedModelDocumentPartitioner;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedModelException;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedModelManager;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedModelNodeFactory;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedModelTypedRegion;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedTaglibController;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.ResourceReferenceInfo;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jst.jsp.core.internal.contenttype.DeploymentDescriptorPropertyCache;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.FileBufferModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class MergedModel
implements IMergedModel {
    private final IFile _sourceFile;
    private IStructuredModel _sourceModel;
    private IStructuredModel _structuredModel;
    private List<ITypedRegion> _regions = null;
    private IDocumentListener _sourceDocListener;
    private final IFile _webXMLFile;
    private final ILock _modelLock = Job.getJobManager().newLock();
    private final AtomicBoolean _isDisposed = new AtomicBoolean(false);
    private final Job _updateModelJob = new UpdateModelJob();
    private final IJobChangeListener _updateModelJobListener = new JobChangeListener();
    private static final String UPDATE_JOB_NAME = "MergedModel update";
    private static final String MERGED_CONTENT_FILE_PREFIX = "TMP_OEPE_";

    MergedModel(IFile sourceFile) {
        if (sourceFile == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Program Error: Source file is null");
            LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)iae);
            throw iae;
        }
        this._sourceFile = sourceFile;
        this._webXMLFile = DeploymentDescriptorPropertyCache.getInstance().getWebXML(sourceFile.getFullPath());
        this._updateModelJob.setRule((ISchedulingRule)this._sourceFile.getProject());
        this._updateModelJob.setSystem(true);
        this._updateModelJob.setPriority(20);
        this._updateModelJob.addJobChangeListener(this._updateModelJobListener);
        if (TraceOptions.MERGED_MODEL_REF_COUNTS) {
            TraceOptions.log("Merged model (" + this._sourceFile.getFullPath().toString() + ") instance constructed");
        }
    }

    void dispose() {
        if (this._isDisposed.compareAndSet(false, true)) {
            Job disposeJob = new Job(""){

                protected IStatus run(IProgressMonitor monitor) {
                    MergedModel.this._modelLock.acquire();
                    try {
                        if (MergedModel.this._updateModelJob != null) {
                            MergedModel.this._updateModelJob.cancel();
                            MergedModel.this._updateModelJob.removeJobChangeListener(MergedModel.this._updateModelJobListener);
                        }
                        MergedModel.this.removeSourceDocListener(MergedModel.this._sourceModel);
                        if (MergedModel.this._structuredModel != null) {
                            if (MergedModel.this._structuredModel.getReferenceCount() == 1) {
                                MergedModel.this.removeDocumentPartitioner();
                            }
                            MergedTaglibController controller = MergedTaglibController.getInstance();
                            controller.removeStructuredDocument(MergedModel.this._structuredModel.getStructuredDocument());
                            MergedModel.this._structuredModel.releaseFromEdit();
                            MergedModel.this._structuredModel = null;
                        }
                        if (MergedModel.this._sourceModel != null) {
                            MergedModel.this._sourceModel.releaseFromRead();
                            MergedModel.this._sourceModel = null;
                        }
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    finally {
                        MergedModel.this._modelLock.release();
                    }
                }
            };
            disposeJob.setSystem(true);
            disposeJob.setPriority(20);
            disposeJob.schedule();
            if (TraceOptions.MERGED_MODEL_REF_COUNTS) {
                TraceOptions.log("Merged model (" + this._sourceFile.getFullPath().toString() + ") instance disposed");
            }
        }
    }

    boolean isDisposed() {
        return this._isDisposed.get();
    }

    private void assertNotDisposed() {
        if (this._isDisposed.get()) {
            throw new IllegalStateException("Program Error: Method called on disposed merged model.");
        }
    }

    @Override
    public IFile getSourceFile() {
        return this._sourceFile;
    }

    @Override
    public String getId() {
        if (!this._isDisposed.get() && this._structuredModel != null) {
            return this._structuredModel.getId();
        }
        return MergedModel.calculateId(this._sourceFile);
    }

    static String calculateId(IFile file) {
        String id = FileBufferModelManager.getInstance().calculateId(file);
        StringBuilder newId = new StringBuilder();
        if (id != null) {
            Path basePath = new Path(id);
            String lastSegment = basePath.lastSegment();
            if (basePath.segmentCount() > 0) {
                newId.append(id.substring(0, id.length() - lastSegment.length()));
            }
            newId.append(MERGED_CONTENT_FILE_PREFIX).append(lastSegment);
        }
        return newId.toString();
    }

    @Override
    public IStructuredModel getModelForRead() throws MergedModelException {
        IStructuredModel model = null;
        String modelID = null;
        this._modelLock.acquire();
        try {
            if (this._structuredModel != null) {
                modelID = this._structuredModel.getId();
            }
        }
        finally {
            this._modelLock.release();
        }
        if (modelID == null) {
            final String[] modelIDs = new String[1];
            final MergedModelException[] exceptions = new MergedModelException[1];
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor pm) throws CoreException {
                    MergedModel.this._modelLock.acquire();
                    try {
                        if (MergedModel.this._structuredModel == null) {
                            try {
                                MergedModel.this.createModel();
                            }
                            catch (MergedModelException e) {
                                exceptions[0] = e;
                            }
                        }
                        if (MergedModel.this._structuredModel != null) {
                            modelIDs[0] = MergedModel.this._structuredModel.getId();
                        }
                    }
                    finally {
                        MergedModel.this._modelLock.release();
                    }
                }
            };
            this.assertNotDisposed();
            try {
                IProject project = this._sourceFile.getProject();
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                ws.run(runnable, (ISchedulingRule)project, 1, null);
            }
            catch (CoreException ce) {
                LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (CoreException)ce);
                throw new MergedModelException(ce);
            }
            if (exceptions[0] != null) {
                throw exceptions[0];
            }
            modelID = modelIDs[0];
        }
        if (modelID != null) {
            IModelManager mgr = StructuredModelManager.getModelManager();
            if (mgr != null) {
                model = mgr.getExistingModelForRead((Object)modelID);
            }
            if (TraceOptions.MERGED_MODEL_REF_COUNTS) {
                if (model == null) {
                    TraceOptions.log("Merged model (" + this._sourceFile.getFullPath().toString() + ") structured model is NULL!");
                } else {
                    TraceOptions.log("Merged model (" + this._sourceFile.getFullPath().toString() + ") structured model ref count, " + model.getReferenceCount());
                }
            }
        }
        return model;
    }

    @Override
    public void release() {
        MergedModelManager.getInstance().release(this);
    }

    @Override
    public int translateSourceOffset(int srcOffset) {
        this.assertNotDisposed();
        if (srcOffset == 0 || this._structuredModel == null) {
            return 0;
        }
        int remainingOffset = srcOffset;
        int precedingRegionsLength = 0;
        this._modelLock.acquire();
        try {
            int mergedContentLength = 0;
            for (ITypedRegion typedRegion : this._regions) {
                mergedContentLength += typedRegion.getLength();
            }
            if (srcOffset > mergedContentLength) {
                int n = mergedContentLength;
                return n;
            }
            for (ITypedRegion typedRegion : this._regions) {
                MergedModelTypedRegion region = (MergedModelTypedRegion)typedRegion;
                if ("__include" == region.getType()) {
                    precedingRegionsLength += region.getLength();
                    IncludeContext ic = region.getIncludeContext();
                    if (ic.getNestedDepth() != 1 || ic.getIncludeElemRegion() == null) continue;
                    remainingOffset -= ic.getIncludeElemRegion().getLength();
                    continue;
                }
                if (remainingOffset <= region.getLength()) {
                    int n = precedingRegionsLength + remainingOffset;
                    return n;
                }
                precedingRegionsLength += region.getLength();
                remainingOffset -= region.getLength();
            }
        }
        finally {
            this._modelLock.release();
        }
        return precedingRegionsLength;
    }

    @Override
    public Collection<ResourceReferenceInfo> getIncludeResourceReferences() {
        this.assertNotDisposed();
        if (this._structuredModel == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ResourceReferenceInfo> includeResourceRefs = new ArrayList<ResourceReferenceInfo>();
        this._modelLock.acquire();
        try {
            for (ITypedRegion typedRegion : this._regions) {
                IncludeContext ic;
                IncludeContext parent;
                MergedModelTypedRegion region = (MergedModelTypedRegion)typedRegion;
                if ("__include" != region.getType() || (parent = (ic = region.getIncludeContext()).getParentContext()) == null || parent.getRuntimeIncludingContext() != null) continue;
                ResourceLocation refLoc = ic.getReferenceLocation();
                if (refLoc == null) {
                    refLoc = new ResourceLocation((IResource)this._sourceFile, new Range(0L, 1L));
                }
                ResourceReferenceInfo refInfo = new ResourceReferenceInfo(refLoc, (IResource)ic.getFile());
                includeResourceRefs.add(refInfo);
            }
        }
        finally {
            this._modelLock.release();
        }
        return includeResourceRefs;
    }

    private void createModel() throws MergedModelException {
        String id = MergedModel.calculateId(this._sourceFile);
        IStructuredModel sourceModel = null;
        try {
            long startTime;
            IModelManager mgr;
            block25: {
                mgr = StructuredModelManager.getModelManager();
                if (mgr == null || !this._sourceFile.isAccessible()) {
                    return;
                }
                startTime = 0L;
                if (TraceOptions.MERGED_MODEL_PERF) {
                    startTime = System.nanoTime();
                }
                try {
                    sourceModel = mgr.getModelForRead(this._sourceFile);
                }
                catch (ResourceException ce) {
                    IStatus status = ce.getStatus();
                    if (status == null || status.getCode() != 274) break block25;
                    this._sourceFile.refreshLocal(0, null);
                    sourceModel = mgr.getModelForRead(this._sourceFile);
                }
            }
            if (sourceModel == null) {
                return;
            }
            try {
                if (TraceOptions.MERGED_MODEL_PERF) {
                    TraceOptions.log("Merged model (" + this._sourceFile.getFullPath().toString() + ") get source page structured model time ns, " + (System.nanoTime() - startTime));
                }
                this._regions = new ArrayList<ITypedRegion>();
                String mergedText = this.computeText(sourceModel, this._sourceFile, this._regions);
                if (TraceOptions.MERGED_MODEL_PERF) {
                    startTime = System.nanoTime();
                }
                this._structuredModel = mgr.getExistingModelForEdit((Object)id);
                if (this._structuredModel == null) {
                    this._structuredModel = mgr.copyModelForEdit(sourceModel.getId(), id);
                } else if (TraceOptions.MERGED_MODEL_REF_COUNTS) {
                    TraceOptions.log("Merged model (" + this._sourceFile.getFullPath().toString() + ") use existing structured model, structured model ref count, " + this._structuredModel.getReferenceCount());
                }
                if (this._structuredModel == null) {
                    MergedModelException mme = new MergedModelException("Program Error: StructuredModel is null");
                    LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)mme);
                    throw mme;
                }
                this._structuredModel.getStructuredDocument().set(mergedText);
                this.configDocumentPartitioner(this._regions);
                this.addSourceDocListener(sourceModel, id);
                MergedModel.ensureNodeAdapterFactory((IDOMModel)this._structuredModel);
                MergedTaglibController controller = MergedTaglibController.getInstance();
                controller.addStructuredDocument(this._structuredModel.getStructuredDocument(), this._sourceFile.getFullPath());
                if (TraceOptions.MERGED_MODEL_PERF) {
                    TraceOptions.log("Merged model (" + this._sourceFile.getFullPath().toString() + ") create structured model time ns, " + (System.nanoTime() - startTime));
                }
            }
            catch (IOException ioe) {
                LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)ioe);
                throw new MergedModelException(ioe);
            }
            catch (CoreException ce) {
                LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (CoreException)ce);
                throw new MergedModelException(ce);
            }
            catch (ResourceInUse riu) {
                LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)riu);
                throw new MergedModelException(riu);
            }
        }
        finally {
            if (this._structuredModel != null) {
                this._sourceModel = sourceModel;
            } else if (sourceModel != null) {
                if (sourceModel.getReferenceCountForRead() > 0) {
                    sourceModel.releaseFromRead();
                }
                sourceModel = null;
            }
        }
    }

    boolean isDependentOn(Set<IFile> files) {
        if (files == null || files.size() == 0 || this._isDisposed.get()) {
            return false;
        }
        this._modelLock.acquire();
        try {
            if (this._structuredModel == null || this._regions == null) {
                return false;
            }
            if (files.contains(this._webXMLFile)) {
                return true;
            }
            for (ITypedRegion typedRegion : this._regions) {
                IncludeContext context;
                MergedModelTypedRegion region;
                if (!(typedRegion instanceof MergedModelTypedRegion) || "__include" != (region = (MergedModelTypedRegion)typedRegion).getType() || (context = region.getIncludeContext()) == null || !files.contains(context.getFile())) continue;
                return true;
            }
        }
        finally {
            this._modelLock.release();
        }
        return false;
    }

    IStatus doUpdate(IProgressMonitor monitor) {
        block13: {
            if (!this._isDisposed.get()) {
                IStructuredModel sourceModel = null;
                try {
                    try {
                        block14: {
                            IModelManager mgr = StructuredModelManager.getModelManager();
                            if (mgr == null || !this._sourceFile.isAccessible()) break block13;
                            try {
                                sourceModel = mgr.getModelForRead(this._sourceFile);
                            }
                            catch (ResourceException ce) {
                                IStatus status = ce.getStatus();
                                if (status == null || status.getCode() != 274) break block14;
                                this._sourceFile.refreshLocal(0, null);
                                sourceModel = mgr.getModelForRead(this._sourceFile);
                            }
                        }
                        if (sourceModel != null) {
                            ArrayList<ITypedRegion> regions = new ArrayList<ITypedRegion>();
                            String mergedText = this.computeText(sourceModel, this._sourceFile, regions);
                            this.doTextAndRegionsUpdate(mergedText, regions, monitor);
                        }
                    }
                    catch (IOException ioe) {
                        LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)ioe);
                        Status status = new Status(4, "oracle.eclipse.tools.webtier.common.services", 1, "Unnable to update merged model", (Throwable)ioe);
                        if (sourceModel != null) {
                            sourceModel.releaseFromRead();
                        }
                        return status;
                    }
                    catch (CoreException ce) {
                        Status status;
                        block15: {
                            LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (CoreException)ce);
                            status = new Status(4, "oracle.eclipse.tools.webtier.common.services", 1, "Unnable to update merged model", (Throwable)ce);
                            if (sourceModel == null) break block15;
                            sourceModel.releaseFromRead();
                        }
                        return status;
                    }
                }
                finally {
                    if (sourceModel != null) {
                        sourceModel.releaseFromRead();
                    }
                }
            }
        }
        return Status.OK_STATUS;
    }

    private String computeText(IStructuredModel model, IFile file, List<ITypedRegion> regions) {
        long startTime = 0L;
        if (TraceOptions.MERGED_MODEL_PERF) {
            startTime = System.nanoTime();
        }
        StringBuilder mergedText = new StringBuilder();
        IncludeContext context = new IncludeContext(file, null, null, null, false);
        ContentMerger cm = new ContentMerger(model, context);
        cm.processPreludes(mergedText, regions);
        cm.processModel(mergedText, regions);
        cm.processCodas(mergedText, regions);
        if (TraceOptions.MERGED_MODEL_PERF) {
            TraceOptions.log("Merged model (" + this._sourceFile.getFullPath().toString() + ") computeText() time ns, " + (System.nanoTime() - startTime));
        }
        return mergedText.toString();
    }

    private void doTextAndRegionsUpdate(final String mergedText, final List<ITypedRegion> regions, IProgressMonitor monitor) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                if (!MergedModel.this._isDisposed.get()) {
                    MergedModel.this._modelLock.acquire();
                    try {
                        if (MergedModel.this._structuredModel == null) {
                            return;
                        }
                        Difference diff = MergedModel.this.computeDifference(mergedText);
                        MergedModelDocumentPartitioner docPartitioner = MergedModel.this.getDocumentPartitioner();
                        if (docPartitioner != null) {
                            docPartitioner.updateRegions(regions);
                        }
                        MergedModel.this._regions = regions;
                        if (diff == null) {
                            return;
                        }
                        try {
                            MergedModel.this._structuredModel.aboutToChangeModel();
                            MergedModel.this._structuredModel.getStructuredDocument().replace(diff.offset, diff.length, diff.text);
                            MergedModel.this._structuredModel.changedModel();
                        }
                        catch (BadLocationException ble) {
                            LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)ble);
                        }
                    }
                    finally {
                        MergedModel.this._modelLock.release();
                    }
                }
            }
        };
        long startTime = 0L;
        if (TraceOptions.MERGED_MODEL_PERF) {
            startTime = System.nanoTime();
        }
        try {
            IProject project = this._sourceFile.getProject();
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            ws.run(runnable, (ISchedulingRule)project, 1, monitor);
        }
        catch (CoreException ce) {
            LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (CoreException)ce);
        }
        if (TraceOptions.MERGED_MODEL_PERF) {
            TraceOptions.log("Merged model (" + this._sourceFile.getFullPath().toString() + ") update text and regions time ns, " + (System.nanoTime() - startTime));
        }
    }

    private Difference computeDifference(String newText) {
        String currentText = this._structuredModel.getStructuredDocument().get();
        int currTextLength = currentText.length();
        if (newText == null || newText.length() == 0) {
            return new Difference(0, currentText.length(), "");
        }
        if (currTextLength == 0) {
            return new Difference(0, 0, newText);
        }
        int begin = MergedModel.beginIndexOfDifference(currentText, newText);
        if (begin < 0) {
            return null;
        }
        int endLength = MergedModel.lengthOfCommonEnding(currentText, newText);
        int diffEnd = currTextLength - endLength;
        int endIndex = newText.length() - endLength;
        if (diffEnd < begin || endIndex < begin) {
            return new Difference(0, currentText.length(), newText);
        }
        int length = diffEnd - begin;
        String text = newText.substring(begin, endIndex);
        return new Difference(begin, length, text);
    }

    private static int beginIndexOfDifference(String str1, String str2) {
        int i = 0;
        while (i < str1.length() && i < str2.length()) {
            if (str1.charAt(i) != str2.charAt(i)) break;
            ++i;
        }
        if (i < str2.length() || i < str1.length()) {
            return i;
        }
        return -1;
    }

    private static int lengthOfCommonEnding(String str1, String str2) {
        int count = 0;
        int i = str1.length() - 1;
        int j = str2.length() - 1;
        while (i >= 0 && j >= 0) {
            if (str1.charAt(i) != str2.charAt(j)) break;
            ++count;
            --i;
            --j;
        }
        return count;
    }

    private void configDocumentPartitioner(List<ITypedRegion> regions) {
        if (this._structuredModel == null) {
            IllegalStateException ise = new IllegalStateException("Program Error: StructuredModel is null");
            LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)ise);
            throw ise;
        }
        if (this._structuredModel.getStructuredDocument() instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)this._structuredModel.getStructuredDocument();
            IDocumentPartitioner docPartitioner = extension3.getDocumentPartitioner("oracle.eclipse.tools.webtier.common.services.jsp.include.model.MERGED_PARTITIONING");
            if (docPartitioner != null) {
                docPartitioner.disconnect();
            }
            docPartitioner = new MergedModelDocumentPartitioner(regions);
            extension3.setDocumentPartitioner("oracle.eclipse.tools.webtier.common.services.jsp.include.model.MERGED_PARTITIONING", docPartitioner);
            docPartitioner.connect((IDocument)this._structuredModel.getStructuredDocument());
        }
    }

    private MergedModelDocumentPartitioner getDocumentPartitioner() {
        IDocumentExtension3 extension3;
        IDocumentPartitioner docPartitioner;
        if (this._structuredModel == null) {
            IllegalStateException ise = new IllegalStateException("Program Error: StructuredModel is null");
            LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)ise);
            return null;
        }
        if (this._structuredModel.getStructuredDocument() instanceof IDocumentExtension3 && (docPartitioner = (extension3 = (IDocumentExtension3)this._structuredModel.getStructuredDocument()).getDocumentPartitioner("oracle.eclipse.tools.webtier.common.services.jsp.include.model.MERGED_PARTITIONING")) instanceof MergedModelDocumentPartitioner) {
            return (MergedModelDocumentPartitioner)docPartitioner;
        }
        return null;
    }

    private void removeDocumentPartitioner() {
        if (this._structuredModel == null) {
            return;
        }
        if (this._structuredModel.getStructuredDocument() instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)this._structuredModel.getStructuredDocument();
            IDocumentPartitioner docPartitioner = extension3.getDocumentPartitioner("oracle.eclipse.tools.webtier.common.services.jsp.include.model.MERGED_PARTITIONING");
            if (docPartitioner != null) {
                docPartitioner.disconnect();
            }
            extension3.setDocumentPartitioner("oracle.eclipse.tools.webtier.common.services.jsp.include.model.MERGED_PARTITIONING", null);
        }
    }

    private void addSourceDocListener(IStructuredModel model, String id) {
        if (model == null) {
            IllegalStateException ise = new IllegalStateException("Program Error: StructuredModel is null");
            LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)ise);
            return;
        }
        this._sourceDocListener = new DocumentListener(id);
        IStructuredDocument document = model.getStructuredDocument();
        document.addDocumentListener(this._sourceDocListener);
    }

    private void removeSourceDocListener(IStructuredModel model) {
        if (model != null && this._sourceDocListener != null) {
            IStructuredDocument document = model.getStructuredDocument();
            if (document != null) {
                document.removeDocumentListener(this._sourceDocListener);
            }
            this._sourceDocListener = null;
        }
    }

    private static INodeAdapterFactory ensureNodeAdapterFactory(IDOMModel dom) {
        Object factory = dom.getFactoryRegistry().getFactoryFor(IMergedModelNode.class);
        if (factory == null) {
            factory = new MergedModelNodeFactory();
            dom.getFactoryRegistry().addFactory(factory);
        }
        return factory;
    }

    private static class Difference {
        int offset;
        int length;
        String text;

        Difference(int o, int l, String s) {
            this.offset = o;
            this.length = l;
            this.text = s;
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        private final String id;

        private DocumentListener(String docId) {
            this.id = String.valueOf(docId) + System.currentTimeMillis();
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (!MergedModel.this._isDisposed.get() && MergedModel.this._updateModelJob != null) {
                if (MergedModel.this._updateModelJob.getState() == 2 || MergedModel.this._updateModelJob.getState() == 1) {
                    return;
                }
                MergedModelManager.getInstance().modelChanging(MergedModel.this);
                MergedModel.this._updateModelJob.schedule(500L);
            }
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DocumentListener)) {
                return false;
            }
            DocumentListener other = (DocumentListener)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }

    private class JobChangeListener
    implements IJobChangeListener {
        private JobChangeListener() {
        }

        public void aboutToRun(IJobChangeEvent event) {
            this.checkModelIsDisposed(event);
        }

        public void awake(IJobChangeEvent event) {
            this.checkModelIsDisposed(event);
        }

        public void done(IJobChangeEvent event) {
            MergedModelManager.getInstance().modelChangeComplete(MergedModel.this);
        }

        public void running(IJobChangeEvent event) {
        }

        public void scheduled(IJobChangeEvent event) {
            this.checkModelIsDisposed(event);
        }

        public void sleeping(IJobChangeEvent event) {
            this.checkModelIsDisposed(event);
        }

        private void checkModelIsDisposed(IJobChangeEvent event) {
            if (MergedModel.this._isDisposed.get()) {
                event.getJob().cancel();
            }
        }
    }

    private class UpdateModelJob
    extends Job {
        public UpdateModelJob() {
            super(MergedModel.UPDATE_JOB_NAME);
        }

        protected IStatus run(IProgressMonitor monitor) {
            return MergedModel.this.doUpdate(monitor);
        }

        public boolean belongsTo(Object family) {
            return family == MergedModelManager.UPDATE_JOB_FAMILY;
        }
    }
}

