/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.jsp.include.model;

import java.util.List;
import oracle.eclipse.tools.application.common.services.include.model.IMergedModelNode;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedTLDCMDocumentManager;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedTaglibController;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.jsp.core.internal.contentmodel.JSPCMDocumentFactory;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.internal.contenttype.DeploymentDescriptorPropertyCache;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.contentmodel.CMNodeWrapper;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MergedContentModelUtil {
    public static String getElementNamespaceURI(IDOMElement element) {
        TaglibTracker tracker;
        if (element == null) {
            return null;
        }
        String elementNamespaceURI = CMUtil.getElementNamespaceURI((Element)element);
        if (elementNamespaceURI == null && (tracker = MergedContentModelUtil.getTaglibTracker((IDOMNode)element)) != null) {
            elementNamespaceURI = tracker.getURI();
        }
        return elementNamespaceURI;
    }

    public static CMElementDeclaration getElementDeclaration(Element element) {
        if (element == null) {
            return null;
        }
        String elementNamespaceURI = CMUtil.getElementNamespaceURI((Element)element);
        if (elementNamespaceURI == null) {
            return MergedContentModelUtil.getCMElementDeclaration(element);
        }
        return null;
    }

    public static TLDElementDeclaration getTLDElementDeclaration(Element element) {
        CMElementDeclaration decl = MergedContentModelUtil.getElementDeclaration(element);
        if (decl instanceof CMNodeWrapper) {
            decl = ((CMNodeWrapper)decl).getOriginNode();
        }
        if (decl instanceof TLDElementDeclaration) {
            return (TLDElementDeclaration)decl;
        }
        return null;
    }

    private static CMElementDeclaration getCMElementDeclaration(Element element) {
        CMElementDeclaration result = null;
        CMDocument cmDocument = MergedContentModelUtil.getCorrespondingCMDocument(element);
        if (cmDocument != null) {
            result = (CMElementDeclaration)cmDocument.getElements().getNamedItem(element.getNodeName());
        }
        return result;
    }

    private static CMDocument getCorrespondingCMDocument(Node node) {
        IDOMModel model;
        String modelPath;
        CMDocument jcmdoc = null;
        if (node instanceof IDOMNode && (modelPath = (model = ((IDOMNode)node).getModel()).getBaseLocation()) != null && !"org.eclipse.wst.sse.core.IModelManager.UNMANAGED_MODEL".equals(modelPath)) {
            float version = DeploymentDescriptorPropertyCache.getInstance().getJSPVersion((IPath)new Path(modelPath));
            jcmdoc = JSPCMDocumentFactory.getCMDocument((float)version);
        }
        if (jcmdoc == null) {
            jcmdoc = JSPCMDocumentFactory.getCMDocument();
        }
        CMDocument result = null;
        try {
            if (node.getNodeType() == 1) {
                String elementName = node.getNodeName();
                CMElementDeclaration dec = (CMElementDeclaration)jcmdoc.getElements().getNamedItem(elementName);
                if (dec != null) {
                    result = jcmdoc;
                }
            }
            String prefix = node.getPrefix();
            if (result == null && prefix != null && prefix.length() > 0 && node instanceof IDOMNode) {
                List documents;
                IDOMNode xmlNode = (IDOMNode)node;
                MergedTaglibController controller = MergedTaglibController.getInstance();
                MergedTLDCMDocumentManager tldMgr = controller.getTldManager(xmlNode.getStructuredDocument());
                if (tldMgr != null && (documents = tldMgr.getCMDocumentTrackers(node.getPrefix(), xmlNode.getStartOffset())) != null && documents.size() > 0) {
                    result = (CMDocument)documents.get(0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean isMergedModel(IDOMModel model) {
        if (model != null) {
            IDOMDocument domDoc = model.getDocument();
            return MergedContentModelUtil.isMergedModel(domDoc);
        }
        return false;
    }

    public static boolean isMergedModel(IDOMDocument domDoc) {
        IMergedModelNode mmNode;
        return domDoc != null && (mmNode = (IMergedModelNode)domDoc.getAdapterFor(IMergedModelNode.class)) != null;
    }

    public static boolean isMergedModelNode(IDOMNode node) {
        IMergedModelNode mmNode;
        return node != null && (mmNode = (IMergedModelNode)node.getAdapterFor(IMergedModelNode.class)) != null;
    }

    public static TaglibTracker getTaglibTracker(IDOMNode node) {
        String prefix = node.getPrefix();
        if (prefix != null && prefix.length() > 0 && MergedContentModelUtil.isMergedModelNode(node)) {
            return MergedContentModelUtil.getTaglibTracker(node.getStructuredDocument(), prefix);
        }
        return null;
    }

    public static TaglibTracker getTaglibTracker(IDOMModel model, String prefix) {
        if (prefix != null && prefix.length() > 0 && MergedContentModelUtil.isMergedModel(model)) {
            return MergedContentModelUtil.getTaglibTracker(model.getStructuredDocument(), prefix);
        }
        return null;
    }

    private static TaglibTracker getTaglibTracker(IStructuredDocument doc, String prefix) {
        List trackers = null;
        MergedTaglibController controller = MergedTaglibController.getInstance();
        MergedTLDCMDocumentManager tldMgr = controller.getTldManager(doc);
        if (tldMgr != null) {
            trackers = tldMgr.getTaglibTrackers();
        }
        if (trackers != null) {
            for (TaglibTracker tracker : trackers) {
                if (!prefix.equals(tracker.getPrefix())) continue;
                return tracker;
            }
        }
        return null;
    }

    public static CMElementDeclaration getTLDElementDeclaration(String uri, String elementName, IStructuredDocument document) {
        MergedTaglibController controller = MergedTaglibController.getInstance();
        MergedTLDCMDocumentManager tldmgr = controller.getTldManager(document);
        if (tldmgr != null) {
            for (TaglibTracker tracker : tldmgr.getTaglibTrackers()) {
                if (!tracker.getURI().equals(uri)) continue;
                return (CMElementDeclaration)tracker.getElements().getNamedItem(String.valueOf(tracker.getPrefix()) + ":" + elementName);
            }
        }
        return null;
    }
}

