/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.jsp.include.model;

import java.util.List;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentResourceLocationFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.common.services.jsp.include.IncludeElement;
import oracle.eclipse.tools.webtier.common.services.jsp.include.JSPIncludeLoader;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.ContentMerger;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.IncludeContext;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedModelTypedRegion;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContextFactory;
import oracle.eclipse.tools.xml.model.metadata.TagMetadata;
import oracle.eclipse.tools.xml.model.service.IXMLMetadataContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class IncludedContentRegionCollector
implements IStructuredXMLModelVisitor {
    private final ContentMerger _cm;
    private final StringBuilder _mergedText;
    private final List<ITypedRegion> _regions;
    private TagMetadata _tagMetadata;
    private StructuredDocumentResourceLocationFactory _locationFactory;

    public IncludedContentRegionCollector(ContentMerger contentMerger, StringBuilder mergedText, List<ITypedRegion> regions) {
        this._cm = contentMerger;
        this._mergedText = mergedText;
        this._regions = regions;
    }

    public boolean visit(IDOMNode node) {
        return true;
    }

    public boolean visit(IDOMAttr attribute) {
        return false;
    }

    public boolean visit(IDOMElement element) {
        IPath modelPath;
        IPath basePath;
        String localName;
        IncludeElement includeElement = IncludeElement.checkForJSPIncludeElement(element);
        if (includeElement == null && "import".equals(localName = element.getLocalName())) {
            includeElement = IncludeElement.checkForIncludeElement(this.getTagMetadata(), (Element)element);
        }
        if (includeElement != null && (basePath = (modelPath = this._cm.getSourceModelPath())) != null) {
            String regionType = "__source";
            IncludeContext currentContext = this._cm.getIncludeContext();
            if (!currentContext.isRoot()) {
                IncludeContext includingCtxt;
                regionType = "__include";
                basePath = includeElement.isRuntimeInclude() ? ((includingCtxt = currentContext.getRuntimeIncludingContext()) != null ? includingCtxt.getPath() : currentContext.getBaseSourceFile().getFullPath()) : currentContext.getPath();
            }
            JSPIncludeLoader loader = null;
            try {
                loader = new JSPIncludeLoader(basePath, includeElement.getIncludeURI());
                IFile includeFile = loader.getFile();
                if (includeFile == null) {
                    return true;
                }
                IPath includePath = includeFile.getFullPath();
                if (currentContext.isCyclicInclude(includePath) || includePath.equals((Object)modelPath)) {
                    return true;
                }
                IDOMModel model = loader.getModel();
                if (model != null) {
                    int start = element.getStartOffset();
                    int end = element.getEndOffset();
                    int length = start - this._cm.getOffset();
                    if (length > 0) {
                        this._regions.add((ITypedRegion)new MergedModelTypedRegion(this._mergedText.length(), length, regionType, currentContext, this._cm.getOffset()));
                        this._mergedText.append(this._cm.getBaseText().substring(this._cm.getOffset(), start));
                    }
                    Region includeElemLoc = IncludedContentRegionCollector.regionFromIncludeElement(element);
                    ResourceLocation refLocation = this.referenceLocationFromIncludeElement(currentContext, includeElement);
                    IncludeContext newIncludeContext = new IncludeContext(includeFile, currentContext, includeElemLoc, refLocation, includeElement.isRuntimeInclude());
                    ContentMerger inclusionCM = new ContentMerger((IStructuredModel)model, newIncludeContext);
                    inclusionCM.processModel(this._mergedText, this._regions);
                    this._cm.setOffset(end);
                }
            }
            finally {
                if (loader != null) {
                    loader.dispose();
                }
            }
        }
        return true;
    }

    public boolean visit(IDOMDocument document) {
        return true;
    }

    private TagMetadata getTagMetadata() {
        if (this._tagMetadata != null) {
            return this._tagMetadata;
        }
        IFile file = this._cm.getIncludeContext().getBaseSourceFile();
        if (file != null && file.isAccessible()) {
            IDocument document = (IDocument)file.getAdapter(IDocument.class);
            if (document == null) {
                return null;
            }
            INamespaceContextFactory nsContextFactory = (INamespaceContextFactory)document.getAdapter(INamespaceContextFactory.class);
            if (nsContextFactory == null) {
                return null;
            }
            INamespaceContext nsContext = nsContextFactory.getNamespaceContext(file);
            IXMLMetadataContext mdContext = (IXMLMetadataContext)document.getAdapter(IXMLMetadataContext.class);
            this._tagMetadata = new TagMetadata(nsContext, mdContext, file);
            return this._tagMetadata;
        }
        return null;
    }

    private ResourceLocation referenceLocationFromIncludeElement(IncludeContext currentContext, IncludeElement includeElem) {
        Attr referringAttr;
        ResourceLocation refLoc = null;
        if (this._locationFactory == null) {
            this._locationFactory = new StructuredDocumentResourceLocationFactory(currentContext.getFile());
        }
        if ((referringAttr = includeElem.getURIAttribute()) instanceof IDOMAttr) {
            refLoc = this._locationFactory.createForAttributeValue((IDOMAttr)referringAttr);
        }
        return refLoc;
    }

    private static Region regionFromIncludeElement(IDOMElement owningElem) {
        Region region = null;
        IStructuredDocumentRegion startRegion = owningElem.getStartStructuredDocumentRegion();
        if (startRegion != null) {
            int start = startRegion.getStartOffset();
            IStructuredDocumentRegion endRegion = owningElem.getEndStructuredDocumentRegion();
            region = endRegion != null ? new Region(start, endRegion.getEndOffset() - start) : new Region(start, startRegion.getEndOffset() - start);
        }
        return region;
    }
}

