/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.jsp.include.model;

import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.Region;

public class IncludeContext {
    private final IFile _contentFile;
    private final IncludeContext _parentContext;
    private final Region _includeElemRegion;
    private final ResourceLocation _referenceLocation;
    private final boolean _isRuntimeInclude;

    public IncludeContext(IFile contentFile, IncludeContext parentContext, Region includeElemRegion, ResourceLocation referenceLocation, boolean isRuntimeInclude) {
        if (contentFile == null) {
            throw new IllegalArgumentException("Program Error: Inclusion file is null");
        }
        this._contentFile = contentFile;
        this._parentContext = parentContext;
        this._includeElemRegion = includeElemRegion;
        this._isRuntimeInclude = isRuntimeInclude;
        this._referenceLocation = referenceLocation;
    }

    public IFile getFile() {
        return this._contentFile;
    }

    public IPath getPath() {
        return this._contentFile.getFullPath();
    }

    IncludeContext getParentContext() {
        return this._parentContext;
    }

    public IPath getParentFilePath() {
        if (this._parentContext == null) {
            return null;
        }
        return this._parentContext.getPath();
    }

    public Region getIncludeElemRegion() {
        return this._includeElemRegion;
    }

    public ResourceLocation getReferenceLocation() {
        return this._referenceLocation;
    }

    public boolean isRuntimeInclude() {
        return this._isRuntimeInclude;
    }

    public boolean isRuntimeIncluded() {
        if (this._isRuntimeInclude) {
            return true;
        }
        IncludeContext ancestor = this._parentContext;
        while (ancestor != null) {
            if (ancestor.isRuntimeInclude()) {
                return true;
            }
            ancestor = ancestor._parentContext;
        }
        return false;
    }

    public IncludeContext getRuntimeIncludingContext() {
        IncludeContext current = this;
        while (current != null) {
            if (current.isRuntimeInclude()) {
                return current;
            }
            current = current.getParentContext();
        }
        return null;
    }

    public boolean isCyclicInclude(IPath includePath) {
        if (includePath == null) {
            return false;
        }
        IncludeContext current = this;
        while (current != null) {
            if (includePath.equals((Object)current.getPath())) {
                return true;
            }
            current = current.getParentContext();
        }
        return false;
    }

    public int getNestedDepth() {
        int nestedDepth = 0;
        IncludeContext ancestor = this._parentContext;
        while (ancestor != null) {
            ++nestedDepth;
            ancestor = ancestor._parentContext;
        }
        return nestedDepth;
    }

    public boolean isRoot() {
        return this.getNestedDepth() == 0;
    }

    public IFile getBaseSourceFile() {
        IncludeContext ancestor = this._parentContext;
        while (ancestor != null) {
            if (ancestor.getParentContext() == null) {
                return ancestor.getFile();
            }
            ancestor = ancestor.getParentContext();
        }
        return this.getFile();
    }

    public Region getBaseSourceFileIncludeElemRegion() {
        IncludeContext child = this;
        IncludeContext parent = this._parentContext;
        while (parent != null) {
            if (parent.getParentContext() == null) {
                return child.getIncludeElemRegion();
            }
            child = parent;
            parent = parent.getParentContext();
        }
        return this._includeElemRegion;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this._contentFile == null ? 0 : this._contentFile.hashCode());
        result = 31 * result + (this._includeElemRegion == null ? 0 : this._includeElemRegion.hashCode());
        result = 31 * result + (this._isRuntimeInclude ? 1231 : 1237);
        result = 31 * result + (this._parentContext == null ? 0 : this._parentContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncludeContext)) {
            return false;
        }
        IncludeContext other = (IncludeContext)obj;
        if (!this._contentFile.getFullPath().equals((Object)other._contentFile.getFullPath())) {
            return false;
        }
        if (this._includeElemRegion == null ? other._includeElemRegion != null : !this._includeElemRegion.equals((Object)other._includeElemRegion)) {
            return false;
        }
        if (this._isRuntimeInclude != other._isRuntimeInclude) {
            return false;
        }
        return !(this._parentContext == null ? other._parentContext != null : !this._parentContext.equals(other._parentContext));
    }
}

