/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.jsp.include.model;

import java.io.IOException;
import java.util.List;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.StructuredModelFactory;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.Activator;
import oracle.eclipse.tools.webtier.common.services.jsp.include.JSPIncludeLoader;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.IncludeContext;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.IncludedContentRegionCollector;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedModelTypedRegion;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jst.jsp.core.internal.contenttype.DeploymentDescriptorPropertyCache;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class ContentMerger {
    private static final String KEY_MERGED_MODEL_INCLUSION_DISABLED = "oracle.eclipse.tools.webtier.common.services.jsp.include.model.inclusion.disable";
    private static final boolean _disableInclusion = Boolean.getBoolean("oracle.eclipse.tools.webtier.common.services.jsp.include.model.inclusion.disable");
    private static final String WTP_MODEL_PROVIDER = "org.eclipse.wst.sse.core.StructuredModelManager";
    private final IStructuredModel _sourceModel;
    private final String _baseText;
    private int _offset = 0;
    private final IncludeContext _includeContext;

    public ContentMerger(IStructuredModel sourceModel, IncludeContext includeContext) {
        if (sourceModel == null) {
            throw new IllegalArgumentException("Program Error: Source model is null");
        }
        if (includeContext == null) {
            throw new IllegalArgumentException("Program Error: Include context is null");
        }
        this._sourceModel = sourceModel;
        IStructuredDocument doc = this._sourceModel.getStructuredDocument();
        if (doc == null) {
            this._baseText = "";
            IllegalStateException ise = new IllegalStateException("Program Error: null structured document for the source model, " + sourceModel.getId());
            LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)ise);
        } else {
            this._baseText = doc.get();
        }
        this._includeContext = includeContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processModel(StringBuilder mergedText, List<ITypedRegion> regions) {
        IVisitableDOMModel visitableModel = null;
        try {
            try {
                int length;
                if (!_disableInclusion) {
                    visitableModel = StructuredModelFactory.getVisitableModelForRead((IFile)ContentMerger.getFileFor(this._sourceModel), (String)WTP_MODEL_PROVIDER);
                    if (visitableModel != null) {
                        visitableModel.accept((IStructuredXMLModelVisitor)new IncludedContentRegionCollector(this, mergedText, regions));
                    } else {
                        Activator.log("Visitable model was null", new Exception(""));
                    }
                }
                String regionType = "__source";
                if (!this._includeContext.isRoot()) {
                    regionType = "__include";
                }
                if ((length = this._baseText.length() - this._offset) <= 0) return;
                regions.add((ITypedRegion)new MergedModelTypedRegion(mergedText.length(), length, regionType, this._includeContext, this._offset));
                mergedText.append(this._baseText.substring(this._offset));
                return;
            }
            catch (IOException ioe) {
                LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)ioe);
                if (visitableModel == null) return;
                visitableModel.dispose();
                return;
            }
            catch (CoreException ce) {
                LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (CoreException)ce);
                if (visitableModel == null) return;
                visitableModel.dispose();
                return;
            }
        }
        finally {
            if (visitableModel != null) {
                visitableModel.dispose();
            }
        }
    }

    public void processPreludes(StringBuilder mergedText, List<ITypedRegion> regions) {
        if (_disableInclusion) {
            return;
        }
        IPath basePath = this.getSourceModelPath();
        if (basePath != null) {
            DeploymentDescriptorPropertyCache.PropertyGroup[] propertyGroups = DeploymentDescriptorPropertyCache.getInstance().getPropertyGroups(basePath);
            int j = 0;
            while (j < propertyGroups.length) {
                IPath[] preludes = propertyGroups[j].getIncludePrelude();
                int i = 0;
                while (i < preludes.length) {
                    IPath includePath = preludes[i];
                    JSPIncludeLoader loader = null;
                    try {
                        IDOMModel model;
                        loader = new JSPIncludeLoader(includePath);
                        if (!this._includeContext.isCyclicInclude(includePath) && !preludes[i].equals((Object)basePath) && (model = loader.getModel()) != null) {
                            Region region = new Region(0, 0);
                            IncludeContext newIncludeContext = new IncludeContext(loader.getFile(), this._includeContext, region, null, false);
                            ContentMerger inclusionCM = new ContentMerger((IStructuredModel)model, newIncludeContext);
                            inclusionCM.processModel(mergedText, regions);
                        }
                    }
                    finally {
                        if (loader != null) {
                            loader.dispose();
                        }
                    }
                    ++i;
                }
                ++j;
            }
        }
    }

    public void processCodas(StringBuilder mergedText, List<ITypedRegion> regions) {
        if (_disableInclusion) {
            return;
        }
        int length = this._baseText.length();
        IPath basePath = this.getSourceModelPath();
        if (basePath != null) {
            DeploymentDescriptorPropertyCache.PropertyGroup[] propertyGroups = DeploymentDescriptorPropertyCache.getInstance().getPropertyGroups(basePath);
            int j = 0;
            while (j < propertyGroups.length) {
                IPath[] codas = propertyGroups[j].getIncludeCoda();
                int i = 0;
                while (i < codas.length) {
                    IPath includePath = codas[i];
                    JSPIncludeLoader loader = null;
                    try {
                        IDOMModel model;
                        loader = new JSPIncludeLoader(includePath);
                        if (!this._includeContext.isCyclicInclude(includePath) && !codas[i].equals((Object)basePath) && (model = loader.getModel()) != null) {
                            Region region = new Region(length, 0);
                            IncludeContext newIncludeContext = new IncludeContext(loader.getFile(), this._includeContext, region, null, false);
                            ContentMerger inclusionCM = new ContentMerger((IStructuredModel)model, newIncludeContext);
                            inclusionCM.processModel(mergedText, regions);
                        }
                    }
                    finally {
                        if (loader != null) {
                            loader.dispose();
                        }
                    }
                    ++i;
                }
                ++j;
            }
        }
    }

    IPath getSourceModelPath() {
        return new Path(this._sourceModel.getBaseLocation());
    }

    String getBaseText() {
        return this._baseText;
    }

    int getOffset() {
        return this._offset;
    }

    void setOffset(int offset) {
        this._offset = offset;
    }

    IncludeContext getIncludeContext() {
        return this._includeContext;
    }

    IProject getProject() {
        return ContentMerger.getProjectFor(this._sourceModel);
    }

    private static IPath getPathFor(IStructuredModel model) {
        if (model == null) {
            return null;
        }
        String path = model.getBaseLocation();
        if (path == null || path.length() == 0) {
            String id = model.getId();
            if (id == null) {
                return null;
            }
            path = id.toString();
        }
        return new Path(path);
    }

    private static IFile getFileFor(IPath path) {
        if (path == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IFile file = root.getFile(path);
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static IFile getFileFor(IStructuredModel model) {
        IPath path = ContentMerger.getPathFor(model);
        return ContentMerger.getFileFor(path);
    }

    private static IProject getProjectFor(IStructuredModel model) {
        IProject project = null;
        IFile file = ContentMerger.getFileFor(model);
        if (file != null) {
            project = file.getProject();
        }
        return project;
    }
}

