/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.jsp.include;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.jsp.include.InclusionCacheManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsp.core.internal.util.FacetModuleCoreSupport;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JSPIncludeLoader {
    private final IFile _pageFile;
    private IDOMModel _model;
    private final AtomicBoolean _isDisposed = new AtomicBoolean(false);

    public JSPIncludeLoader(IPath basePath, String pageURI) {
        if (basePath == null) {
            throw new IllegalArgumentException("Program Error: Base path is null");
        }
        if (pageURI == null) {
            throw new IllegalArgumentException("Program Error: Page URI is null");
        }
        IPath pageLocation = JSPIncludeLoader.resolvePageURIToLocation(basePath, pageURI);
        this._pageFile = JSPIncludeLoader.resolvePageToFile(pageLocation);
    }

    public JSPIncludeLoader(IPath pageLocation) {
        if (pageLocation == null) {
            throw new IllegalArgumentException("Program Error: Page location is null");
        }
        this._pageFile = JSPIncludeLoader.resolvePageToFile(pageLocation);
    }

    public void dispose() {
        if (this._isDisposed.compareAndSet(false, true) && this._model != null) {
            this._model.releaseFromRead();
        }
    }

    public IFile getFile() {
        return this._pageFile;
    }

    public IDOMModel getModel() {
        assert (!this._isDisposed.get());
        this.loadIfNecessary();
        return this._model;
    }

    private void loadIfNecessary() {
        if (this._model != null) {
            return;
        }
        try {
            this._model = InclusionCacheManager.getInstance().getModel(this._pageFile);
        }
        catch (IOException ioe) {
            LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)ioe);
        }
        catch (CoreException ce) {
            LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (CoreException)ce);
        }
    }

    static IPath resolvePageURIToLocation(IPath basePath, String pageURI) {
        IPath pageLocation = null;
        if (basePath != null && pageURI != null) {
            pageLocation = FacetModuleCoreSupport.resolve((IPath)basePath, (String)pageURI);
        }
        if (pageLocation == null) {
            LoggingService.logError((String)"oracle.eclipse.tools.webtier.common.services", (String)("Can not resolve " + pageURI + "relative to base path" + basePath));
        }
        return pageLocation;
    }

    static IFile resolvePageToFile(IPath pageLocation) {
        if (pageLocation == null) {
            return null;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(pageLocation);
        if (file == null || !file.isAccessible()) {
            file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(pageLocation);
        }
        return file;
    }
}

