/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.facet.ui;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.facet.FacetTemplatesHelper;
import oracle.eclipse.tools.webtier.common.services.facet.ui.IFileLabelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public abstract class ConfirmFileActionDialog {
    protected final IProject project;
    protected final IProjectFacetVersion fv;
    protected final IProgressMonitor monitor;
    protected final FacetTemplatesHelper facetTemplatesHelper;

    public ConfirmFileActionDialog(IProject project, IProjectFacetVersion fv, IProgressMonitor monitor, FacetTemplatesHelper facetTemplatesHelper) {
        this.project = project;
        this.fv = fv;
        this.monitor = monitor;
        this.facetTemplatesHelper = facetTemplatesHelper;
    }

    public void execute(final String dialogTitle, final String dialogDescription) {
        Runnable dialogRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ListSelectionDialog dialog = new ListSelectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), ConfirmFileActionDialog.this.facetTemplatesHelper.getExistingTemplateFilesInProject(), (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new IFileLabelProvider(), "");
                    dialog.setTitle(dialogTitle);
                    dialog.setMessage(dialogDescription);
                    if (dialog.open() == 0) {
                        ConfirmFileActionDialog.this.executeFileAction(dialog);
                    }
                }
                catch (CoreException e) {
                    LoggingService.logError((String)"oracle.eclipse.tools.webtier.common.services", (String)e.getLocalizedMessage());
                }
            }
        };
        Display display = Display.getCurrent();
        if (display != null) {
            dialogRunnable.run();
        } else {
            display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(dialogRunnable);
        }
    }

    protected abstract void executeFileAction(ListSelectionDialog var1);
}

