/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.view.common.binding.creator.CreatorInfo;
import oracle.adfdt.view.common.binding.creator.CreatorInfoConfiguration;
import oracle.adfdt.view.common.binding.creator.CreatorInfoConfigurationFactory;
import oracle.adfdt.view.common.binding.creator.CreatorInfoRegistry;
import oracle.adfdt.view.common.binding.registration.DatabindingPatternRegistration;
import oracle.adfdt.view.common.binding.registration.RegistrationConfiguration;
import oracle.adfdt.view.dvt.binding.util.DVTDatabindingRegistration;
import oracle.adfdt.view.rich.binding.Patterns;
import oracle.adfdtinternal.view.common.binding.creator.XmlBasedCreatorInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.util.QueryADFContext;

public class BindingInfoQuery {
    private List<CreatorInfoConfigurationFactory> _factories;
    private Map<String, List<CreatorInfo>> _byProperty;
    private HashMap<String, CreatorInfo> _indexByName;
    private static Logger _LOGGER = Logger.getLogger(BindingInfoQuery.class.getName());

    public void init() {
        this.hookLogger();
        this.ensureFactoriesInit();
        this.indexCreatorInfos();
    }

    public Map<String, List<CreatorInfo>> getByProperty() {
        return Collections.unmodifiableMap(this._byProperty);
    }

    public Map<String, CreatorInfo> getIndexByName() {
        return Collections.unmodifiableMap(this._indexByName);
    }

    private void indexCreatorInfos() {
        this._indexByName = new HashMap();
        this._byProperty = new HashMap<String, List<CreatorInfo>>();
        for (CreatorInfoConfigurationFactory factory : this._factories) {
            CreatorInfoConfiguration creatorInfoConfiguration = factory.createCreatorInfoConfiguration((ADFDesignTimeContext)new QueryADFContext());
            Collection creatorInfos = creatorInfoConfiguration.getCreatorInfos();
            for (CreatorInfo ci : creatorInfos) {
                this._indexByName.put(ci.getName(), ci);
                Map propertiesMap = ((XmlBasedCreatorInfo)ci).getPropertiesMap();
                for (Map.Entry entry : propertiesMap.entrySet()) {
                    List<CreatorInfo> list = this._byProperty.get(entry.getKey());
                    if (list == null) {
                        list = new ArrayList<CreatorInfo>(2);
                        this._byProperty.put((String)entry.getKey(), list);
                    }
                    list.add(ci);
                }
            }
        }
    }

    private List<CreatorInfoConfigurationFactory> ensureFactoriesInit() {
        if (this._factories == null) {
            this._factories = BindingInfoQuery.register(Patterns.ADF_FACES_PATTERN_SOURCE, new RegistrationConfiguration());
            this._factories.addAll(BindingInfoQuery.register(DVTDatabindingRegistration.DVT_PATTERN_SOURCE, new RegistrationConfiguration()));
        }
        return this._factories;
    }

    private void hookLogger() {
        Logger logger = Logger.getLogger(XmlBasedCreatorInfo.class.getName());
        logger.addHandler(new ConsoleHandler(){

            @Override
            public void publish(LogRecord record) {
                Throwable thrown = record.getThrown();
                if (!(thrown instanceof ClassNotFoundException)) {
                    super.publish(record);
                }
            }
        });
        logger.setUseParentHandlers(false);
    }

    private static List<CreatorInfoConfigurationFactory> register(DatabindingPatternRegistration.Source source, RegistrationConfiguration registrationConfiguration) {
        ArrayList<CreatorInfoConfigurationFactory> factories = new ArrayList<CreatorInfoConfigurationFactory>();
        try {
            for (CreatorInfoConfigurationFactory cicf : source.constructCreatorConfigurationFactories(registrationConfiguration)) {
                CreatorInfoRegistry.registerCreatorInfoConfigurationFactory((CreatorInfoConfigurationFactory)cicf);
                factories.add(cicf);
            }
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, "Could not register source: " + source.getName(), e);
        }
        return factories;
    }
}

