/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.faces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import oracle.adfdt.view.common.binding.creator.v2.BinderParams;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.provider.ModelProvider;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.adfdt.view.rich.binding.pattern.table.Column;
import oracle.adfdt.view.rich.binding.pattern.table.TableOptions;
import oracle.adfdtinternal.view.rich.binding.provider.ADFTableModelProvider;
import oracle.binding.meta.NamedDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.faces.AbstractTableFormOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.BindOperationType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.INamedDefinitionModelElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.ITableOptionsModelElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.IValueBindingModelElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.RowSelection;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ExecutableElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableOptionsMapper
extends AbstractTableFormOptionsMapper<Column, TableOptions> {
    private static final String ELEM_TABLE = "table";
    private static final String ATTR_SELECTEDROWKEYS = "selectedRowKeys";
    private static final String ATTR_SELECTIONLISTENER = "selectionListener";
    private static final String ATTR_ROWSELECTION = "rowSelection";
    private static final String ATTR_VAL_SINGLE = "single";
    private static final String ATTR_VAL_MULTIPLE = "multiple";
    private RowSelection _rowSelection;

    public TableOptionsMapper(BindOperationType opType, Widget<TableOptions> widget, CreatorParams<TableOptions> params) {
        super(opType, widget, params);
    }

    @Override
    protected ExecutableElement createModel() {
        ITableOptionsModelElement model = (ITableOptionsModelElement)ITableOptionsModelElement.TYPE.instantiate();
        if (this.getRowSelection() != RowSelection.NONE) {
            model.setRowSelection(this.getRowSelection());
        }
        if (((TableOptions)this.getPatternOptions()).isFiltered()) {
            model.setFiltered(Boolean.TRUE);
        }
        if (((TableOptions)this.getPatternOptions()).isReadOnly()) {
            model.setReadOnly(Boolean.TRUE);
        }
        if (((TableOptions)this.getPatternOptions()).isSorted()) {
            model.setSorted(Boolean.TRUE);
        }
        this.initPossibleNamedDefs(model);
        List<Column> columns = ((TableOptions)this.getPatternOptions()).getColumns();
        if (columns.isEmpty()) {
            columns = this.getColumns();
        }
        for (Column column : columns) {
            Widget preferredWidget;
            IValueBindingModelElement vbModelElem;
            NamedDefinition namedDef = column.getDefinition();
            if (namedDef == null || (vbModelElem = (IValueBindingModelElement)model.getColumns().insert()) == null) continue;
            vbModelElem.setDisplayLabel(TableOptionsMapper.computeUILabel(column.getLabel(), namedDef.getName()));
            vbModelElem.setValueBinding(TableOptionsMapper.getFullName(namedDef));
            Widget widget = column.getWidget();
            if (widget != null) {
                vbModelElem.setComponentToUse(widget.getId());
                continue;
            }
            Collection<String> inclusionContexts = null;
            if (((TableOptions)this.getPatternOptions()).isReadOnly()) {
                inclusionContexts = this.getReadOnlyInclusionContexts();
            }
            if ((preferredWidget = this.getPreferredWidget(column, inclusionContexts)) == null) continue;
            vbModelElem.setComponentToUse(preferredWidget.getId());
        }
        return model;
    }

    @Override
    public void updateOptions() {
        ITableOptionsModelElement model = (ITableOptionsModelElement)this.getModel();
        TableOptions options = (TableOptions)this.getPatternOptions();
        ArrayList<Column> columns = new ArrayList<Column>();
        ElementList columnElems = model.getColumns();
        for (IValueBindingModelElement colModelElem : columnElems) {
            String componentToUse;
            String attrId = (String)colModelElem.getValueBinding().content();
            Column column = this.createColumn(attrId, componentToUse = (String)colModelElem.getComponentToUse().content());
            if (column == null) continue;
            String label = (String)colModelElem.getDisplayLabel().content();
            column.setLabel(TableOptionsMapper.computeOptionsLabel(label));
            columns.add(column);
        }
        options.setColumns(columns);
        boolean isFiltered = model.isFiltered().content() == Boolean.TRUE;
        options.setFiltered(!isFiltered);
        options.setFiltered(isFiltered);
        options.setReadOnly(model.isReadOnly().content() == Boolean.TRUE);
        this._rowSelection = (RowSelection)model.getRowSelection().content();
        options.setSelection(this.getTableOptionsSelection(this._rowSelection));
        options.setSorted(model.isSorted().content() == Boolean.TRUE);
    }

    private TableOptions.Selection getTableOptionsSelection(RowSelection rowSelection) {
        switch (rowSelection) {
            case SINGLE: {
                return TableOptions.Selection.SINGLE;
            }
            case MULTIPLE: {
                return TableOptions.Selection.MULTIPLE;
            }
        }
        return TableOptions.Selection.NONE;
    }

    @Override
    public void postProcess(Node node) {
        Element tableElement = TableOptionsMapper.getSingleBindRoot(node);
        if (tableElement != null && ELEM_TABLE.equals(tableElement.getLocalName())) {
            if (this._rowSelection == RowSelection.NONE) {
                tableElement.removeAttributeNS(null, ATTR_SELECTEDROWKEYS);
                tableElement.removeAttributeNS(null, ATTR_SELECTIONLISTENER);
                tableElement.removeAttributeNS(null, ATTR_ROWSELECTION);
            } else if (this._rowSelection == RowSelection.SINGLE) {
                String selectionListener;
                String selectionState = this.getSelectionStateExpression();
                if (selectionState != null) {
                    tableElement.setAttributeNS(null, ATTR_SELECTEDROWKEYS, selectionState);
                }
                if ((selectionListener = this.getSelectionListenerExpression()) != null) {
                    tableElement.setAttributeNS(null, ATTR_SELECTIONLISTENER, selectionListener);
                }
                tableElement.setAttributeNS(null, ATTR_ROWSELECTION, ATTR_VAL_SINGLE);
            } else if (this._rowSelection == RowSelection.MULTIPLE) {
                String selectionListener;
                String selectionState = this.getSelectionStateExpression();
                if (selectionState != null && this.selectionStateMatches(selectionState, tableElement.getAttributeNS(null, ATTR_SELECTEDROWKEYS))) {
                    tableElement.removeAttributeNS(null, ATTR_SELECTEDROWKEYS);
                }
                if ((selectionListener = this.getSelectionListenerExpression()) != null) {
                    tableElement.setAttributeNS(null, ATTR_SELECTIONLISTENER, selectionListener);
                }
                tableElement.setAttributeNS(null, ATTR_ROWSELECTION, ATTR_VAL_MULTIPLE);
            }
        }
    }

    private String getSelectionStateExpression() {
        String el = null;
        ADFTableModelProvider provider = this.getADFTableModelProvider();
        if (provider != null) {
            el = provider.getSelectionStateExpression();
        }
        return el;
    }

    private String getSelectionListenerExpression() {
        String el = null;
        ADFTableModelProvider provider = this.getADFTableModelProvider();
        if (provider != null) {
            el = provider.getSelectionListenerExpression();
        }
        return el;
    }

    private boolean selectionStateMatches(String existingValue, String newValue) {
        boolean matches = false;
        if (existingValue != null && newValue != null) {
            StringTokenizer stExistingValue = new StringTokenizer(existingValue, ".");
            StringTokenizer stNewValue = new StringTokenizer(newValue, ".");
            if (stExistingValue.countTokens() == stNewValue.countTokens()) {
                matches = true;
                int tokenNum = 0;
                while (stExistingValue.hasMoreTokens()) {
                    String existingValueToken = stExistingValue.nextToken();
                    String newValueToken = stNewValue.nextToken();
                    if (++tokenNum == 2) continue;
                    matches &= existingValueToken.equals(newValueToken);
                }
            }
        }
        return matches;
    }

    private ADFTableModelProvider getADFTableModelProvider() {
        ModelProvider modelProvider;
        ADFTableModelProvider provider = null;
        CreatorParams params = this.getParams();
        if (params != null && (modelProvider = params.getModelProvider()) instanceof ADFTableModelProvider) {
            provider = (ADFTableModelProvider)modelProvider;
        }
        return provider;
    }

    private RowSelection getRowSelection() {
        BinderParams binderParams;
        Element table;
        CreatorParams params = this.getParams();
        if (params instanceof BinderParams && (table = TableOptionsMapper.getSingleBindRoot((binderParams = (BinderParams)params).getBindRoots())) != null && ELEM_TABLE.equals(table.getLocalName())) {
            String rowSelectionVal = table.getAttributeNS(null, ATTR_ROWSELECTION);
            if (ATTR_VAL_SINGLE.equals(rowSelectionVal)) {
                return RowSelection.SINGLE;
            }
            if (ATTR_VAL_MULTIPLE.equals(rowSelectionVal)) {
                return RowSelection.MULTIPLE;
            }
        }
        return RowSelection.NONE;
    }

    private void initPossibleNamedDefs(ITableOptionsModelElement model) {
        for (Column column : this.getColumns()) {
            NamedDefinition namedDef = column.getDefinition();
            if (namedDef == null) continue;
            INamedDefinitionModelElement namedDefModelElem = (INamedDefinitionModelElement)model.getNamedDefs().insert();
            namedDefModelElem.setFullName(TableOptionsMapper.getFullName(namedDef));
            namedDefModelElem.setName(TableOptionsMapper.getNamedDefQualifiedName(namedDef));
            this.initPossibleNamedDefWidgets(column, namedDefModelElem);
        }
    }

    private Column createColumn(String attrId, String componentToUse) {
        if (attrId != null) {
            for (Column c : this.getColumns()) {
                NamedDefinition namedDef = c.getDefinition();
                if (namedDef == null || !attrId.equals(TableOptionsMapper.getFullName(namedDef))) continue;
                Column column = Column.create((NamedDefinition)namedDef);
                if (componentToUse != null) {
                    for (Widget widget : this.getAvailableWidgets(c)) {
                        if (!componentToUse.equals(widget.getId())) continue;
                        column.setWidget(widget);
                        return column;
                    }
                }
                return column;
            }
        }
        return null;
    }

    private List<Column> getColumns() {
        if (this.getCreatePatternOptions() != null) {
            return ((TableOptions)this.getCreatePatternOptions()).getColumns();
        }
        return new ArrayList<Column>();
    }

    @Override
    protected List<Widget> getAvailableWidgets(Column column) {
        if (this.getCreatePatternOptions() != null && column != null) {
            return ((TableOptions)this.getCreatePatternOptions()).getAvailableWidgets(column);
        }
        return new ArrayList<Widget>();
    }

    @Override
    public String getDefinitionPath() {
        return "table.options.wizard";
    }
}

