/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.faces;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.binding.meta.NamedDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlChild;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectCustomization;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IDataControlStructureObject;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.ISelectOneOptionsModel;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Status;

public class SelectOneOptionsModel
implements ISelectOneOptionsModel {
    private final NamedDefinition _targetAttribute;
    private final List<? extends IDataControlObject> _dataControls;
    private final List<? extends StructureObjectCustomization.LOV> _modelLOVs;
    private IDataControlObject _listDataSource;
    private IDataControlObject _listAttribute;
    private IDataControlObject _displayAttribute;
    private IValidator _validator;

    public SelectOneOptionsModel(NamedDefinition namedDef, List<? extends IDataControlObject> dataControls, List<? extends StructureObjectCustomization.LOV> modelLOVs, IValidator validator) {
        this._targetAttribute = namedDef;
        this._dataControls = dataControls;
        this._modelLOVs = modelLOVs;
        this._validator = validator;
    }

    public String getTargetAttributeName() {
        return this._targetAttribute.getFullName();
    }

    public String getQualifiedTargetAttributeName() {
        return null;
    }

    public List<? extends IDataControlObject> getDataControls() {
        return this._dataControls;
    }

    public IDataControlObject getListDataSource() {
        return this._listDataSource;
    }

    public void setListDataSource(IDataControlObject dataControlObject) {
        this._listDataSource = dataControlObject;
    }

    public IDataControlObject getListAttribute() {
        return this._listAttribute;
    }

    public void setListAttribute(IDataControlObject dataControlObject) {
        this._listAttribute = dataControlObject;
    }

    public IDataControlObject getDisplayAttribute() {
        return this._displayAttribute;
    }

    public void setDisplayAttribute(IDataControlObject dataControlObject) {
        this._displayAttribute = dataControlObject;
    }

    public boolean validListDataSource(IDataControlObject dcObject) {
        return this._validator.validate((Object)dcObject) == Status.OK_STATUS;
    }

    public List<? extends IDataControlObject> getChildAttributes(IDataControlObject dcObject) {
        ArrayList<IDataControlChild> list = new ArrayList<IDataControlChild>();
        for (IDataControlChild child : dcObject.getChildren()) {
            Object decoratedObject;
            if (!(child instanceof IDataControlStructureObject) || !((decoratedObject = ((IDataControlStructureObject)child).getDecoratedObject()) instanceof NamedDefinition) || ((NamedDefinition)decoratedObject).getDefinitionType() != 30) continue;
            list.add(child);
        }
        return Collections.unmodifiableList(list);
    }

    public boolean hasModelListBinding() {
        return this._modelLOVs != null && !this._modelLOVs.isEmpty() && this._modelLOVs.get(0) != null;
    }

    public String getModelListBindingName() {
        return this.hasModelListBinding() ? this._modelLOVs.get(0).getName() : "";
    }
}

