/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.faces;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.adf.model.adapter.dataformat.AttributeDef;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.creator.v2.PatternOptions;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.NamedDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.WidgetImpl;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.DefaultOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.BindOperationType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.IOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.IComponentModelElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.INamedDefinitionModelElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.ComponentOptionsPageProvider;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.faces.TableFormOptionsPageProvider;
import org.eclipse.sapphire.ExecutableElement;

abstract class AbstractTableFormOptionsMapper<T, O extends PatternOptions>
extends DefaultOptionsMapper<O> {
    public static final String DEFAULT_LABEL = "<default>";
    public static final Set<String> COLUMN_PATTERNS_TO_DROP = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("oracle.adf.view.dvt.patterns.StampedDialGauge", "oracle.adf.view.dvt.patterns.StampedSMGauge", "oracle.adf.view.dvt.patterns.StampedVerticalSMGauge", "oracle.adf.view.dvt.patterns.StampedLEDGauge")));
    private final List<String> _readOnlyInclusionContexts = new ArrayList<String>();
    private ExecutableElement _model = null;

    public AbstractTableFormOptionsMapper(BindOperationType opType, Widget<O> widget, CreatorParams<O> params) {
        super(opType, widget, params);
        this._readOnlyInclusionContexts.add("fusionAdfReadOnlyForm");
    }

    public ExecutableElement getModel() {
        if (this._model == null || this._model.disposed()) {
            this._model = this.createModel();
        }
        return this._model;
    }

    protected abstract ExecutableElement createModel();

    @Override
    public ComponentOptionsPageProvider createPageProvider() {
        return new TableFormOptionsPageProvider((IOptionsMapper)this);
    }

    protected Collection<String> getReadOnlyInclusionContexts() {
        return Collections.unmodifiableList(this._readOnlyInclusionContexts);
    }

    protected void initPossibleNamedDefWidgets(T childComponent, INamedDefinitionModelElement namedDefModelElem) {
        List<Widget> possibleWidgets = this.getSortedWidgets(childComponent);
        if (!possibleWidgets.isEmpty()) {
            boolean defaultFound = false;
            block0: for (Widget widget : possibleWidgets) {
                String id = widget.getId();
                if (WidgetImpl.PATTERNS_TO_DROP.contains(id) || COLUMN_PATTERNS_TO_DROP.contains(id)) continue;
                IComponentModelElement component = (IComponentModelElement)namedDefModelElem.getAvailableComponents().insert();
                component.setId(id);
                component.setName(AbstractTableFormOptionsMapper.filterName(widget.getName()));
                component.setRead(Boolean.FALSE);
                for (String ic : this.getReadOnlyInclusionContexts()) {
                    if (!widget.getCreator().supportsInclusionContext(ic)) continue;
                    component.setRead(Boolean.TRUE);
                    if (defaultFound) continue block0;
                    namedDefModelElem.setDefaultComponentId(id);
                    defaultFound = true;
                    continue block0;
                }
            }
            if (!defaultFound) {
                IComponentModelElement component = (IComponentModelElement)namedDefModelElem.getAvailableComponents().get(0);
                namedDefModelElem.setDefaultComponentId((String)component.getId().content());
            }
        }
    }

    protected abstract List<Widget> getAvailableWidgets(T var1);

    protected Widget getPreferredWidget(T childComponent, Collection<String> inclusionContexts) {
        List<Widget> possibleWidgets = this.getSortedWidgets(childComponent);
        if (possibleWidgets.isEmpty()) {
            return null;
        }
        if (inclusionContexts != null && !inclusionContexts.isEmpty()) {
            for (Widget widget : possibleWidgets) {
                for (String ic : inclusionContexts) {
                    if (!widget.getCreator().supportsInclusionContext(ic)) continue;
                    return widget;
                }
            }
        }
        return possibleWidgets.iterator().next();
    }

    protected static String computeUILabel(String currentValue, String name) {
        if (currentValue != null) {
            String labelSuffix = String.valueOf(name) + ".label}";
            if (!(currentValue.startsWith("#{bindings.") && currentValue.contains(".hints.") && currentValue.endsWith(labelSuffix))) {
                return currentValue;
            }
        }
        return DEFAULT_LABEL;
    }

    protected static String computeOptionsLabel(String value) {
        if (DEFAULT_LABEL.equals(value)) {
            return null;
        }
        return value;
    }

    private List<Widget> getSortedWidgets(T childComponent) {
        ArrayList<Widget> sortedWidgets = new ArrayList<Widget>(this.getAvailableWidgets(childComponent));
        if (!sortedWidgets.isEmpty()) {
            Collections.sort(sortedWidgets, new CreatorComparator());
        }
        return sortedWidgets;
    }

    private static String filterName(String name) {
        return name.replaceAll("&", "");
    }

    protected static String getNamedDefQualifiedName(NamedDefinition namedDef) {
        StringBuilder sbName = new StringBuilder("");
        if (namedDef != null) {
            sbName.append(AbstractTableFormOptionsMapper.capitalizeFirstChar(namedDef.getName()));
            Definition parentDef = namedDef.getDefinitionParent();
            if (parentDef != null && parentDef.getDefinitionType() == 40) {
                Definition grandParentDef = ((AccessorDefinition)parentDef).getDefinitionParent();
                while (grandParentDef != null && grandParentDef.getDefinitionType() == 40) {
                    sbName.insert(0, '.');
                    sbName.insert(0, AbstractTableFormOptionsMapper.capitalizeFirstChar(((AccessorDefinition)parentDef).getName()));
                    parentDef = grandParentDef;
                    grandParentDef = ((AccessorDefinition)grandParentDef).getDefinitionParent();
                }
            }
        }
        return sbName.toString();
    }

    protected static String capitalizeFirstChar(String string) {
        String ret = string;
        if (string != null) {
            ret = string.length() > 1 ? String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1) : string.toUpperCase();
        }
        return ret;
    }

    protected static String getFullName(NamedDefinition namedDef) {
        Definition parentDef;
        String fullName = null;
        if (namedDef instanceof AttributeDef && (parentDef = namedDef.getDefinitionParent()) instanceof NamedDefinition) {
            Definition grandParentDef = ((NamedDefinition)parentDef).getDefinitionParent();
            if (grandParentDef != null && grandParentDef.getDefinitionType() == 50) {
                fullName = namedDef.getFullName();
            } else {
                AttributeDef attrDef = (AttributeDef)namedDef;
                StringBuilder builder = new StringBuilder();
                builder.append(attrDef.getBindPath()).append('.').append(attrDef.getName());
                fullName = builder.toString();
            }
        }
        return fullName != null ? fullName : (namedDef != null ? namedDef.getFullName() : null);
    }

    private static class CreatorComparator
    implements Comparator<Widget> {
        private CreatorComparator() {
        }

        @Override
        public int compare(Widget w1, Widget w2) {
            float diff = w2.getCreator().getRank() - w1.getCreator().getRank();
            if (diff < 0.0f) {
                return -1;
            }
            if (diff > 0.0f) {
                return 1;
            }
            String name1 = w1.getName();
            String name2 = w2.getName();
            if (name1 != null && name2 != null) {
                int index = name1.indexOf(38);
                if (index >= 0) {
                    name1 = String.valueOf(name1.substring(0, index)) + name1.substring(index + 1);
                }
                if ((index = name2.indexOf(38)) >= 0) {
                    name2 = String.valueOf(name2.substring(0, index)) + name2.substring(index + 1);
                }
                return name1.compareToIgnoreCase(name2);
            }
            return 0;
        }
    }
}

