/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.binding.meta.AttributeDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.GraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.ICreatorPresentation;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.IPresentationLayout;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GraphType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IStockGraphOptionsModel;

class StockGraphOptionsModel
extends GraphOptionsModel
implements IStockGraphOptionsModel {
    private static final Map<String, Set<IStockGraphOptionsModel.Property>> SUBTYPE_PROPERTIES_MAP;
    private EdgeItemContext _time;
    private EdgeItemContext _open;
    private EdgeItemContext _high;
    private EdgeItemContext _low;
    private EdgeItemContext _close;
    private EdgeItemContext _volume;

    static {
        HashMap<String, EnumSet<IStockGraphOptionsModel.Property>> map = new HashMap<String, EnumSet<IStockGraphOptionsModel.Property>>();
        map.put("STOCK_HILO_CLOSE", EnumSet.of(IStockGraphOptionsModel.Property.HIGH, IStockGraphOptionsModel.Property.LOW, IStockGraphOptionsModel.Property.CLOSE));
        map.put("STOCK_HILO_CLOSE_VOLUME", EnumSet.of(IStockGraphOptionsModel.Property.HIGH, IStockGraphOptionsModel.Property.LOW, IStockGraphOptionsModel.Property.CLOSE, IStockGraphOptionsModel.Property.VOLUME));
        map.put("STOCK_OPEN_HILO_CLOSE", EnumSet.of(IStockGraphOptionsModel.Property.OPEN, IStockGraphOptionsModel.Property.HIGH, IStockGraphOptionsModel.Property.LOW, IStockGraphOptionsModel.Property.CLOSE));
        map.put("STOCK_VOLUME", EnumSet.of(IStockGraphOptionsModel.Property.OPEN, IStockGraphOptionsModel.Property.HIGH, IStockGraphOptionsModel.Property.LOW, IStockGraphOptionsModel.Property.CLOSE, IStockGraphOptionsModel.Property.VOLUME));
        map.put("STOCK_CANDLE", EnumSet.of(IStockGraphOptionsModel.Property.OPEN, IStockGraphOptionsModel.Property.CLOSE));
        map.put("STOCK_CANDLE_VOLUME", EnumSet.of(IStockGraphOptionsModel.Property.OPEN, IStockGraphOptionsModel.Property.CLOSE, IStockGraphOptionsModel.Property.VOLUME));
        map.put("STOCK_OHLC_CANDLE", EnumSet.of(IStockGraphOptionsModel.Property.OPEN, IStockGraphOptionsModel.Property.HIGH, IStockGraphOptionsModel.Property.LOW, IStockGraphOptionsModel.Property.CLOSE));
        map.put("STOCK_OHLC_CANDLE_VOLUME", EnumSet.of(IStockGraphOptionsModel.Property.OPEN, IStockGraphOptionsModel.Property.HIGH, IStockGraphOptionsModel.Property.LOW, IStockGraphOptionsModel.Property.CLOSE, IStockGraphOptionsModel.Property.VOLUME));
        SUBTYPE_PROPERTIES_MAP = Collections.unmodifiableMap(map);
    }

    public StockGraphOptionsModel(GraphType type, ICreatorPresentation creatorPresentation, List<AttributeDefinition> attributes) {
        super(type, creatorPresentation, attributes);
        super.setDataOnSeries(false);
    }

    @Override
    public void setDataOnSeries(boolean dataOnSeries) {
    }

    @Override
    public List<EdgeItemContext> getGroupsItemContexts() {
        ArrayList<EdgeItemContext> dataItems = new ArrayList<EdgeItemContext>();
        if (this.getTime() != null) {
            dataItems.add(this.getTime());
        }
        if (this.requiresOpen() && this.getOpen() != null) {
            dataItems.add(this.getOpen());
        }
        if (this.requiresHigh() && this.getHigh() != null) {
            dataItems.add(this.getHigh());
        }
        if (this.requiresLow() && this.getLow() != null) {
            dataItems.add(this.getLow());
        }
        if (this.requiresClose() && this.getClose() != null) {
            dataItems.add(this.getClose());
        }
        if (this.requiresVolume() && this.getVolume() != null) {
            dataItems.add(this.getVolume());
        }
        return Collections.unmodifiableList(dataItems);
    }

    @Override
    public void setGroupsItemContexts(List<EdgeItemContext> groups) {
        this._volume = null;
        this._close = null;
        this._low = null;
        this._high = null;
        this._open = null;
        this._time = null;
        if (groups != null && !groups.isEmpty()) {
            ArrayList<EdgeItemContext> dataItems = new ArrayList<EdgeItemContext>();
            for (EdgeItemContext item : groups) {
                if (item == null) continue;
                if (!item.isDataItem()) {
                    this.setTime(item);
                    continue;
                }
                if (!item.isNumeric()) continue;
                dataItems.add(item);
            }
            int index = 0;
            if (this.requiresOpen() && index < dataItems.size()) {
                this.setOpen((EdgeItemContext)dataItems.get(index++));
            }
            if (this.requiresHigh() && index < dataItems.size()) {
                this.setHigh((EdgeItemContext)dataItems.get(index++));
            }
            if (this.requiresLow() && index < dataItems.size()) {
                this.setLow((EdgeItemContext)dataItems.get(index++));
            }
            if (this.requiresClose() && index < dataItems.size()) {
                this.setClose((EdgeItemContext)dataItems.get(index++));
            }
            if (this.requiresVolume() && index < dataItems.size()) {
                this.setVolume((EdgeItemContext)dataItems.get(index++));
            }
        }
        super.setGroupsItemContexts(groups);
    }

    @Override
    public void resetData() {
        this.setSeriesItemContexts(null);
        this.setGroupsItemContexts(null);
    }

    public EdgeItemContext getStock() {
        List<EdgeItemContext> dataItems = this.getSeriesItemContexts();
        if (dataItems != null && !dataItems.isEmpty()) {
            return dataItems.get(0);
        }
        return null;
    }

    public void setStock(EdgeItemContext dataValue) {
        ArrayList<EdgeItemContext> dataItems = new ArrayList<EdgeItemContext>();
        if (dataValue != null) {
            dataItems.add(dataValue);
        }
        this.setSeriesItemContexts(dataItems);
    }

    public EdgeItemContext getTime() {
        return this._time;
    }

    public void setTime(EdgeItemContext dataValue) {
        this._time = dataValue;
    }

    public EdgeItemContext getOpen() {
        return this._open;
    }

    public void setOpen(EdgeItemContext dataValue) {
        this._open = dataValue;
    }

    public boolean requiresOpen() {
        IPresentationLayout layout = this.getPresentationLayout();
        if (layout != null && layout.getVariationType() != null) {
            return SUBTYPE_PROPERTIES_MAP.get(layout.getVariationType()).contains(IStockGraphOptionsModel.Property.OPEN);
        }
        return false;
    }

    public EdgeItemContext getHigh() {
        return this._high;
    }

    public void setHigh(EdgeItemContext dataValue) {
        this._high = dataValue;
    }

    public boolean requiresHigh() {
        IPresentationLayout layout = this.getPresentationLayout();
        if (layout != null && layout.getVariationType() != null) {
            return SUBTYPE_PROPERTIES_MAP.get(layout.getVariationType()).contains(IStockGraphOptionsModel.Property.HIGH);
        }
        return false;
    }

    public EdgeItemContext getLow() {
        return this._low;
    }

    public void setLow(EdgeItemContext dataValue) {
        this._low = dataValue;
    }

    public boolean requiresLow() {
        IPresentationLayout layout = this.getPresentationLayout();
        if (layout != null && layout.getVariationType() != null) {
            return SUBTYPE_PROPERTIES_MAP.get(layout.getVariationType()).contains(IStockGraphOptionsModel.Property.LOW);
        }
        return false;
    }

    public EdgeItemContext getClose() {
        return this._close;
    }

    public void setClose(EdgeItemContext dataValue) {
        this._close = dataValue;
    }

    public boolean requiresClose() {
        IPresentationLayout layout = this.getPresentationLayout();
        if (layout != null && layout.getVariationType() != null) {
            return SUBTYPE_PROPERTIES_MAP.get(layout.getVariationType()).contains(IStockGraphOptionsModel.Property.CLOSE);
        }
        return false;
    }

    public EdgeItemContext getVolume() {
        return this._volume;
    }

    public void setVolume(EdgeItemContext dataValue) {
        this._volume = dataValue;
    }

    public boolean requiresVolume() {
        IPresentationLayout layout = this.getPresentationLayout();
        if (layout != null && layout.getVariationType() != null) {
            return SUBTYPE_PROPERTIES_MAP.get(layout.getVariationType()).contains(IStockGraphOptionsModel.Property.VOLUME);
        }
        return false;
    }

    public Set<IStockGraphOptionsModel.Property> getSubtypeProperties(String subtype) {
        return SUBTYPE_PROPERTIES_MAP.get(subtype);
    }
}

