/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt;

import java.util.List;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphFootnote;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphSubtitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphTitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.LegendArea;
import oracle.adfdt.view.dvt.binding.pattern.graph.LegendTitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.O1Title;
import oracle.adfdt.view.dvt.binding.pattern.graph.StockGraphOptions;
import oracle.adfdt.view.dvt.binding.pattern.graph.Y1Title;
import oracle.adfdt.view.dvt.binding.pattern.options.GraphBindingOptions;
import oracle.binding.meta.AttributeDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.AxisGraphOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.GraphOptionsResources;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.ICommonAxisGraphOptions;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.StockGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.ICreatorPresentation;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.BindOperationType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GraphType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IStockGraphOptionsModel;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StockGraphOptionsMapper
extends AxisGraphOptionsMapper<StockGraphOptions> {
    public StockGraphOptionsMapper(BindOperationType opType, Widget<StockGraphOptions> widget, CreatorParams<StockGraphOptions> params) {
        super(opType, widget, params);
    }

    public IStockGraphOptionsModel getModel() {
        return (IStockGraphOptionsModel)super.getModel();
    }

    protected IStockGraphOptionsModel createModel(GraphType type, ICreatorPresentation creatorPresentation, List<AttributeDefinition> attrDefs) {
        return new StockGraphOptionsModel(type, creatorPresentation, attrDefs);
    }

    @Override
    protected GraphType getType() {
        return GraphType.STOCK;
    }

    @Override
    protected String getSeriesLabel() {
        return null;
    }

    @Override
    public IStatus validateModel() {
        if (!this.getModel().isNameValuePair() && (this.getModel().getStock() == null || this.getModel().getTime() == null || this.getModel().requiresOpen() && this.getModel().getOpen() == null || this.getModel().requiresHigh() && this.getModel().getHigh() == null || this.getModel().requiresLow() && this.getModel().getLow() == null || this.getModel().requiresClose() && this.getModel().getClose() == null || this.getModel().requiresVolume() && this.getModel().getVolume() == null)) {
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", GraphOptionsResources.stockGraph_validationError);
        }
        return null;
    }

    @Override
    protected boolean isNonDataItemsOrderedFirst() {
        return true;
    }

    @Override
    protected ICommonAxisGraphOptions getCommonGraphOptions() {
        return new StockGraphOptionsWrapper((StockGraphOptions)this.getPatternOptions());
    }

    @Override
    public void postProcess(Node node) {
        super.postProcess(node);
        Element graphElement = StockGraphOptionsMapper.getSingleBindRoot(node);
        if (graphElement != null) {
            graphElement.removeAttribute("threeDEffect");
        }
    }

    private class StockGraphOptionsWrapper
    implements ICommonAxisGraphOptions {
        private StockGraphOptions _graphOptions;

        StockGraphOptionsWrapper(StockGraphOptions graphOptions) {
            this._graphOptions = graphOptions;
        }

        @Override
        public String getGraphType() {
            return this._graphOptions.getGraphType();
        }

        @Override
        public String getGraphSubType() {
            return this._graphOptions.getGraphSubType();
        }

        @Override
        public void setGraphSubType(String graphSubType) {
            this._graphOptions.setGraphSubType(graphSubType);
        }

        @Override
        public GraphBindingOptions getBindingOptions() {
            return this._graphOptions.getBindingOptions();
        }

        @Override
        public void setRowSelection(boolean rowSelection) {
            this._graphOptions.setRowSelection(rowSelection);
        }

        @Override
        public boolean isRowSelection() {
            return this._graphOptions.isRowSelection();
        }

        @Override
        public void setGraphFootnote(GraphFootnote graphFootnote) {
            this._graphOptions.getExtendedProperties().setGraphFootnote(graphFootnote);
        }

        @Override
        public void setGraphSubtitle(GraphSubtitle graphSubtitle) {
            this._graphOptions.getExtendedProperties().setGraphSubtitle(graphSubtitle);
        }

        @Override
        public void setGraphTitle(GraphTitle graphTitle) {
            this._graphOptions.getExtendedProperties().setGraphTitle(graphTitle);
        }

        @Override
        public void setLegendArea(LegendArea legendArea) {
            this._graphOptions.getExtendedProperties().setLegendArea(legendArea);
        }

        @Override
        public void setLegendTitle(LegendTitle legendTitle) {
            this._graphOptions.getExtendedProperties().setLegendTitle(legendTitle);
        }

        @Override
        public void setO1Title(O1Title o1Title) {
            this._graphOptions.getExtendedProperties().setO1Title(o1Title);
        }

        @Override
        public void setY1Title(Y1Title y1Title) {
            this._graphOptions.getExtendedProperties().setY1Title(y1Title);
        }
    }
}

