/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.binding.meta.AttributeDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.util.BindingUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.ICreatorPresentation;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.PresentationOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.ISparkChartOptionsModel;

class SparkChartOptionsModel
extends PresentationOptionsModel
implements ISparkChartOptionsModel {
    static final String VARIATION_TYPE_AREA = "AREA_VERT_ABS";
    static final String VARIATION_TYPE_BAR = "BAR_VERT_CLUST";
    static final String VARIATION_TYPE_FLOAT_BAR = "BAR_VERT_FLOAT_STACK";
    static final String VARIATION_TYPE_LINE = "LINE_VERT_ABS";
    private final List<String> _attributes;
    private String _value;
    private String _floatValue;

    public SparkChartOptionsModel(ICreatorPresentation creatorPresentation, List<AttributeDefinition> attributes) {
        super("graphType", creatorPresentation);
        if (attributes == null) {
            throw new IllegalArgumentException("Programming Error: Attribute definitions cannot be null");
        }
        ArrayList<String> names = new ArrayList<String>();
        for (AttributeDefinition attrDef : attributes) {
            if (!BindingUtil.isNumericAttribute(attrDef)) continue;
            names.add(attrDef.getName());
        }
        this._attributes = Collections.unmodifiableList(names);
    }

    public void resetData() {
        this.setValue(null);
        this.setFloatValue(null);
    }

    public List<String> getAllAttributes() {
        return this._attributes;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public boolean isArea() {
        return this.getPresentationLayout() != null && VARIATION_TYPE_AREA.equals(this.getPresentationLayout().getVariationType());
    }

    public boolean isBar() {
        return this.getPresentationLayout() != null && VARIATION_TYPE_BAR.equals(this.getPresentationLayout().getVariationType());
    }

    public boolean isFloatingBar() {
        return this.getPresentationLayout() != null && VARIATION_TYPE_FLOAT_BAR.equals(this.getPresentationLayout().getVariationType());
    }

    public boolean isLine() {
        return this.getPresentationLayout() != null && VARIATION_TYPE_LINE.equals(this.getPresentationLayout().getVariationType());
    }

    public String getFloatValue() {
        return this._floatValue;
    }

    public void setFloatValue(String floatValue) {
        this._floatValue = floatValue;
    }
}

