/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt;

import java.util.List;
import oracle.adfdt.view.common.binding.creator.v2.BinderParams;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphFootnote;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphSubtitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphTitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.LegendArea;
import oracle.adfdt.view.dvt.binding.pattern.graph.LegendTitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.O1Title;
import oracle.adfdt.view.dvt.binding.pattern.graph.ScatterGraphOptions;
import oracle.adfdt.view.dvt.binding.pattern.graph.X1Title;
import oracle.adfdt.view.dvt.binding.pattern.graph.Y1Title;
import oracle.adfdt.view.dvt.binding.pattern.options.GraphBindingOptions;
import oracle.binding.meta.AttributeDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.AxisGraphOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.GraphOptionsResources;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.ICommonAxisGraphOptions;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.ScatterGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.ICreatorPresentation;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.BindOperationType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GraphType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IScatterGraphOptionsModel;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScatterGraphOptionsMapper
extends AxisGraphOptionsMapper<ScatterGraphOptions> {
    private static final String MARKER_COLOR_ATTR_NAME = "markerColorAttribute";
    private static final String MARKER_SHAPE_ATTR_NAME = "markerShapeAttribute";

    public ScatterGraphOptionsMapper(BindOperationType opType, Widget<ScatterGraphOptions> widget, CreatorParams<ScatterGraphOptions> params) {
        super(opType, widget, params);
    }

    public IScatterGraphOptionsModel getModel() {
        return (IScatterGraphOptionsModel)super.getModel();
    }

    protected IScatterGraphOptionsModel createModel(GraphType type, ICreatorPresentation creatorPresentation, List<AttributeDefinition> attrDefs) {
        return new ScatterGraphOptionsModel(type, creatorPresentation, attrDefs);
    }

    @Override
    protected void initModel(IGraphOptionsModel model) {
        Element graphElement;
        Node bindRoot;
        super.initModel(model);
        ICommonAxisGraphOptions options = this.getCommonGraphOptions();
        if (this.getBindingContextType() != BindOperationType.CREATE && (bindRoot = ((BinderParams)this.getParams()).getBindRoots()) != null && (graphElement = ScatterGraphOptionsMapper.getSingleBindRoot(bindRoot)) != null && graphElement.getLocalName().equals(options.getGraphType())) {
            String shape;
            String color = graphElement.getAttribute(MARKER_COLOR_ATTR_NAME);
            if (color == null || color.trim().length() == 0) {
                color = null;
            }
            if ((shape = graphElement.getAttribute(MARKER_SHAPE_ATTR_NAME)) == null || shape.trim().length() == 0) {
                shape = null;
            }
            ((IScatterGraphOptionsModel)model).setAutomaticallyAssigned(color == null && shape == null);
        }
    }

    @Override
    protected GraphType getType() {
        return GraphType.SCATTER;
    }

    @Override
    protected String getSeriesLabel() {
        return null;
    }

    @Override
    public IStatus validateModel() {
        List series;
        List groups;
        if (!(this.getModel().isNameValuePair() || (groups = this.getModel().getGroupsItemContexts()) != null && groups.size() >= 2 && this.getModel().getXAxisDataPoint() != null && this.getModel().getXAxisDataPoint().isNumeric() && this.getModel().getYAxisDataPoint() != null && this.getModel().getYAxisDataPoint().isNumeric())) {
            String message = GraphOptionsResources.error_xyAxisDataPoints;
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", message);
        }
        if (!(this.getModel().isAutomaticallyAssigned() || (series = this.getModel().getSeriesItemContexts()) != null && series.size() == 2 && this.getModel().getMarkerColor() != null && this.getModel().getMarkerShape() != null)) {
            String message = GraphOptionsResources.scatterGraph_shapeColorDataError;
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", message);
        }
        return this.getDuplicateValueError();
    }

    @Override
    public void updateOptions() {
        if (!this.getModel().isAutomaticallyAssigned()) {
            ((ScatterGraphOptions)this.getPatternOptions()).getExtendedProperties().setMarkerColorAttribute(this.getModel().getMarkerColor().getName());
            ((ScatterGraphOptions)this.getPatternOptions()).getExtendedProperties().setMarkerShapeAttribute(this.getModel().getMarkerShape().getName());
        } else {
            ((ScatterGraphOptions)this.getPatternOptions()).getExtendedProperties().setMarkerColorAttribute(null);
            ((ScatterGraphOptions)this.getPatternOptions()).getExtendedProperties().setMarkerShapeAttribute(null);
        }
        super.updateOptions();
    }

    @Override
    protected boolean isNonDataItemsOrderedFirst() {
        return true;
    }

    @Override
    protected void addX1Title(ICommonAxisGraphOptions options) {
        X1Title title = new X1Title();
        title.setText(GraphOptionsResources.quickLayout_x1Title);
        ((ScatterGraphOptions)this.getPatternOptions()).getExtendedProperties().setX1Title(title);
    }

    @Override
    protected ICommonAxisGraphOptions getCommonGraphOptions() {
        return new ScatterGraphOptionsWrapper((ScatterGraphOptions)this.getPatternOptions());
    }

    private class ScatterGraphOptionsWrapper
    implements ICommonAxisGraphOptions {
        private ScatterGraphOptions _graphOptions;

        ScatterGraphOptionsWrapper(ScatterGraphOptions graphOptions) {
            this._graphOptions = graphOptions;
        }

        @Override
        public String getGraphType() {
            return this._graphOptions.getGraphType();
        }

        @Override
        public String getGraphSubType() {
            return this._graphOptions.getGraphSubType();
        }

        @Override
        public void setGraphSubType(String graphSubType) {
            this._graphOptions.setGraphSubType(graphSubType);
        }

        @Override
        public GraphBindingOptions getBindingOptions() {
            return this._graphOptions.getBindingOptions();
        }

        @Override
        public void setRowSelection(boolean rowSelection) {
            this._graphOptions.setRowSelection(rowSelection);
        }

        @Override
        public boolean isRowSelection() {
            return this._graphOptions.isRowSelection();
        }

        @Override
        public void setGraphFootnote(GraphFootnote graphFootnote) {
            this._graphOptions.getExtendedProperties().setGraphFootnote(graphFootnote);
        }

        @Override
        public void setGraphSubtitle(GraphSubtitle graphSubtitle) {
            this._graphOptions.getExtendedProperties().setGraphSubtitle(graphSubtitle);
        }

        @Override
        public void setGraphTitle(GraphTitle graphTitle) {
            this._graphOptions.getExtendedProperties().setGraphTitle(graphTitle);
        }

        @Override
        public void setLegendArea(LegendArea legendArea) {
            this._graphOptions.getExtendedProperties().setLegendArea(legendArea);
        }

        @Override
        public void setLegendTitle(LegendTitle legendTitle) {
            this._graphOptions.getExtendedProperties().setLegendTitle(legendTitle);
        }

        @Override
        public void setO1Title(O1Title o1Title) {
        }

        @Override
        public void setY1Title(Y1Title y1Title) {
            this._graphOptions.getExtendedProperties().setY1Title(y1Title);
        }
    }
}

