/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt;

import java.util.List;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphFootnote;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphSubtitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.GraphTitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.LegendArea;
import oracle.adfdt.view.dvt.binding.pattern.graph.LegendTitle;
import oracle.adfdt.view.dvt.binding.pattern.graph.PieGraphOptions;
import oracle.adfdt.view.dvt.binding.pattern.graph.PieLabel;
import oracle.adfdt.view.dvt.binding.pattern.options.GraphBindingOptions;
import oracle.binding.meta.AttributeDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.GraphOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.GraphOptionsResources;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.ICommonGraphOptions;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.OepeGraphUtils;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.PieGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.ICreatorPresentation;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.IPresentationLayout;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.BindOperationType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GraphType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IPieGraphOptionsModel;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PieGraphOptionsMapper
extends GraphOptionsMapper<PieGraphOptions> {
    private static final String QUICKLAYOUT_PIE1 = "pie1_default";
    private static final String QUICKLAYOUT_PIE2 = "pie2_all_titles";
    private static final String QUICKLAYOUT_PIE3 = "pie3_no_pieLabel";
    private static final String QUICKLAYOUT_PIE4 = "pie4_old_titles";
    private static final String QUICKLAYOUT_PIE5 = "pie5_old_titles_sliceLabel";
    private static final String LABELPOSITION_ATTR_NAME = "labelPosition";
    private static final String LABELPOSITION_INSIDE = "LP_INSIDE";
    private static final String PIEFRAME_TAG_NAME = "graphPieFrame";
    private static final String PIELABEL_TAG_NAME = "pieLabel";
    private static final String SLICE_TAG_NAME = "slice";
    private static final String SLICELABEL_TAG_NAME = "sliceLabel";

    public PieGraphOptionsMapper(BindOperationType opType, Widget<PieGraphOptions> widget, CreatorParams<PieGraphOptions> params) {
        super(opType, widget, params);
    }

    public IPieGraphOptionsModel getModel() {
        return (IPieGraphOptionsModel)super.getModel();
    }

    protected IPieGraphOptionsModel createModel(GraphType type, ICreatorPresentation creatorPresentation, List<AttributeDefinition> attrDefs) {
        return new PieGraphOptionsModel(type, creatorPresentation, attrDefs);
    }

    @Override
    protected GraphType getType() {
        return GraphType.PIE;
    }

    @Override
    protected void initModel(IGraphOptionsModel model) {
        super.initModel(model);
        if (this.getBindingContextType() != BindOperationType.EDIT) {
            model.setDataOnSeries(false);
        }
    }

    @Override
    public IStatus validateModel() {
        if (!this.getModel().isNameValuePair()) {
            if (!this.getModel().isMultiPieRing()) {
                if (!PieGraphOptionsMapper.hasSingleDataItem(this.getModel().getGroupsItemContexts())) {
                    String message = GraphOptionsResources.error_missingSingleNumericDataPoint;
                    String param = GraphOptionsResources.pieGraph_groupsLabel;
                    if (this.getModel().isRingTypeGraph()) {
                        param = GraphOptionsResources.ringGraph_groupsLabel;
                    }
                    message = NLS.bind((String)message, (Object)param);
                    return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", message);
                }
                if (this.getModel().getSeriesItemContexts().size() == 0) {
                    String message = GraphOptionsResources.error_missingAttribute;
                    String param = GraphOptionsResources.pieGraph_seriesLabel;
                    message = NLS.bind((String)message, (Object)param);
                    return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", message);
                }
                if (this.getModel().isPieRingBar() && !PieGraphOptionsMapper.validForPieRingBar(this.getModel().getGroupsItemContexts())) {
                    String message = GraphOptionsResources.error_missingPieRingBarSegments;
                    return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", message);
                }
            } else {
                String dataEdgeLabel = null;
                String nonDataEdgeLabel = null;
                List dataPointEdge = null;
                List nonDataPointEdge = null;
                IPresentationLayout layout = this.getModel().getPresentationLayout();
                if (this.getModel().isDataOnSeries()) {
                    dataEdgeLabel = GraphOptionsResources.pieGraph_seriesLabel;
                    dataPointEdge = this.getModel().getSeriesItemContexts();
                    nonDataEdgeLabel = this.getMultiPieRingGroupsLabel(layout);
                    nonDataPointEdge = this.getModel().getGroupsItemContexts();
                } else {
                    dataEdgeLabel = this.getMultiPieRingGroupsLabel(layout);
                    dataPointEdge = this.getModel().getGroupsItemContexts();
                    nonDataEdgeLabel = GraphOptionsResources.pieGraph_seriesLabel;
                    nonDataPointEdge = this.getModel().getSeriesItemContexts();
                }
                if (!PieGraphOptionsMapper.edgeHasDataItemCount(dataPointEdge, 1)) {
                    String message = GraphOptionsResources.error_missingNumericDataPoint;
                    message = NLS.bind((String)message, (Object)dataEdgeLabel);
                    return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", message);
                }
                if (nonDataPointEdge.size() == 0) {
                    String message = GraphOptionsResources.error_missingAttribute;
                    message = NLS.bind((String)message, (Object)nonDataEdgeLabel);
                    return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", message);
                }
            }
        }
        return null;
    }

    private String getMultiPieRingGroupsLabel(IPresentationLayout layout) {
        String param = GraphOptionsResources.multiPieGraph_groupsLabel;
        if (OepeGraphUtils.isRingTypeGraph(layout)) {
            param = GraphOptionsResources.multiRingGraph_groupsLabel;
        }
        return param;
    }

    private static boolean hasSingleDataItem(List<EdgeItemContext> edge) {
        if (edge != null && edge.size() >= 1) {
            int count = 0;
            for (EdgeItemContext item : edge) {
                if (!item.isNumeric() || item.isTreatAsText()) continue;
                ++count;
            }
            if (count == 1) {
                return true;
            }
        }
        return false;
    }

    private static boolean validForPieRingBar(List<EdgeItemContext> edge) {
        if (edge != null && edge.size() >= 1) {
            for (EdgeItemContext item : edge) {
                if (item.isNumeric() && !item.isTreatAsText()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateOptions() {
        PieGraphOptions options = (PieGraphOptions)this.getPatternOptions();
        IPresentationLayout layout = this.getModel().getPresentationLayout();
        if (this.getBindingContextType() == BindOperationType.CREATE && layout != null) {
            options.setGraphSubType(layout.getVariationType());
            String quickLayout = layout.getQuickLayout();
            if (quickLayout.equals(QUICKLAYOUT_PIE1)) {
                PieGraphOptionsMapper.addPieLabel(options, true);
            } else if (quickLayout.equals(QUICKLAYOUT_PIE2)) {
                PieGraphOptionsMapper.addPieLabel(options, true);
                this.configurePieQuickLayout2(options);
            } else if (quickLayout.equals(QUICKLAYOUT_PIE3)) {
                PieGraphOptionsMapper.addPieLabel(options, false);
                this.configurePieQuickLayout3(options);
            } else if (quickLayout.equals(QUICKLAYOUT_PIE4)) {
                PieGraphOptionsMapper.addPieLabel(options, false);
                this.configurePieQuickLayout4(options);
            } else if (quickLayout.equals(QUICKLAYOUT_PIE5)) {
                PieGraphOptionsMapper.addPieLabel(options, true);
                this.configurePieQuickLayout5(options);
            }
        }
        this.update(this.getCommonGraphOptions());
    }

    private static void addPieLabel(PieGraphOptions options, boolean rendered) {
        PieLabel label = new PieLabel();
        label.setRendered(rendered);
        options.getExtendedProperties().setPieLabel(label);
    }

    private void configurePieQuickLayout2(PieGraphOptions options) {
        LegendTitle legendTitle = new LegendTitle();
        legendTitle.setText(GraphOptionsResources.quickLayout_legendTitle);
        options.getExtendedProperties().setLegendTitle(legendTitle);
        GraphFootnote graphFootnote = new GraphFootnote();
        graphFootnote.setText(GraphOptionsResources.quickLayout_graphFootnote);
        options.getExtendedProperties().setGraphFootnote(graphFootnote);
        GraphSubtitle graphSubtitle = new GraphSubtitle();
        graphSubtitle.setText(GraphOptionsResources.quickLayout_graphSubtitle);
        options.getExtendedProperties().setGraphSubtitle(graphSubtitle);
        GraphTitle graphTitle = new GraphTitle();
        graphTitle.setText(GraphOptionsResources.quickLayout_graphTitle);
        options.getExtendedProperties().setGraphTitle(graphTitle);
    }

    private void configurePieQuickLayout3(PieGraphOptions options) {
        LegendArea legendArea = new LegendArea();
        legendArea.setPosition("LAP_TOP");
        options.getExtendedProperties().setLegendArea(legendArea);
    }

    private void configurePieQuickLayout4(PieGraphOptions options) {
        LegendArea legendArea = new LegendArea();
        legendArea.setPosition("LAP_BOTTOM");
        options.getExtendedProperties().setLegendArea(legendArea);
        GraphSubtitle graphSubtitle = new GraphSubtitle();
        graphSubtitle.setHorizontalAlignment("CENTER");
        graphSubtitle.setText(GraphOptionsResources.quickLayout_graphSubtitle);
        options.getExtendedProperties().setGraphSubtitle(graphSubtitle);
        GraphTitle graphTitle = new GraphTitle();
        graphTitle.setHorizontalAlignment("CENTER");
        graphTitle.setText(GraphOptionsResources.quickLayout_graphTitle);
        options.getExtendedProperties().setGraphTitle(graphTitle);
    }

    private void configurePieQuickLayout5(PieGraphOptions options) {
        LegendArea legendArea = new LegendArea();
        legendArea.setPosition("LAP_BOTTOM");
        options.getExtendedProperties().setLegendArea(legendArea);
        GraphTitle graphTitle = new GraphTitle();
        graphTitle.setHorizontalAlignment("CENTER");
        graphTitle.setText(GraphOptionsResources.quickLayout_graphTitle);
        options.getExtendedProperties().setGraphTitle(graphTitle);
    }

    @Override
    public void postProcess(Node node) {
        Element graphElement = PieGraphOptionsMapper.getSingleBindRoot(node);
        if (graphElement == null || !this.getType().toString().equals(graphElement.getLocalName())) {
            return;
        }
        IPresentationLayout layout = this.getModel().getPresentationLayout();
        if (this.getBindingContextType() == BindOperationType.CREATE && layout != null) {
            Element refChild = PieGraphOptionsMapper.addBackgroundTag(graphElement);
            refChild = PieGraphOptionsMapper.addTag(graphElement, PIEFRAME_TAG_NAME, refChild);
            refChild = PieGraphOptionsMapper.addSeriesSetTag(graphElement, refChild);
            if (OepeGraphUtils.isPieY1AxisSupported(layout.getVariationType())) {
                refChild = PieGraphOptionsMapper.addTag(graphElement, "y1Axis", refChild);
            }
            refChild = this.addSliceLabelTag(graphElement);
            String quickLayout = layout.getQuickLayout();
            if (quickLayout.equals(QUICKLAYOUT_PIE1) || quickLayout.equals(QUICKLAYOUT_PIE3)) {
                this.updateLegendAreaAutomaticPlacementAttr(graphElement);
            } else if (quickLayout.equals(QUICKLAYOUT_PIE4)) {
                graphElement.setAttribute("customLayout", "CL_NONE");
                this.updateLegendAreaAutomaticPlacementAttr(graphElement);
            } else if (quickLayout.equals(QUICKLAYOUT_PIE5)) {
                graphElement.setAttribute("customLayout", "CL_NONE");
                this.updateLegendAreaAutomaticPlacementAttr(graphElement);
                this.addSliceTag(graphElement, refChild);
            }
        }
    }

    private Element addSliceLabelTag(Element graph) {
        Document doc = graph.getOwnerDocument();
        Element sliceLabel = doc.createElementNS("http://xmlns.oracle.com/dss/adf/faces", SLICELABEL_TAG_NAME);
        Element pieLabel = null;
        NodeList children = graph.getElementsByTagNameNS("http://xmlns.oracle.com/dss/adf/faces", PIELABEL_TAG_NAME);
        if (children.getLength() == 1) {
            pieLabel = (Element)children.item(0);
        }
        if (pieLabel == null) {
            graph.appendChild(sliceLabel);
        } else {
            graph.insertBefore(sliceLabel, pieLabel);
        }
        return sliceLabel;
    }

    private void addSliceTag(Element graph, Element refChild) {
        Document doc = graph.getOwnerDocument();
        Element slice = doc.createElementNS("http://xmlns.oracle.com/dss/adf/faces", SLICE_TAG_NAME);
        slice.setAttribute(LABELPOSITION_ATTR_NAME, LABELPOSITION_INSIDE);
        NodeList children = graph.getElementsByTagNameNS("http://xmlns.oracle.com/dss/adf/faces", SLICE_TAG_NAME);
        if (children == null || children.getLength() == 0) {
            if (refChild == null) {
                graph.appendChild(slice);
            } else {
                graph.insertBefore(slice, refChild);
            }
        }
    }

    @Override
    protected ICommonGraphOptions getCommonGraphOptions() {
        return new PieGraphOptionsWrapper((PieGraphOptions)this.getPatternOptions());
    }

    private class PieGraphOptionsWrapper
    implements ICommonGraphOptions {
        private final PieGraphOptions _graphOptions;

        PieGraphOptionsWrapper(PieGraphOptions graphOptions) {
            this._graphOptions = graphOptions;
        }

        @Override
        public String getGraphType() {
            return this._graphOptions.getGraphType();
        }

        @Override
        public String getGraphSubType() {
            return this._graphOptions.getGraphSubType();
        }

        @Override
        public void setGraphSubType(String graphSubType) {
            this._graphOptions.setGraphSubType(graphSubType);
        }

        @Override
        public GraphBindingOptions getBindingOptions() {
            return this._graphOptions.getBindingOptions();
        }

        @Override
        public void setRowSelection(boolean rowSelection) {
            this._graphOptions.setRowSelection(rowSelection);
        }

        @Override
        public boolean isRowSelection() {
            return this._graphOptions.isRowSelection();
        }

        @Override
        public void setGraphFootnote(GraphFootnote graphFootnote) {
            this._graphOptions.getExtendedProperties().setGraphFootnote(graphFootnote);
        }

        @Override
        public void setGraphSubtitle(GraphSubtitle graphSubtitle) {
            this._graphOptions.getExtendedProperties().setGraphSubtitle(graphSubtitle);
        }

        @Override
        public void setGraphTitle(GraphTitle graphTitle) {
            this._graphOptions.getExtendedProperties().setGraphTitle(graphTitle);
        }

        @Override
        public void setLegendArea(LegendArea legendArea) {
            this._graphOptions.getExtendedProperties().setLegendArea(legendArea);
        }

        @Override
        public void setLegendTitle(LegendTitle legendTitle) {
            this._graphOptions.getExtendedProperties().setLegendTitle(legendTitle);
        }
    }
}

