/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt;

import java.util.ArrayList;
import java.util.List;
import oracle.binding.meta.AttributeDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.options.impl.dvt.GraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.ICreatorPresentation;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GraphType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IBubbleGraphOptionsModel;

class BubbleGraphOptionsModel
extends GraphOptionsModel
implements IBubbleGraphOptionsModel {
    private int _xAxisDataPointIndex = -1;
    private int _yAxisDataPointIndex = -1;
    private int _sizeValueIndex = -1;

    public BubbleGraphOptionsModel(GraphType type, ICreatorPresentation creatorPresentation, List<AttributeDefinition> attributes) {
        super(type, creatorPresentation, attributes);
        super.setDataOnSeries(false);
    }

    @Override
    public void setDataOnSeries(boolean dataOnSeries) {
    }

    @Override
    public void setGroupsItemContexts(List<EdgeItemContext> groups) {
        this._xAxisDataPointIndex = -1;
        this._yAxisDataPointIndex = -1;
        this._sizeValueIndex = -1;
        if (groups != null && !groups.isEmpty()) {
            int index = 0;
            for (EdgeItemContext item : groups) {
                if (item.isNumeric() && !item.isTreatAsText()) {
                    this._xAxisDataPointIndex = index;
                    if (this._xAxisDataPointIndex + 1 < groups.size() && (item = groups.get(this._xAxisDataPointIndex + 1)).isNumeric() && !item.isTreatAsText()) {
                        this._yAxisDataPointIndex = this._xAxisDataPointIndex + 1;
                    }
                    if (this._xAxisDataPointIndex + 2 >= groups.size() || !(item = groups.get(this._xAxisDataPointIndex + 2)).isNumeric() || item.isTreatAsText()) break;
                    this._sizeValueIndex = this._xAxisDataPointIndex + 2;
                    break;
                }
                ++index;
            }
        }
        super.setGroupsItemContexts(groups);
    }

    @Override
    public void resetData() {
        this.setSeriesItemContexts(null);
        this.setGroupsItemContexts(null);
    }

    public EdgeItemContext getXAxisDataPoint() {
        List<EdgeItemContext> groups = this.getGroupsItemContexts();
        if (this._xAxisDataPointIndex < 0 || this._xAxisDataPointIndex >= groups.size()) {
            return null;
        }
        return groups.get(this._xAxisDataPointIndex);
    }

    public void setXAxisDataPoint(EdgeItemContext dataPoint) {
        if (dataPoint != null && !dataPoint.isNumeric()) {
            return;
        }
        ArrayList<EdgeItemContext> groups = new ArrayList<EdgeItemContext>(this.getGroupsItemContexts());
        if (this._xAxisDataPointIndex < 0) {
            this._xAxisDataPointIndex = 0;
            groups.add(this._xAxisDataPointIndex, dataPoint);
            if (this._yAxisDataPointIndex >= 0) {
                ++this._yAxisDataPointIndex;
            }
            if (this._sizeValueIndex >= 0) {
                ++this._sizeValueIndex;
            }
        } else {
            groups.set(this._xAxisDataPointIndex, dataPoint);
        }
        super.setGroupsItemContexts(groups);
    }

    public EdgeItemContext getYAxisDataPoint() {
        List<EdgeItemContext> groups = this.getGroupsItemContexts();
        if (this._yAxisDataPointIndex < 0 || this._yAxisDataPointIndex >= groups.size()) {
            return null;
        }
        return groups.get(this._yAxisDataPointIndex);
    }

    public void setYAxisDataPoint(EdgeItemContext dataPoint) {
        ArrayList<EdgeItemContext> groups = new ArrayList<EdgeItemContext>(this.getGroupsItemContexts());
        if (this._yAxisDataPointIndex < 0) {
            int n = this._yAxisDataPointIndex = this._xAxisDataPointIndex < 0 ? 0 : this._xAxisDataPointIndex + 1;
            if (this._sizeValueIndex >= 0) {
                ++this._sizeValueIndex;
            }
            groups.add(this._yAxisDataPointIndex, dataPoint);
        } else {
            groups.set(this._yAxisDataPointIndex, dataPoint);
        }
        super.setGroupsItemContexts(groups);
    }

    public EdgeItemContext getSize() {
        List<EdgeItemContext> groups = this.getGroupsItemContexts();
        if (this._sizeValueIndex < 0 || this._sizeValueIndex >= groups.size()) {
            return null;
        }
        return groups.get(this._sizeValueIndex);
    }

    public void setSize(EdgeItemContext dataValue) {
        ArrayList<EdgeItemContext> groups = new ArrayList<EdgeItemContext>(this.getGroupsItemContexts());
        if (this._sizeValueIndex < 0) {
            this._sizeValueIndex = this._yAxisDataPointIndex >= 0 ? this._yAxisDataPointIndex + 1 : (this._xAxisDataPointIndex >= 0 ? this._xAxisDataPointIndex + 1 : 0);
            groups.add(this._sizeValueIndex, dataValue);
        } else {
            groups.set(this._sizeValueIndex, dataValue);
        }
        super.setGroupsItemContexts(groups);
    }

    public List<EdgeItemContext> getColors() {
        return this.getSeriesItemContexts();
    }

    public void setColors(List<EdgeItemContext> itemContexts) {
        this.setSeriesItemContexts(itemContexts);
    }

    public List<EdgeItemContext> getTooltips() {
        ArrayList<EdgeItemContext> tooltip = new ArrayList<EdgeItemContext>(this.getGroupsItemContexts());
        if (this._sizeValueIndex >= 0) {
            tooltip.remove(this._sizeValueIndex);
        }
        if (this._yAxisDataPointIndex >= 0) {
            tooltip.remove(this._yAxisDataPointIndex);
        }
        if (this._xAxisDataPointIndex >= 0) {
            tooltip.remove(this._xAxisDataPointIndex);
        }
        return tooltip;
    }

    public void setTooltips(List<EdgeItemContext> itemContexts) {
        List<EdgeItemContext> oldGroups = this.getGroupsItemContexts();
        ArrayList<EdgeItemContext> newGroups = new ArrayList<EdgeItemContext>();
        if (this._xAxisDataPointIndex >= 0) {
            newGroups.add(oldGroups.get(this._xAxisDataPointIndex));
            this._xAxisDataPointIndex = 0;
        }
        if (this._yAxisDataPointIndex >= 0) {
            newGroups.add(oldGroups.get(this._yAxisDataPointIndex));
            int n = this._yAxisDataPointIndex = this._xAxisDataPointIndex < 0 ? 0 : this._xAxisDataPointIndex + 1;
        }
        if (this._sizeValueIndex >= 0) {
            newGroups.add(oldGroups.get(this._sizeValueIndex));
            int n = this._yAxisDataPointIndex >= 0 ? this._yAxisDataPointIndex + 1 : (this._sizeValueIndex = this._xAxisDataPointIndex >= 0 ? this._xAxisDataPointIndex + 1 : 0);
        }
        if (itemContexts != null && !itemContexts.isEmpty()) {
            newGroups.addAll(itemContexts);
        }
        super.setGroupsItemContexts(newGroups);
    }
}

