/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.options.impl;

import oracle.adfdt.view.common.binding.creator.v2.BinderParams;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.creator.v2.PatternOptions;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.BindOperationType;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.IOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.ComponentOptionsPageProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultOptionsMapper<O extends PatternOptions>
implements IOptionsMapper {
    private final O _options;
    private final O _createOptions;
    private final CreatorParams<O> _params;
    private final BindOperationType _opType;
    private final String _componentName;

    public DefaultOptionsMapper(BindOperationType opType, Widget<O> widget, CreatorParams<O> params) {
        if (widget == null || params == null || opType == null) {
            throw new IllegalArgumentException("Program error: arguments must be non-null");
        }
        this._opType = opType;
        this._params = params;
        if (this._opType == BindOperationType.CREATE) {
            this._options = widget.createOptions(params);
            this._createOptions = this._options;
        } else {
            this._options = widget.generateBinderOptions((BinderParams)params);
            CreatorParams createParams = widget.createBaseCreatorParams(params.getRootSubTree());
            this._createOptions = widget.createOptions(createParams);
        }
        String name = widget.getCreator().getLocalName();
        if (name == null || name.isEmpty()) {
            name = widget.getName();
        }
        if (name != null) {
            name = name.replace("ADF ", "");
            name = name.replace("&", "");
            name = name.replace("...", "");
        }
        this._componentName = name;
    }

    public boolean hasOptions() {
        return this._options != null;
    }

    public O getPatternOptions() {
        return this._options;
    }

    protected O getCreatePatternOptions() {
        return this._createOptions;
    }

    protected CreatorParams<O> getParams() {
        return this._params;
    }

    public BindOperationType getBindingContextType() {
        return this._opType;
    }

    public Object getModel() {
        return null;
    }

    public ComponentOptionsPageProvider createPageProvider() {
        return null;
    }

    public IStatus validateModel() {
        return Status.OK_STATUS;
    }

    public void updateOptions() {
    }

    public void postProcess(Node node) {
    }

    public String getDefinitionPath() {
        return null;
    }

    public String getComponentName() {
        return this._componentName;
    }

    protected static Element getSingleBindRoot(Node bindRoots) {
        if (bindRoots == null) {
            return null;
        }
        if (bindRoots.getNodeType() == 11) {
            Node firstChild = ((DocumentFragment)bindRoots).getFirstChild();
            if (firstChild.getNodeType() == 1) {
                return (Element)firstChild;
            }
        } else if (bindRoots.getNodeType() == 1) {
            return (Element)bindRoots;
        }
        return null;
    }
}

