/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.ui;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.bind.BindCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.TaskFlowWidget;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.ui.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.ui.ParameterViewer;
import oracle.eclipse.tools.common.util.Pair;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class RegionParameterDialog
extends TitleAreaDialog
implements ParameterViewer.IStatusListener {
    private BindCommand command;
    private TaskFlowWidget widget;
    private ParameterViewer parameterViewer;

    public RegionParameterDialog(Shell shell, BindCommand command, TaskFlowWidget widget) {
        super(shell);
        this.setShellStyle(0x10C70 | RegionParameterDialog.getDefaultOrientation());
        this.command = command;
        this.widget = widget;
    }

    public void dispose() {
        this.command = null;
        this.widget = null;
        if (this.parameterViewer != null) {
            this.parameterViewer.dispose();
            this.parameterViewer = null;
        }
    }

    public String getParameterMapEL() {
        return this.parameterViewer != null ? this.parameterViewer.getParameterMapEL() : null;
    }

    public List<? extends Pair<String, String>> getParameterPairs() {
        return this.parameterViewer != null ? this.parameterViewer.getParameterPairs() : Collections.emptyList();
    }

    protected boolean isResizable() {
        return true;
    }

    @Override
    public void handleStatus(IStatus status) {
        if (status.isOK()) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(status.getMessage());
        }
        this.getButton(0).setEnabled(this.getErrorMessage() == null);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.RegionParameterDialog_title);
        Point size = new Point(522, 400);
        newShell.setSize(size);
        Monitor monitor = newShell.getMonitor();
        Rectangle bounds = monitor.getBounds();
        int x = bounds.x + (bounds.width - size.x) / 2;
        int y = bounds.y + (bounds.height - size.y) / 2;
        newShell.setLocation(x, y);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogContent = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.ParameterWindow_title);
        IWebPageContext.ITaskFlowProxy taskFlow = this.widget.forObject();
        String relativePath = TaskFlowWidget.getWebProjectRelativePath((IResource)taskFlow.getTaskFlowFile());
        this.setMessage(NLS.bind((String)Messages.RegionParameterDialog_message, (Object)relativePath, (Object)taskFlow.getTaskFlowId()));
        this.parameterViewer = new ParameterViewer();
        DTRTUIUtil.applyGrabAllGridData((Control)this.parameterViewer.createControl(dialogContent, this.command.getCommandStack(), this.widget));
        this.parameterViewer.addStatusListener(this);
        return dialogContent;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.parameterViewer.getStatus().isOK());
        return control;
    }
}

