/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.object;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oracle.adf.model.adapter.dataformat.AccessorDef;
import oracle.adfdt.model.objects.CtrlHier;
import oracle.adfdt.model.objects.CtrlHierTypeBinding;
import oracle.adfdt.model.util.JSR227Util;
import oracle.adfdt.view.common.binding.utils.ADFBindingUtils;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructuredTypeObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.EMFObjectTranslator;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlHier;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlHierTypeBinding;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IDataControlStructureObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.meta.DecoratingObject;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.EditorLabelMessages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.TreeDrivenTablePropertyEditor;
import oracle.eclipse.tools.common.util.StringUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.impl.EStoreEObjectImpl;
import org.w3c.dom.Element;

public class TreeBindingUtil {
    public static final TreeBindingUtil INSTANCE = new TreeBindingUtil();

    public TreeBindingClosure getClosure(ICtrlHier iCtrlHier) {
        EList<ICtrlHierTypeBinding> nodes = iCtrlHier.getNodeDefinitions();
        TreeBindingClosure closure = new TreeBindingClosure();
        closure.setParent(iCtrlHier);
        int i = 0;
        while (i < nodes.size()) {
            ICtrlHierTypeBinding iCtrlHierTypeBinding = (ICtrlHierTypeBinding)nodes.get(i);
            if (i == 0) {
                closure.setPrimary(iCtrlHierTypeBinding);
            } else {
                closure.addNode(iCtrlHierTypeBinding);
            }
            ++i;
        }
        NodeInfo curNode = closure.getPrimary();
        if (curNode != null) {
            Object decoratedObject;
            HashSet<String> visited = new HashSet<String>();
            Stack<String> path = new Stack<String>();
            IDataControlObject targetBinding = (IDataControlObject)iCtrlHier.getTargetBinding();
            if (targetBinding instanceof IDataControlStructureObject && (decoratedObject = ((IDataControlStructureObject)targetBinding).getDecoratedObject()) instanceof NamedDefinition) {
                NamedDefinition sDef = (NamedDefinition)decoratedObject;
                curNode.setAccDefn(sDef);
                closure.addReference(curNode, curNode, path, sDef.getName(), false);
                visited.add(this.getTypeName(sDef));
                this.calc(closure, curNode, path, sDef, visited);
            }
        }
        return closure;
    }

    private void calc(TreeBindingClosure closure, NodeInfo curNode, Stack<String> path, NamedDefinition namedDef, Set<String> visitedNames) {
        if (curNode.getBinding() == null || curNode.getBinding().getAccessorNamesArray() == null) {
            return;
        }
        String accName = namedDef.getName();
        path.push(accName);
        String[] stringArray = curNode.getBinding().getAccessorNamesArray();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            StructureDefinition sDef;
            String childAccName = stringArray[n2];
            if (childAccName != null && (sDef = TreeBindingUtil.getStructuredDefinition(namedDef)) != null) {
                Definition child = sDef.getAccessorDefinitions().find(childAccName);
                if (child == null) {
                    InvalidNodeInfo addInvalidNode = closure.addInvalidNode(childAccName, curNode);
                    closure.addReference(curNode, addInvalidNode, path, childAccName, true);
                } else if (child instanceof AccessorDefinition) {
                    String typeName = this.getTypeName((NamedDefinition)((AccessorDefinition)child));
                    NodeInfo node = closure.find(typeName);
                    if (node == null) {
                        node = new MissingNodeInfo(typeName, childAccName, closure.getParent(), closure);
                        closure.addMissingNode(typeName, node);
                    }
                    node.setAccDefn((NamedDefinition)((AccessorDefinition)child));
                    boolean seenBefore = visitedNames.contains(typeName);
                    closure.addReference(curNode, node, path, childAccName, seenBefore);
                    if (!seenBefore) {
                        visitedNames.add(typeName);
                        this.calc(closure, node, path, (NamedDefinition)((AccessorDefinition)child), visitedNames);
                    }
                }
            }
            ++n2;
        }
        path.pop();
    }

    public static StructureDefinition getStructuredDefinition(NamedDefinition def) {
        if (def instanceof StructureDefinition) {
            return (StructureDefinition)def;
        }
        return ADFBindingUtils.getStructureDefinition((Definition)def);
    }

    public String getTypeName(NamedDefinition def) {
        StructureDefinition sDef = TreeBindingUtil.getStructuredDefinition(def);
        if (sDef != null) {
            return sDef.getFullName();
        }
        return null;
    }

    public List<NodeAccessor> calcNodeAccessors(NodeInfo parent, NamedDefinition sDef, NodeFilterConfig nodeFilterConfig, List<String> parentPathFromRoot) {
        DefinitionContainer accessorContainer;
        if (sDef == null) {
            return Collections.emptyList();
        }
        ArrayList<NodeAccessor> allAccessors = new ArrayList<NodeAccessor>();
        StructureDefinition structure = (StructureDefinition)(sDef instanceof AccessorDefinition ? ((AccessorDefinition)sDef).getStructure() : sDef);
        if (structure != null && (accessorContainer = structure.getAccessorDefinitions()) != null) {
            Iterator accessors = accessorContainer.iterator();
            Set<String> selectedAccessors = parent.getSelectedAccessors();
            while (accessors.hasNext()) {
                Object obj = accessors.next();
                if (!(obj instanceof AccessorDefinition)) continue;
                String name = ((AccessorDefinition)obj).getName();
                if (!nodeFilterConfig.isIncludeUnselected() && !selectedAccessors.contains(name)) continue;
                NodeAccessor e = new NodeAccessor(parent, (AccessorDefinition)obj, parentPathFromRoot);
                allAccessors.add(e);
            }
        }
        if (nodeFilterConfig.isIncludeInvalid()) {
            for (InvalidNodeInfo invalidNodeInfo : parent.getInvalidAccessors()) {
                NodeAccessor nAcc = new NodeAccessor(parent, invalidNodeInfo, parentPathFromRoot);
                allAccessors.add(nAcc);
            }
        }
        return allAccessors;
    }

    public static String getMessageForInvalidAccessor(String accessorName) {
        return String.format("_%s_%s", accessorName, EditorLabelMessages.TreeBindingUtil_InvalidNode);
    }

    public ICtrlHierTypeBinding findNodeDefinition(AccessorDefinition accDefinition, ICtrlHier iCtrlHier) {
        String accessorTypeName = this.getTypeName((NamedDefinition)accDefinition);
        if (accessorTypeName != null) {
            return this.findNodeDefinition(accessorTypeName, iCtrlHier);
        }
        return null;
    }

    public ICtrlHierTypeBinding findNodeDefinition(String accessorTypeName, ICtrlHier iCtrlHier) {
        ICtrlHierTypeBinding matchBinding = null;
        if (accessorTypeName != null) {
            for (ICtrlHierTypeBinding nodeDef : iCtrlHier.getNodeDefinitions()) {
                if (!accessorTypeName.equals(nodeDef.getViewDefName())) continue;
                matchBinding = nodeDef;
                break;
            }
        }
        return matchBinding;
    }

    public CtrlHierTypeBinding createRawCtrlHierTypeBinding(CtrlHier parent, String accessorTypeName) {
        CtrlHierTypeBinding newRule = new CtrlHierTypeBinding();
        Element newRuleElem = parent.getDocument().createElementNS(newRule.getNameSpaceUrl(), newRule.getXMLElementTag());
        newRule.initializeFromElement(parent.getTransactionManager(), newRuleElem);
        newRule.setViewDefName(accessorTypeName);
        return newRule;
    }

    public ICtrlHierTypeBinding createICtrlHierTypeBinding(ICtrlHier parent, CtrlHierTypeBinding newRule) {
        ICtrlHierTypeBinding typeBinding = EMFObjectTranslator.INSTANCE.createCtrlHierTypeBinding(parent, newRule);
        ((EStoreEObjectImpl)typeBinding).eSetStore(((EStoreEObjectImpl)parent).eStore());
        return typeBinding;
    }

    public ICtrlHierTypeBinding initializePrimaryRule(ICtrlHier tree) {
        boolean wasMissing = tree.getNodeDefinitions().isEmpty();
        if (wasMissing) {
            CtrlHier rawCtrlHier = (CtrlHier)tree.getDecoratedObject();
            CtrlHierTypeBinding binding = this.createRawCtrlHierTypeBinding(rawCtrlHier, null);
            ICtrlHierTypeBinding ibinding = this.createICtrlHierTypeBinding(tree, binding);
            tree.getNodeDefinitions().add((Object)ibinding);
        }
        ICtrlHierTypeBinding iCtrlHierTypeBinding = (ICtrlHierTypeBinding)tree.getNodeDefinitions().get(0);
        iCtrlHierTypeBinding.setViewDefName(null);
        iCtrlHierTypeBinding.setViewDefName(TreeBindingUtil.calcPrimaryViewDefName(tree));
        iCtrlHierTypeBinding.setTypebindingName(tree.getId() != null ? String.valueOf(tree.getId()) + "0" : "");
        if (wasMissing) {
            return iCtrlHierTypeBinding;
        }
        return null;
    }

    private static String calcPrimaryViewDefName(ICtrlHier tree) {
        Object decoratedObject;
        IStructuredTypeObject dataControl = tree.getTargetBinding();
        if (dataControl instanceof DecoratingObject && (decoratedObject = ((DecoratingObject)dataControl).getDecoratedObject()) instanceof NamedDefinition) {
            StructureDefinition structureDef;
            if (!JSR227Util.isScalarCollection((NamedDefinition)((NamedDefinition)decoratedObject)) && (structureDef = TreeBindingUtil.getStructuredDefinition((NamedDefinition)decoratedObject)) != null) {
                return structureDef.getFullName();
            }
            return ((NamedDefinition)decoratedObject).getFullName();
        }
        return null;
    }

    public static class InvalidAccessorDefinition
    extends AccessorDef {
        public InvalidAccessorDefinition(String id, NamedDefinition parent, boolean isCollection) {
            super(id, TreeBindingUtil.getStructuredDefinition(parent), isCollection);
        }
    }

    public static class InvalidNodeInfo
    extends NodeInfo {
        private final String accessorName;
        private final String type;

        public InvalidNodeInfo(String accessorName, String type, ICtrlHier parent, TreeBindingClosure treeBindingClosure) {
            super(InvalidNodeInfo.createInvalidCtrlHierTypeBinding(type, parent), treeBindingClosure);
            this.accessorName = accessorName;
            this.type = type;
        }

        @Override
        public boolean isInvalid() {
            return true;
        }

        public String getAccessorName() {
            return this.accessorName;
        }

        private static ICtrlHierTypeBinding createInvalidCtrlHierTypeBinding(String fullName, ICtrlHier parent) {
            CtrlHier decoratedObject = (CtrlHier)parent.getDecoratedObject();
            if (decoratedObject != null) {
                CtrlHierTypeBinding ctrlHierTypeBinding = INSTANCE.createRawCtrlHierTypeBinding((CtrlHier)parent.getDecoratedObject(), fullName);
                ICtrlHierTypeBinding missingBinding = INSTANCE.createICtrlHierTypeBinding(parent, ctrlHierTypeBinding);
                missingBinding.setDecoratedObject(ctrlHierTypeBinding);
                ((EStoreEObjectImpl)missingBinding).eSetStore(((EStoreEObjectImpl)parent).eStore());
                missingBinding.setViewDefName(fullName);
                return missingBinding;
            }
            return null;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof InvalidNodeInfo)) {
                return false;
            }
            if (this.getAccessorName() != null) {
                return this.getAccessorName().equals(((InvalidNodeInfo)other).getAccessorName()) && this.typesEqual(this, (InvalidNodeInfo)other);
            }
            return ((InvalidNodeInfo)other).getAccessorName() == null && this.typesEqual(this, (InvalidNodeInfo)other);
        }

        private boolean typesEqual(InvalidNodeInfo invalidNodeInfo, InvalidNodeInfo other) {
            return invalidNodeInfo.getType() == null ? other.getType() == null : invalidNodeInfo.getType().equals(other.getType());
        }

        @Override
        public int hashCode() {
            int hash = 0;
            hash ^= this.getAccessorName() != null ? this.getAccessorName().hashCode() : 0;
            return hash ^= this.getType() != null ? this.getType().hashCode() : 0;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class MissingNodeInfo
    extends NodeInfo {
        private final String accName;

        public MissingNodeInfo(String fullName, String accName, ICtrlHier parent, TreeBindingClosure owner) {
            super(MissingNodeInfo.createMissingCtrlHierTypeBinding(fullName, parent), owner);
            this.accName = accName;
        }

        private static ICtrlHierTypeBinding createMissingCtrlHierTypeBinding(String fullName, ICtrlHier parent) {
            CtrlHier decoratedObject = (CtrlHier)parent.getDecoratedObject();
            if (decoratedObject != null) {
                CtrlHierTypeBinding ctrlHierTypeBinding = INSTANCE.createRawCtrlHierTypeBinding((CtrlHier)parent.getDecoratedObject(), fullName);
                ICtrlHierTypeBinding missingBinding = INSTANCE.createICtrlHierTypeBinding(parent, ctrlHierTypeBinding);
                missingBinding.setDecoratedObject(ctrlHierTypeBinding);
                ((EStoreEObjectImpl)missingBinding).eSetStore(((EStoreEObjectImpl)parent).eStore());
                missingBinding.setViewDefName(fullName);
                return missingBinding;
            }
            return null;
        }

        @Override
        public boolean isMissing() {
            return true;
        }

        public String getAccName() {
            return this.accName;
        }
    }

    public static class NodeAccessor
    implements TreeDrivenTablePropertyEditor.ITreeReference {
        private final NodeInfo parent;
        private final AccessorDefinition accDefinition;
        private List<String> pathFromRoot;
        private InvalidNodeInfo invalidNodeInfo;

        public NodeAccessor(NodeInfo parent, InvalidNodeInfo invalidNode, List<String> parentPathFromRoot) {
            this(parent, (AccessorDefinition)new InvalidAccessorDefinition(invalidNode.getAccessorName(), (NamedDefinition)parent.getStructure(), false), parentPathFromRoot);
            this.invalidNodeInfo = invalidNode;
        }

        public NodeAccessor(NodeInfo parent, AccessorDefinition accDefinition, List<String> parentPathFromRoot) {
            this.parent = parent;
            this.accDefinition = accDefinition;
            this.pathFromRoot = new ArrayList<String>(parentPathFromRoot);
            this.pathFromRoot.add(accDefinition.getName());
        }

        public NodeInfo getParent() {
            return this.parent;
        }

        public AccessorDefinition getAccDefinition() {
            return this.accDefinition;
        }

        public boolean isPrimaryReference() {
            NodePath primaryPath;
            NodeInfo find = this.getNode();
            if (find != null && (primaryPath = find.getPrimaryPath()) != null) {
                List<String> pathFromRoot2 = primaryPath.getFullPathFromRoot();
                return this.pathFromRoot.equals(pathFromRoot2);
            }
            return false;
        }

        public boolean isNodeMissing() {
            NodeInfo find = this.getNode();
            if (find != null) {
                return find.isMissing();
            }
            return false;
        }

        public boolean isNodeInvalid() {
            return this.invalidNodeInfo != null;
        }

        public NodeInfo getNode() {
            if (this.invalidNodeInfo != null) {
                return this.invalidNodeInfo;
            }
            StructureDefinition structure = this.accDefinition.getStructure();
            if (structure != null) {
                return this.parent.find(structure.getFullName());
            }
            return null;
        }

        public boolean isReferenced() {
            ICtrlHierTypeBinding binding = this.parent.getBinding();
            String[] stringArray = binding.getAccessorNamesArray();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String accName = stringArray[n2];
                if (accName != null && accName.equals(this.accDefinition.getName())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public String toString() {
            return this.getPaths();
        }

        private String getPaths() {
            List<NodePath> referencedFrom = this.parent.getReferencedFrom();
            ArrayList<String> listOfPaths = new ArrayList<String>();
            for (NodePath nodePath : referencedFrom) {
                List<String> pathFromRoot = nodePath.getPathFromRoot();
                if (pathFromRoot == null) continue;
                String path = StringUtil.join(pathFromRoot, (char)'.');
                if (path != null && !path.isEmpty()) {
                    path = String.valueOf(path) + ".";
                }
                path = String.valueOf(path) + this.accDefinition.getName();
                listOfPaths.add(path);
            }
            return StringUtil.join(listOfPaths, (char)',');
        }

        public List<String> getPathFromRoot() {
            return Collections.unmodifiableList(this.pathFromRoot);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof NodeAccessor)) {
                return false;
            }
            NodeAccessor otherNodeAccessor = (NodeAccessor)other;
            return otherNodeAccessor.parent.getViewDefName().equals(this.parent.getViewDefName()) && otherNodeAccessor.pathFromRoot.equals(this.pathFromRoot) && otherNodeAccessor.accDefinition.getFullName().equals(this.accDefinition.getFullName());
        }

        public int hashCode() {
            int code = this.parent.getViewDefName() != null ? this.parent.getViewDefName().hashCode() : 0;
            code ^= this.pathFromRoot != null ? this.pathFromRoot.hashCode() : 0;
            return code ^= this.accDefinition.getFullName() != null ? this.accDefinition.getFullName().hashCode() : 0;
        }
    }

    public static class NodeFilterConfig {
        private boolean includeUnselected;
        private boolean includeInvalid;

        public NodeFilterConfig includeUnselected(boolean include) {
            this.includeUnselected = include;
            return this;
        }

        public NodeFilterConfig includeInvalid(boolean include) {
            this.includeInvalid = include;
            return this;
        }

        public boolean isIncludeUnselected() {
            return this.includeUnselected;
        }

        public boolean isIncludeInvalid() {
            return this.includeInvalid;
        }
    }

    public static class NodeInfo {
        private final ICtrlHierTypeBinding binding;
        private List<NodePath> referencingBindings;
        private List<NodePath> referencedFrom;
        private NamedDefinition accDefn;
        private NodePath primaryPath;
        private TreeBindingClosure owner;

        protected NodeInfo() {
            this.binding = null;
        }

        public TreeBindingClosure getOwner() {
            return this.owner;
        }

        public List<InvalidNodeInfo> getInvalidAccessors() {
            ArrayList<InvalidNodeInfo> nodeInfos = new ArrayList<InvalidNodeInfo>(this.referencingBindings.size());
            for (NodePath nodePath : this.getReferencingBindings()) {
                NodeInfo node = nodePath.getNode();
                if (!node.isInvalid()) continue;
                nodeInfos.add((InvalidNodeInfo)node);
            }
            return nodeInfos;
        }

        public NodePath getPrimaryPath() {
            return this.primaryPath;
        }

        public NodeInfo(ICtrlHierTypeBinding binding, TreeBindingClosure treeBindingClosure) {
            if (binding == null) {
                throw new IllegalArgumentException("binding cannot be null");
            }
            this.binding = binding;
            this.owner = treeBindingClosure;
        }

        public void addReference(List<String> pathFromRoot, String childAccName, NodeInfo ref, boolean seenBefore) {
            this.internalGetReferencingBindings().add(new NodePath(this.clonePath(pathFromRoot), childAccName, ref));
            NodePath referencedFrom = new NodePath(this.clonePath(pathFromRoot), childAccName, this);
            ref.internalGetReferencedFrom().add(referencedFrom);
            if (!seenBefore) {
                ref.primaryPath = referencedFrom;
            }
        }

        protected List<String> clonePath(List<String> pathFromRoot) {
            ArrayList<String> dest = new ArrayList<String>(pathFromRoot);
            return dest;
        }

        public ICtrlHierTypeBinding getBinding() {
            return this.binding;
        }

        protected List<NodePath> internalGetReferencingBindings() {
            if (this.referencingBindings == null) {
                this.referencingBindings = new ArrayList<NodePath>(2);
            }
            return this.referencingBindings;
        }

        protected List<NodePath> internalGetReferencedFrom() {
            if (this.referencedFrom == null) {
                this.referencedFrom = new ArrayList<NodePath>(2);
            }
            return this.referencedFrom;
        }

        public List<NodePath> getReferencingBindings() {
            return Collections.unmodifiableList(this.internalGetReferencingBindings());
        }

        public List<NodePath> getReferencedFrom() {
            return Collections.unmodifiableList(this.internalGetReferencedFrom());
        }

        public boolean isMissing() {
            return false;
        }

        public boolean isInvalid() {
            return false;
        }

        public StructureDefinition getStructure() {
            NamedDefinition namedDefn = this.getAccDefn();
            if (namedDefn instanceof AccessorDefinition) {
                return ((AccessorDefinition)namedDefn).getStructure();
            }
            if (namedDefn instanceof StructureDefinition) {
                return (StructureDefinition)namedDefn;
            }
            return null;
        }

        public NamedDefinition getAccDefn() {
            return this.accDefn;
        }

        public void setAccDefn(NamedDefinition accDefn) {
            this.accDefn = accDefn;
        }

        public List<NodeAccessor> getNodeAccessors(boolean includeUnselected, boolean includeInvalid) {
            NamedDefinition sDef = this.getAccDefn();
            return INSTANCE.calcNodeAccessors(this, sDef, new NodeFilterConfig().includeInvalid(includeInvalid).includeUnselected(includeUnselected), new ArrayList<String>());
        }

        public Set<String> getSelectedAccessors() {
            HashSet<String> selectedAccessors = new HashSet<String>();
            for (NodePath nodePath : this.getReferencingBindings()) {
                selectedAccessors.add(nodePath.childAccName);
            }
            return selectedAccessors;
        }

        public NodeInfo find(String typeName) {
            return this.owner.find(typeName);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof NodeInfo)) {
                return false;
            }
            return this.getViewDefName() != null ? this.getViewDefName().equals(((NodeInfo)other).getViewDefName()) : ((NodeInfo)other).getViewDefName() == null;
        }

        public String getViewDefName() {
            return this.binding != null ? (this.binding.getViewDefName() != null ? this.binding.getViewDefName() : "") : "";
        }

        public int hashCode() {
            return this.getViewDefName().hashCode();
        }
    }

    public static class NodePath {
        private final NodeInfo node;
        private final List<String> pathFromRoot;
        private final String childAccName;

        public NodePath(List<String> pathFromRoot, String childAccName, NodeInfo node) {
            this.node = node;
            this.pathFromRoot = pathFromRoot;
            this.childAccName = childAccName;
        }

        public NodeInfo getNode() {
            return this.node;
        }

        public List<String> getPathFromRoot() {
            return Collections.unmodifiableList(this.pathFromRoot);
        }

        public List<String> getFullPathFromRoot() {
            ArrayList<String> fullPath = new ArrayList<String>(this.pathFromRoot);
            fullPath.add(this.childAccName);
            return Collections.unmodifiableList(fullPath);
        }

        public String toString() {
            return this.getFullPath();
        }

        private String getFullPath() {
            return StringUtil.join(this.getFullPathFromRoot(), (char)'.');
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.childAccName == null ? 0 : this.childAccName.hashCode());
            result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
            result = 31 * result + (this.pathFromRoot == null ? 0 : this.pathFromRoot.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof NodePath)) {
                return false;
            }
            NodePath other = (NodePath)obj;
            return DTRTUtil.equals((Object)this.node, (Object)other.node) && DTRTUtil.equals(this.pathFromRoot, other.pathFromRoot) && DTRTUtil.equals((Object)this.childAccName, (Object)other.childAccName);
        }
    }

    public static class PrimaryNodeInfo
    extends NodeInfo {
        public PrimaryNodeInfo(ICtrlHierTypeBinding node, TreeBindingClosure treeBindingClosure) {
            super(node, treeBindingClosure);
        }

        @Override
        public String getViewDefName() {
            TreeBindingClosure closure = this.getOwner();
            ICtrlHier parent = closure.getParent();
            String calcPrimaryViewDefName = TreeBindingUtil.calcPrimaryViewDefName(parent);
            return calcPrimaryViewDefName != null ? calcPrimaryViewDefName : "";
        }

        @Override
        public Set<String> getSelectedAccessors() {
            HashSet<String> selectedAccessors = new HashSet<String>();
            for (NodePath nodePath : this.getReferencingBindings()) {
                if (nodePath.getPathFromRoot().isEmpty()) continue;
                selectedAccessors.add(nodePath.childAccName);
            }
            return selectedAccessors;
        }
    }

    public static class TreeBindingClosure {
        private final Map<String, NodeInfo> nodes = new HashMap<String, NodeInfo>();
        private NodeInfo primary;
        private ICtrlHier parent;

        public void setParent(ICtrlHier parent) {
            this.parent = parent;
        }

        public InvalidNodeInfo addInvalidNode(String accessorName, NodeInfo curNode) {
            String type = TreeBindingUtil.getMessageForInvalidAccessor(accessorName);
            InvalidNodeInfo invalidNodeInfo = new InvalidNodeInfo(accessorName, type, this.parent, this);
            this.nodes.put(type, invalidNodeInfo);
            return invalidNodeInfo;
        }

        public ICtrlHier getParent() {
            return this.parent;
        }

        public void setPrimary(ICtrlHierTypeBinding primary) {
            this.primary = this.addPrimaryNode(primary);
        }

        private NodeInfo addPrimaryNode(ICtrlHierTypeBinding node) {
            PrimaryNodeInfo nodeInfo = new PrimaryNodeInfo(node, this);
            this.nodes.put(((NodeInfo)nodeInfo).getViewDefName(), nodeInfo);
            return nodeInfo;
        }

        public NodeInfo getPrimary() {
            return this.primary;
        }

        public void addMissingNode(String viewDefNode, NodeInfo node) {
            this.nodes.put(viewDefNode, node);
        }

        public NodeInfo addNode(ICtrlHierTypeBinding node) {
            NodeInfo nodeInfo = new NodeInfo(node, this);
            String viewDefName = nodeInfo.getViewDefName();
            if (viewDefName.isEmpty()) {
                viewDefName = TreeBindingClosure.getUniqueNodeKeyForMissing(this.nodes);
            }
            this.nodes.put(viewDefName, nodeInfo);
            return nodeInfo;
        }

        private static String getUniqueNodeKeyForMissing(Map<String, NodeInfo> nodes) {
            int limiter = 0;
            while (limiter++ < Short.MAX_VALUE) {
                String newKey = String.format("**UnknownType_%d", limiter);
                if (nodes.keySet().contains(newKey)) continue;
                return newKey;
            }
            throw new IllegalStateException();
        }

        public NodeInfo getNode(ICtrlHierTypeBinding binding) {
            return this.nodes.get(binding.getViewDefName());
        }

        protected NodeInfo getOrCreateNode(ICtrlHierTypeBinding binding) {
            NodeInfo node = this.getNode(binding);
            if (node == null) {
                node = this.addNode(binding);
            }
            return node;
        }

        public void addReference(NodeInfo fromNode, NodeInfo toNode, List<String> pathFromRoot, String childAccName, boolean seenBefore) {
            fromNode.addReference(pathFromRoot, childAccName, toNode, seenBefore);
        }

        public NodeInfo find(String viewDefName) {
            return this.nodes.get(viewDefName);
        }

        public int getNumNodes() {
            return this.nodes.size();
        }

        public Collection<NodeInfo> getNodes() {
            return Collections.unmodifiableCollection(this.nodes.values());
        }
    }
}

