/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef;

import java.util.ArrayList;
import java.util.List;
import oracle.adfdt.model.objects.BaseElementObject;
import oracle.adfdt.model.objects.DomIterableFactory;
import oracle.adfdt.transaction.Task;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.BaseViewObjectChild;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class ViewObjectUtil {
    public static final String NAMESPACE_URI = "http://xmlns.oracle.com/bc4j";

    private ViewObjectUtil() {
    }

    public static List<? extends Element> basicGetElements(Element parent, String namespaceURI, String elementTag) {
        ArrayList<Element> listOfElements = new ArrayList<Element>();
        if (parent != null) {
            for (Element element : DomIterableFactory.elementIterable((Node)parent)) {
                if (namespaceURI != null && !namespaceURI.equals(element.getNamespaceURI()) || elementTag != null && !elementTag.equals(element.getTagName())) continue;
                listOfElements.add(element);
            }
        }
        return listOfElements;
    }

    public static Element basicGetElement(Element parent, String namespaceURI, String elementTag, String nameAttributeValue) {
        if (parent != null && nameAttributeValue != null) {
            for (Element element : DomIterableFactory.elementIterable((Node)parent)) {
                if (namespaceURI != null && !namespaceURI.equals(element.getNamespaceURI()) || elementTag != null && !elementTag.equals(element.getTagName()) || !nameAttributeValue.equals(element.getAttribute(XMLAttribute.NAME.getName()))) continue;
                return element;
            }
        }
        return null;
    }

    public static <C extends BaseViewObjectChild> C createViewObjectChild(final C child, final String nameAttribute) {
        if (child != null && nameAttribute != null) {
            if (child.getParent() == null || child.getParent().getTransactionManager() == null || child.getParent().getElement() == null) {
                throw new IllegalArgumentException("The child doesn't have a valid parent");
            }
            if (child.getElement() != null) {
                throw new IllegalArgumentException("The child is already initialized");
            }
            final ArrayList ret = new ArrayList(1);
            Task task = new Task(){

                public void run() {
                    BaseElementObject parent = child.getParent();
                    Element element = ViewObjectUtil.basicGetElement(parent.getElement(), child.getNameSpaceUrl(), child.getXMLElementTag(), nameAttribute);
                    if (element == null) {
                        element = parent.getDocument().createElementNS(child.getNameSpaceUrl(), child.getXMLElementTag());
                        parent.getElement().appendChild(element);
                        element.setAttribute(XMLAttribute.NAME.getName(), nameAttribute);
                        child.initializeFromElement(parent.getTransactionManager(), element);
                        ret.add(child);
                    }
                }
            };
            child.getParent().getTransactionManager().runTaskUnderTransaction("create" + child.getClass().getSimpleName(), task);
            return (C)(ret.isEmpty() ? null : (BaseViewObjectChild)ret.get(0));
        }
        return null;
    }

    public static boolean hasChildElement(Node node) {
        NodeList nodeList;
        if (node != null && (nodeList = node.getChildNodes()) != null && nodeList.getLength() > 0) {
            int i = 0;
            while (i < nodeList.getLength()) {
                if (nodeList.item(i) instanceof Element) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    static enum XMLAttribute {
        NAME("Name"),
        LIST_VO_NAME("ListVOName"),
        LOV_NAME("LOVName"),
        RES_ID("ResId"),
        SQL_TYPE("SQLType"),
        TYPE("Type"),
        UPDATEABLE("IsUpdateable"),
        VALUE("Value"),
        VIEW_INSTANCE_NAME("ViewInstanceName"),
        ROW_LEVEL_BINDS("RowLevelBinds");

        private String name;

        private XMLAttribute(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getValue(BaseElementObject baseElementObject) {
            return baseElementObject != null ? baseElementObject.getAttribute(this.getName()) : null;
        }

        public boolean setValue(BaseElementObject baseElementObject, String value) {
            if (baseElementObject != null) {
                baseElementObject.setAttribute(this.getName(), value);
                return true;
            }
            return false;
        }
    }
}

