/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl;

import java.beans.PropertyVetoException;
import oracle.adfdt.model.objects.Application;
import oracle.adfdt.model.objects.BaseElementObject;
import oracle.adfdt.model.objects.BeanStructure;
import oracle.adfdt.model.objects.Configuration;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdt.model.objects.CtrlAttrs;
import oracle.adfdt.model.objects.DTFactory;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.WebApplication;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ADFmRegistry;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ElementData;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ElementManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.ManagedElementFile;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.IPDefViewObjectChild;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.PDefViewObject;
import oracle.eclipse.tools.adf.dtrt.vcommon.manager.IManagedFile;
import oracle.eclipse.tools.adf.dtrt.vcommon.manager.ManagedBinaryFile;
import oracle.eclipse.tools.adf.dtrt.vcommon.manager.PropertiesElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.manager.UnexpectedRootElement;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class ElementType<E> {
    public static final int REGISTRY_ORDINAL = 0;
    public static final ElementType<ADFmRegistry> REGISTRY = new ElementType<ADFmRegistry>(0, ADFmRegistry.class, "xml");
    public static final int CONFIGURATION_ORDINAL = 1;
    public static final ElementType<Configuration> CONFIGURATION = new ElementType<Configuration>(1, Configuration.class, "dcx");
    public static final int APPLICATION_ORDINAL = 2;
    public static final ElementType<Application> APPLICATION = new ElementType<Application>(2, Application.class, "cpx");
    public static final int BEAN_STRUCTURE_ORDINAL = 3;
    public static final ElementType<BeanStructure> BEAN_STRUCTURE = new ElementType<BeanStructure>(3, BeanStructure.class, "xml");
    public static final int PAGE_DEFINITION_ORDINAL = 4;
    public static final ElementType<PageDefinition> PAGE_DEFINITION = new ElementType<PageDefinition>(4, PageDefinition.class, "xml");
    public static final int WEB_APPLICATION_ORDINAL = 5;
    public static final ElementType<WebApplication> WEB_APPLICATION = new ElementType<WebApplication>(5, WebApplication.class, "xml");
    public static final int PDEF_VIEW_OBJECT_ORDINAL = 6;
    public static final ElementType<PDefViewObject> PDEF_VIEW_OBJECT = new ElementType<PDefViewObject>(6, PDefViewObject.class, "xml");
    public static final int PROPERTIES_ELEMENT_ORDINAL = 7;
    public static final ElementType<PropertiesElement> PROPERTIES_ELEMENT = new ElementType<PropertiesElement>(7, PropertiesElement.class, "properties");
    private final int ordinal;
    private final Class<E> type;
    private final String fileExtension;

    public static <T> ElementType<T> getElementType(T element) {
        ElementType<Configuration> elementType = element == null ? null : (CONFIGURATION.getType().isInstance(element) ? CONFIGURATION : (PAGE_DEFINITION.getType().isInstance(element) ? PAGE_DEFINITION : (APPLICATION.getType().isInstance(element) ? APPLICATION : (REGISTRY.getType().isInstance(element) ? REGISTRY : (BEAN_STRUCTURE.getType().isInstance(element) ? BEAN_STRUCTURE : (WEB_APPLICATION.getType().isInstance(element) ? WEB_APPLICATION : (PDEF_VIEW_OBJECT.getType().isInstance(element) ? PDEF_VIEW_OBJECT : (PROPERTIES_ELEMENT.getType().isInstance(element) ? PROPERTIES_ELEMENT : null))))))));
        return elementType;
    }

    private ElementType(int ordinal, Class<E> type, String fileExtension) {
        this.ordinal = ordinal;
        this.type = type;
        this.fileExtension = fileExtension;
    }

    public Class<E> getType() {
        return this.type;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ElementType [type=").append(this.type).append("]");
        return builder.toString();
    }

    E createElement(IFile file) {
        switch (this.ordinal) {
            case 0: {
                return (E)((Object)new ADFmRegistry(file));
            }
            case 1: {
                return (E)new Configuration();
            }
            case 2: {
                return (E)new Application();
            }
            case 3: {
                return (E)new BeanStructure();
            }
            case 4: {
                return (E)new PageDefinition();
            }
            case 5: {
                return (E)((Object)new WebApplication(file));
            }
            case 6: {
                return (E)((Object)new PDefViewObject(file));
            }
            case 7: {
                return (E)new PropertiesElement(file);
            }
        }
        throw new IllegalStateException("Unsupported element type: " + this);
    }

    IManagedFile<E, ?> createManagedFile(IFile file) {
        switch (this.ordinal) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new ManagedElementFile(file);
            }
            case 7: {
                return new ManagedBinaryFile(file);
            }
        }
        throw new IllegalStateException("Unsupported element type: " + this);
    }

    static Object getContent(Object element) {
        if (element instanceof BaseElementObject) {
            return ((BaseElementObject)element).getDocument();
        }
        if (element instanceof PropertiesElement) {
            return ((PropertiesElement)element).getContent();
        }
        if (element != null) {
            throw new IllegalArgumentException("Unsupported element : " + element);
        }
        return null;
    }

    static boolean isEmptyContent(Object content) {
        if (content == null) {
            return true;
        }
        if (content instanceof Document) {
            return ((Document)content).getDocumentElement() == null;
        }
        if (content instanceof ManagedBinaryFile.BinaryContent) {
            return ((ManagedBinaryFile.BinaryContent)content).getBytes().length == 0;
        }
        throw new IllegalArgumentException("Unsupported content : " + content);
    }

    static void clearContent(Object element) {
        if (element instanceof BaseElementObject) {
            ((BaseElementObject)element).clearElement();
        }
        if (element instanceof PropertiesElement) {
            ((PropertiesElement)element).setContent(null);
        }
    }

    static <E> void setElementData(E element, IManagedFile<E, ?> managedFile) {
        ElementData elementData = ElementType.getElementData(element);
        if (elementData != null) {
            ElementData aux = new ElementData(ElementType.getElementType(element), managedFile.getFile());
            if (!elementData.equals(aux)) {
                throw new IllegalStateException("Conficting element data: \n" + elementData + '\n' + aux);
            }
        } else {
            elementData = new ElementData(ElementType.getElementType(element), managedFile.getFile());
            switch (elementData.getType().ordinal()) {
                case 0: {
                    ((ADFmRegistry)((Object)element)).setNodeObjectAsObject(elementData);
                    break;
                }
                case 1: {
                    ((Configuration)element).setNodeObjectAsObject((Object)elementData);
                    break;
                }
                case 2: {
                    ((Application)element).setNodeObjectAsObject((Object)elementData);
                    break;
                }
                case 3: {
                    ((BeanStructure)element).setNodeObjectAsObject((Object)elementData);
                    break;
                }
                case 4: {
                    ((PageDefinition)element).setNodeObjectAsObject((Object)elementData);
                    break;
                }
                case 5: {
                    ((WebApplication)((Object)element)).setNodeObjectAsObject(elementData);
                    break;
                }
                case 6: {
                    ((PDefViewObject)((Object)element)).setNodeObjectAsObject(elementData);
                    break;
                }
                case 7: {
                    ((PropertiesElement)element).setData((Object)elementData);
                }
            }
        }
        elementData.setManagedFile(managedFile);
        if (element instanceof BaseElementObject) {
            Document document = ((BaseElementObject)element).getDocument();
            document.setDocumentURI(elementData.getURI().toString());
        }
    }

    static void clearElementData(Object element) {
        ElementType<Object> elementType = ElementType.getElementType(element);
        if (elementType != null) {
            switch (elementType.ordinal()) {
                case 0: {
                    ADFmRegistry elem = (ADFmRegistry)((Object)element);
                    if (!(elem.getNodeObjectAsObject() instanceof ElementData)) break;
                    ((ElementData)elem.getNodeObjectAsObject()).setManagedFile(null);
                    elem.setNodeObjectAsObject(null);
                    break;
                }
                case 1: {
                    Configuration elem = (Configuration)element;
                    if (!(elem.getNodeObjectAsObject() instanceof ElementData)) break;
                    ((ElementData)elem.getNodeObjectAsObject()).setManagedFile(null);
                    elem.setNodeObjectAsObject(null);
                    break;
                }
                case 2: {
                    Application elem = (Application)element;
                    if (!(elem.getNodeObjectAsObject() instanceof ElementData)) break;
                    ((ElementData)elem.getNodeObjectAsObject()).setManagedFile(null);
                    elem.setNodeObjectAsObject(null);
                    break;
                }
                case 3: {
                    BeanStructure elem = (BeanStructure)element;
                    if (!(elem.getNodeObjectAsObject() instanceof ElementData)) break;
                    ((ElementData)elem.getNodeObjectAsObject()).setManagedFile(null);
                    elem.setNodeObjectAsObject(null);
                    break;
                }
                case 4: {
                    PageDefinition elem = (PageDefinition)element;
                    if (!(elem.getNodeObjectAsObject() instanceof ElementData)) break;
                    ((ElementData)elem.getNodeObjectAsObject()).setManagedFile(null);
                    elem.setNodeObjectAsObject(null);
                    break;
                }
                case 5: {
                    WebApplication elem = (WebApplication)((Object)element);
                    if (!(elem.getNodeObjectAsObject() instanceof ElementData)) break;
                    ((ElementData)elem.getNodeObjectAsObject()).setManagedFile(null);
                    elem.setNodeObjectAsObject(null);
                    break;
                }
                case 6: {
                    PDefViewObject elem = (PDefViewObject)((Object)element);
                    if (!(elem.getNodeObjectAsObject() instanceof ElementData)) break;
                    ((ElementData)elem.getNodeObjectAsObject()).setManagedFile(null);
                    elem.setNodeObjectAsObject(null);
                    break;
                }
                case 7: {
                    PropertiesElement elem = (PropertiesElement)element;
                    if (!(elem.getData() instanceof ElementData)) break;
                    ((ElementData)elem.getData()).setManagedFile(null);
                    elem.setData(null);
                }
            }
        }
    }

    static Object toElement(Object object) {
        if (object instanceof DataControl) {
            return ((DataControl)object).getConfigurationParent();
        }
        if (object instanceof ControlBinding) {
            return ((ControlBinding)object).getBindingContainer();
        }
        if (object instanceof IPDefViewObjectChild) {
            return ((IPDefViewObjectChild)object).getViewObject();
        }
        if (ElementType.getElementType(object) != null) {
            return object;
        }
        return null;
    }

    public static ElementData getElementData(Object element) {
        if (element != null) {
            ElementType<Object> elementType = ElementType.getElementType(element);
            if (elementType == null) {
                element = ElementType.toElement(element);
                elementType = ElementType.getElementType(element);
            }
            if (elementType != null) {
                switch (elementType.ordinal()) {
                    case 0: {
                        return (ElementData)((ADFmRegistry)((Object)element)).getNodeObjectAsObject();
                    }
                    case 1: {
                        return (ElementData)((Configuration)element).getNodeObjectAsObject();
                    }
                    case 2: {
                        return (ElementData)((Application)element).getNodeObjectAsObject();
                    }
                    case 3: {
                        return (ElementData)((BeanStructure)element).getNodeObjectAsObject();
                    }
                    case 4: {
                        return (ElementData)((PageDefinition)element).getNodeObjectAsObject();
                    }
                    case 5: {
                        return (ElementData)((WebApplication)((Object)element)).getNodeObjectAsObject();
                    }
                    case 6: {
                        return (ElementData)((PDefViewObject)((Object)element)).getNodeObjectAsObject();
                    }
                    case 7: {
                        return (ElementData)((PropertiesElement)element).getData();
                    }
                }
            }
        }
        return null;
    }

    static void setFullName(Object element, String fullName) {
        block11: {
            block14: {
                ElementData elementData;
                block13: {
                    block12: {
                        elementData = ElementType.getElementData(element);
                        if (elementData == null) {
                            throw new IllegalArgumentException("Unsupported element : " + element);
                        }
                        if (elementData.getType() == REGISTRY || elementData.getType() == WEB_APPLICATION) break block11;
                        if (elementData.getType() != PDEF_VIEW_OBJECT) break block12;
                        ((PDefViewObject)((Object)element)).setFullName(fullName);
                        break block11;
                    }
                    if (elementData.getType() != PROPERTIES_ELEMENT) break block13;
                    ((PropertiesElement)element).setFullName(fullName);
                    break block11;
                }
                if (!(element instanceof BaseElementObject)) break block11;
                int index = fullName.lastIndexOf(46);
                if (index <= 0 || index >= fullName.length() - 1) break block14;
                try {
                    ((BaseElementObject)element).setId(fullName.substring(index));
                }
                catch (PropertyVetoException e) {
                    throw new RuntimeException(e);
                }
                String pkg = fullName.substring(0, index);
                switch (elementData.getType().ordinal()) {
                    case 1: {
                        ((Configuration)element).setPackageName(pkg);
                        break block11;
                    }
                    case 2: {
                        ((Application)element).setPackageName(pkg);
                        break block11;
                    }
                    case 3: {
                        ((BeanStructure)element).setPackageName(pkg);
                        break block11;
                    }
                    case 4: {
                        ((PageDefinition)element).setPackageName(pkg);
                        break block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported element : " + element);
                    }
                }
            }
            try {
                ((BaseElementObject)element).setId(fullName);
            }
            catch (PropertyVetoException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static String getFullName(Object element) {
        ElementData elementData = ElementType.getElementData(element);
        if (elementData != null) {
            switch (elementData.getType().ordinal()) {
                case 0: {
                    return ((ADFmRegistry)((Object)element)).getFullName();
                }
                case 1: {
                    return ((Configuration)element).getFullName();
                }
                case 2: {
                    return ((Application)element).getFullName();
                }
                case 3: {
                    return ((BeanStructure)element).getFullName();
                }
                case 4: {
                    return ((PageDefinition)element).getFullName();
                }
                case 5: {
                    return ((WebApplication)((Object)element)).getFullName();
                }
                case 6: {
                    return ((PDefViewObject)((Object)element)).getFullName();
                }
                case 7: {
                    return ((PropertiesElement)element).getFullName();
                }
            }
        }
        return null;
    }

    static <E, C> void checkLoadedContent(IFile file, E element, C content) {
        if (element instanceof BaseElementObject && content instanceof Document) {
            ElementType.checkLoadedDocument(file, (BaseElementObject)element, (Document)content);
        } else if (!(element instanceof PropertiesElement) || !(content instanceof ManagedBinaryFile.BinaryContent)) {
            throw new IllegalArgumentException("Unsupported element and content: \n" + element + '\n' + content);
        }
    }

    private static void checkLoadedDocument(IFile file, BaseElementObject element, Document document) throws UnexpectedRootElement, IllegalArgumentException {
        Element xmlElement = document.getDocumentElement();
        if (xmlElement == null || xmlElement.getTagName() == null) {
            throw new IllegalArgumentException(String.format("The document must have a valid root element (file: '%s')", file));
        }
        String expectedNamespaceURI = element.getNameSpaceUrl();
        String expectedTagName = element.getXMLElementTag();
        String actualNamespaceURI = xmlElement.getNamespaceURI();
        String actualTagName = xmlElement.getTagName();
        if (!(DTRTUtil.equals((Object)expectedNamespaceURI, (Object)actualNamespaceURI) && DTRTUtil.equals((Object)expectedTagName, (Object)actualTagName) || ElementType.checkAlternateNamespaceName(xmlElement, expectedNamespaceURI, expectedTagName))) {
            throw new UnexpectedRootElement(file.getFullPath().toString(), expectedNamespaceURI, expectedTagName, actualNamespaceURI, actualTagName);
        }
    }

    private static boolean checkAlternateNamespaceName(Element element, String expectedNamespaceURI, String expectedTagName) {
        return expectedNamespaceURI.equals("http://java.sun.com/xml/ns/javaee") && element.getNamespaceURI().equals("http://xmlns.jcp.org/xml/ns/javaee") && DTRTUtil.equals((Object)expectedTagName, (Object)element.getTagName());
    }

    static <E, C> void adjustCreatedContent(E element, C content) {
        if (element instanceof BaseElementObject && content instanceof Document) {
            BaseElementObject baseElementObject = (BaseElementObject)element;
            Document document = (Document)content;
            Element documentElement = document.createElementNS(baseElementObject.getNameSpaceUrl(), baseElementObject.getXMLElementTag());
            documentElement.setAttribute("version", "12.01.02.0.0");
            document.appendChild(documentElement);
        } else if (!(element instanceof PropertiesElement) || !(content instanceof ManagedBinaryFile.BinaryContent)) {
            throw new IllegalArgumentException("Unsupported element and content: \n" + element + '\n' + content);
        }
    }

    static <E, C> E initializeElement(ElementManager manager, IManagedFile<E, C> managedFile, E element, C content) {
        if (element instanceof BaseElementObject && content instanceof Document) {
            BaseElementObject baseElementObject = (BaseElementObject)element;
            baseElementObject.setDesigntimeContext(manager.getModelDesignTimeContext());
            baseElementObject.initializeFromElement(manager.getTransactionManager(), ((Document)content).getDocumentElement());
            if (element instanceof Application) {
                DTFactory[] factories = ((Application)element).getDesigntimeFactories();
                int i = 0;
                while (i < factories.length) {
                    DTRTvUtil.registerDTFactory(factories[i]);
                    ++i;
                }
            }
        } else if (element instanceof PropertiesElement && content instanceof ManagedBinaryFile.BinaryContent) {
            PropertiesElement propertiesElement = (PropertiesElement)element;
            propertiesElement.setContent((ManagedBinaryFile.BinaryContent)content);
        } else {
            throw new IllegalArgumentException("Unsupported element and content: \n" + element + '\n' + content);
        }
        ElementType.setElementData(element, managedFile);
        manager.getFilesToBeDeleted().remove(managedFile.getFile());
        return element;
    }

    static void initializeCreatedElement(Object element, String sFullName) {
        ElementType.setFullName(element, sFullName);
        if (element instanceof Application) {
            Application application = (Application)element;
            application.setClientType("Generic");
            application.setAsProject(false);
        } else if (element instanceof BeanStructure) {
            BeanStructure beanStructure = (BeanStructure)element;
            beanStructure.setBeanClass(sFullName);
            beanStructure.setIsJavaBased(true);
        } else if (element instanceof PageDefinition) {
            PageDefinition pageDefinition = (PageDefinition)element;
            try {
                pageDefinition.addControlBinding((ControlBinding)new CtrlAttrs(), null);
            }
            catch (Exception exception) {}
        }
    }
}

