/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ActivationOptions implements Enumerator
{
    IMMEDIATE(0, "immediate", "immediate"),
    DEFERRED(1, "deferred", "deferred"),
    CONDITIONAL(2, "conditional", "conditional");

    public static final int IMMEDIATE_VALUE = 0;
    public static final int DEFERRED_VALUE = 1;
    public static final int CONDITIONAL_VALUE = 2;
    private static final ActivationOptions[] VALUES_ARRAY;
    public static final List<ActivationOptions> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ActivationOptions[]{IMMEDIATE, DEFERRED, CONDITIONAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ActivationOptions get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActivationOptions result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActivationOptions getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActivationOptions result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActivationOptions get(int value) {
        switch (value) {
            case 0: {
                return IMMEDIATE;
            }
            case 1: {
                return DEFERRED;
            }
            case 2: {
                return CONDITIONAL;
            }
        }
        return null;
    }

    private ActivationOptions(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

