/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.bind;

import java.util.Map;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.creator.v2.CreatorResult;
import oracle.adfdt.view.common.binding.creator.v2.PatternOptions;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DTRTvContextUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.bind.BindCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.WebApplication;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.IInternalWidget;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.WidgetImpl;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.TaskFlowWidget;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.WidgetType;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.OEPEExecutableContextImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.IOptionsMapper;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.NamespaceUtils;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class CreateBindingHelper
implements BindCommand.IBindCommandHelper {
    private Runnable noOpRunnable;
    private ManagedBeanManagerExecutor managedBeanManagerExecutor;

    CreateBindingHelper() {
    }

    @Override
    public void dispose() {
        if (this.managedBeanManagerExecutor != null) {
            this.managedBeanManagerExecutor.dispose();
            this.managedBeanManagerExecutor = null;
        }
        this.noOpRunnable = null;
    }

    private IWebPageContext.IBindPosition getBindPosition(BindCommand bindCommand) {
        IInternalWidget widget = bindCommand.getWidget();
        return widget != null ? widget.getBindPosition() : null;
    }

    @Override
    public void assertExecution(BindCommand bindCommand) throws Exception {
        IWebPageContext.IBindPosition bindPosition = this.getBindPosition(bindCommand);
        DTRTUtil.assertTrue((bindPosition != null ? 1 : 0) != 0, (String)"The position of a create binding command cannot be null.");
        DTRTUtil.assertTrue((bindPosition.getParentNode() != null ? 1 : 0) != 0, (String)"The position of a create binding command must define a not null parent node.");
    }

    @Override
    public boolean assertUndo(BindCommand bindCommand) throws Exception {
        return bindCommand.getUndoRunnable() != this.noOpRunnable;
    }

    @Override
    public boolean assertRedo(BindCommand bindCommand) throws Exception {
        return bindCommand.getRedoRunnable() != this.noOpRunnable;
    }

    @Override
    public Document getBoundDocument(BindCommand bindCommand) {
        IWebPageContext.IBindPosition bindPosition = this.getBindPosition(bindCommand);
        return bindPosition != null && bindPosition.getParentNode() != null ? bindPosition.getParentNode().getOwnerDocument() : null;
    }

    @Override
    public Object prepareBind(BindCommand bindCommand, IPageDefinition.IBoundSource boundSource) throws Exception {
        IInternalWidget widget = bindCommand.getWidget();
        if (widget instanceof WidgetImpl) {
            return bindCommand.getWidgetAndOptionsMapper();
        }
        if (widget instanceof TaskFlowWidget) {
            return ((TaskFlowWidget)widget).collectUserInput(bindCommand);
        }
        return null;
    }

    @Override
    public boolean bind(BindCommand bindCommand, IProject project, Object preparedData, IProgressMonitor monitor) throws Exception {
        IInternalWidget widget = bindCommand.getWidget();
        if (widget instanceof WidgetImpl) {
            Pair pair = (Pair)preparedData;
            return this.bind(bindCommand, project, (Widget<PatternOptions>)((Widget)pair.getFirst()), (IOptionsMapper)pair.getSecond(), (IDataControlObject)widget.forObject());
        }
        Map executionParameters = (Map)preparedData;
        return this.bind(bindCommand, project, (TaskFlowWidget)widget, executionParameters, monitor);
    }

    private boolean bind(BindCommand bindCommand, IProject project, Widget<PatternOptions> widget, IOptionsMapper optionsMapper, IDataControlObject dataControlObject) throws Exception {
        IWebPageContext.IBindPosition bindPosition = this.getBindPosition(bindCommand);
        DocumentFragment documentFragment = this.createBinding(bindPosition.getParentNode(), widget, optionsMapper);
        DTRTUtil.assertTrue((documentFragment != null ? 1 : 0) != 0, (String)"Unable to obtain a document fragment.");
        WebApplication.configureForDataControlObject(DTRTvContextUtil.getManager((IOEPEContext)bindCommand.getCommandStack()), ((OEPEExecutableContextImpl)bindCommand.getCommandStack()).getTranslator(), dataControlObject);
        optionsMapper.postProcess((Node)documentFragment);
        return this.addFragmentToDocument(bindCommand, documentFragment, bindPosition.getParentNode(), bindPosition.getNextSibling(), project) != null;
    }

    private boolean bind(BindCommand bindCommand, IProject project, TaskFlowWidget widget, Map<String, Object> executionParameters, IProgressMonitor monitor) throws Exception {
        IBindingObject bindingObject;
        IWebPageContext context = bindCommand.getCommandStack();
        IWebPageContext.IBindPosition bindPosition = this.getBindPosition(bindCommand);
        Document document = DTRTvContextUtil.getManager((IOEPEContext)context).getWebPageDocument();
        DocumentFragment documentFragment = widget.createDocumentFragment(context, document, bindingObject = widget.createBindingObject(context, executionParameters, monitor), executionParameters, monitor);
        DTRTUtil.assertTrue((documentFragment != null ? 1 : 0) != 0, (String)"Unable to obtain a document fragment.");
        if (this.addFragmentToDocument(bindCommand, documentFragment, bindPosition.getParentNode(), bindPosition.getNextSibling(), project) != null) {
            if (bindingObject == null) {
                if (this.noOpRunnable == null) {
                    this.noOpRunnable = new Runnable(){

                        @Override
                        public void run() {
                        }
                    };
                }
                bindCommand.setUndoRunnable(this.noOpRunnable);
                bindCommand.setRedoRunnable(this.noOpRunnable);
            }
            IBindingObject iBindingObject = bindingObject = bindingObject == null ? widget.getBindingObject() : bindingObject;
            if (widget.getType() == WidgetType.DYNAMIC_REGION || widget.getType() == WidgetType.DYNAMIC_REGION_LINK) {
                IWebPageContext.IManagedBean managedBean = (IWebPageContext.IManagedBean)executionParameters.get("dtrt.taskFlowWidget.ManagedBean");
                assert (managedBean != null);
                String taskFlowName = (String)executionParameters.get("dtrt.taskFlowWidget.TaskFlowName");
                assert (taskFlowName != null);
                String bindName = (String)executionParameters.get("dtrt.taskFlowWidget.BindName");
                assert (!(widget.getType() == WidgetType.DYNAMIC_REGION ? bindName == null : bindName != null)) : (Object)((Object)widget.getType()) + "-" + bindName;
                String linkName = (String)executionParameters.get("dtrt.taskFlowWidget.LinkName");
                assert (!(widget.getType() == WidgetType.DYNAMIC_REGION ? linkName != null : linkName == null)) : (Object)((Object)widget.getType()) + "-" + linkName;
                this.managedBeanManagerExecutor = new ManagedBeanManagerExecutor(context, managedBean, Boolean.TRUE.equals(executionParameters.get("dtrt.taskFlowWidget.ManagedBeanCreated")));
                this.managedBeanManagerExecutor.execute(taskFlowName, bindName, linkName, monitor);
            }
            return true;
        }
        return false;
    }

    @Override
    public void afterUndo(BindCommand bindCommand, IProgressMonitor monitor) throws Exception {
        if (this.managedBeanManagerExecutor != null) {
            this.managedBeanManagerExecutor.undo(monitor);
        }
    }

    @Override
    public void afterRedo(BindCommand bindCommand, IProgressMonitor monitor) throws Exception {
        if (this.managedBeanManagerExecutor != null) {
            this.managedBeanManagerExecutor.redo(monitor);
        }
    }

    private DocumentFragment createBinding(Node parentNode, Widget<PatternOptions> widget, IOptionsMapper optionsMapper) {
        if (widget != null) {
            CreatorResult create;
            Object actualOptions;
            CreatorParams params = widget.createBaseCreatorParams(parentNode);
            if (optionsMapper != null && (actualOptions = optionsMapper.getPatternOptions()) instanceof PatternOptions) {
                params.setOptions((PatternOptions)actualOptions);
            }
            if ((create = widget.create(params)) != null) {
                return create.getFragment();
            }
        }
        return null;
    }

    private Element addFragmentToDocument(BindCommand bindCommand, DocumentFragment fragment, Node parentNode, Node nextSibling, IProject project) {
        try {
            Node importedNode;
            int[] region = bindCommand.computeRegion(nextSibling);
            if (region == null) {
                Node lastChild = parentNode.getLastChild();
                region = bindCommand.computeRegion(lastChild);
            }
            if (region != null) {
                region[1] = 0;
            }
            Document ownerDoc = parentNode.getOwnerDocument();
            NamespaceUtils.ensureNamespacesSet((IProject)project, (Document)ownerDoc, (Node)fragment.getFirstChild(), (boolean)true);
            Node importNode = ownerDoc.importNode(fragment.getFirstChild(), true);
            if (fragment.getFirstChild() instanceof IDOMElement && importNode instanceof IDOMElement) {
                ((IDOMElement)importNode).setEmptyTag(!((IDOMElement)fragment.getFirstChild()).hasEndTag() && !fragment.getFirstChild().hasChildNodes());
            }
            Node node = importedNode = nextSibling == null ? parentNode.appendChild(importNode) : parentNode.insertBefore(importNode, nextSibling);
            if (nextSibling == null) {
                parentNode.appendChild(ownerDoc.createTextNode("\n"));
            }
            bindCommand.formatNode(importedNode);
            bindCommand.setUndoChangeRegion(region);
            bindCommand.setExecuteChangeRegion(bindCommand.computeRegion(importedNode));
            return (Element)importedNode;
        }
        catch (Exception e) {
            LoggingService.logException((String)"oracle.eclipse.tools.adf.dtrt.v120102", (Throwable)e);
            return null;
        }
    }

    private class ManagedBeanManagerExecutor {
        private IWebPageContext context;
        private IWebPageContext.IManagedBean managedBean;
        private boolean created;
        private Variable.SCOPE managedBeanScope;
        private String managedBeanName;
        private String managedBeanClassName;
        private IPath managedBeanJavaFilePath;
        private String taskFlowName;
        private String bindName;
        private String linkName;

        public ManagedBeanManagerExecutor(IWebPageContext context, IWebPageContext.IManagedBean managedBean, boolean created) {
            this.context = context;
            this.managedBean = managedBean;
            this.created = created;
        }

        public void dispose() {
            this.context = null;
            this.managedBean = null;
        }

        private IWebPageContext.IManagedBeanManager getManagedBeanManager() {
            return this.context.getManagedBeanManager();
        }

        public void execute(String taskFlowName, String bindName, String linkName, IProgressMonitor monitor) throws Exception {
            this.taskFlowName = taskFlowName;
            this.bindName = bindName;
            this.linkName = linkName;
            assert (!(linkName == null ? bindName == null : bindName != null)) : String.valueOf(bindName) + " - " + linkName;
            this.doBind(this.managedBean, bindName, linkName, taskFlowName, monitor);
        }

        public void undo(IProgressMonitor monitor) throws Exception {
            if (this.linkName == null) {
                Pair bind = this.getManagedBeanManager().unbindFromTaskFlow(this.managedBean, monitor);
                assert (bind != null);
                assert (this.bindName.equals(bind.getFirst())) : String.valueOf(this.bindName) + " - " + (String)bind.getFirst();
                assert (this.taskFlowName.equals(bind.getSecond())) : String.valueOf(this.taskFlowName) + " - " + (String)bind.getSecond();
            } else {
                Pair link = this.getManagedBeanManager().removeLink(this.managedBean);
                assert (link != null);
                assert (this.linkName.equals(link.getFirst())) : String.valueOf(this.linkName) + " - " + (String)link.getFirst();
                assert (this.taskFlowName.equals(link.getSecond())) : String.valueOf(this.taskFlowName) + " - " + (String)link.getSecond();
            }
            if (this.created) {
                assert (this.linkName == null);
                this.managedBeanScope = this.managedBean.getScope();
                this.managedBeanName = DTRTUtil.getLabel((IDescribable)this.managedBean);
                this.managedBeanClassName = this.managedBean.getClassName();
                this.managedBeanJavaFilePath = this.managedBean.getJavaFilePath();
                this.getManagedBeanManager().removeManagedBean(this.managedBean, monitor);
                this.managedBean = null;
            }
        }

        public void redo(IProgressMonitor monitor) throws Exception {
            if (this.created) {
                assert (this.linkName == null);
                this.managedBean = this.getManagedBeanManager().addTaskFlowManagedBean(this.managedBeanScope, this.managedBeanName, this.managedBeanClassName, this.managedBeanJavaFilePath, monitor);
                if (this.managedBean == null) {
                    throw new IllegalStateException("managedBean cannot be null");
                }
            }
            this.doBind(this.managedBean, this.bindName, this.linkName, this.taskFlowName, monitor);
        }

        private void doBind(IWebPageContext.IManagedBean managedBean, String bindName, String linkName, String taskFlowName, IProgressMonitor monitor) throws Exception {
            if (linkName == null) {
                this.getManagedBeanManager().bindToTaskFlow(managedBean, bindName, taskFlowName, monitor);
            } else {
                this.getManagedBeanManager().addLink(managedBean, linkName, taskFlowName);
            }
        }
    }
}

