/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.facade.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommandRunnable;
import oracle.eclipse.tools.adf.dtrt.command.ICommandStack;
import oracle.eclipse.tools.adf.dtrt.command.IUndoableRunnableCommand;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DTRTvContextUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IBaseObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IChangeSummary;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IElementChange;
import oracle.eclipse.tools.adf.dtrt.vcommon.command.RunnableCommandImpl;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class UndoableRunnableCommand
extends RunnableCommandImpl
implements IUndoableRunnableCommand {
    private IChangeSummary summary;
    private List<Object> executionAffectedObjects;
    private boolean undoInterruptedExecution;

    public UndoableRunnableCommand(IOEPEExecutableContext context) {
        super((ICommandStack)context);
    }

    public void dispose() {
        if (this.executionAffectedObjects != null) {
            this.executionAffectedObjects.clear();
            this.executionAffectedObjects = null;
        }
        this.summary = null;
        super.dispose();
    }

    public IOEPEExecutableContext getCommandStack() {
        return (IOEPEExecutableContext)super.getCommandStack();
    }

    private IChangeSummary getSummary() {
        return this.summary;
    }

    public IUndoableRunnableCommand setRunnable(String label, Runnable runnable) {
        this.setExecutionRunnable(label, runnable);
        return this;
    }

    public void setUndoInterruptedExecution(boolean undoInterruptedExecution) {
        this.undoInterruptedExecution = undoInterruptedExecution;
    }

    public boolean isUndoInterruptedExecution() {
        return this.undoInterruptedExecution;
    }

    protected void doExecute(IProgressMonitor monitor) throws Exception {
        IChangeSummary changeSummary;
        InterruptedException interruptedException;
        Collection<Pair<IBaseObject, Object>> pairs;
        IDTRTManager manager;
        block10: {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)4);
            manager = DTRTvContextUtil.getManager((IOEPEContext)this.getCommandStack());
            pairs = this.getObjectAndElement(this.getCommandStack(), manager);
            interruptedException = null;
            manager.beginRecording();
            try {
                try {
                    super.doExecute(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)3));
                    changeSummary = manager.endRecording(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                }
                catch (InterruptedException e) {
                    if (!this.isUndoInterruptedExecution()) {
                        throw e;
                    }
                    interruptedException = e;
                    changeSummary = manager.endRecording((IProgressMonitor)new NullProgressMonitor());
                    manager.abortRecording();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                manager.abortRecording();
                throw throwable;
            }
            manager.abortRecording();
        }
        this.executionAffectedObjects = new ArrayList<Object>(this.getAffectedObjects());
        if (changeSummary != null) {
            if (pairs.isEmpty()) {
                pairs = this.getObjectAndElement(this.getCommandStack(), manager);
            }
            this.notifyPropertyChange(changeSummary, pairs);
            if (manager.canApply(changeSummary)) {
                this.summary = changeSummary;
                this.setUndoRunnable((Runnable)((Object)new CommandRunnable()));
                this.setRedoRunnable(this.getUndoRunnable());
            }
        }
        if (interruptedException != null) {
            this.doUndo((IProgressMonitor)new NullProgressMonitor());
            throw interruptedException;
        }
    }

    private Collection<Pair<IBaseObject, Object>> getObjectAndElement(IOEPEExecutableContext context, IDTRTManager manager) {
        PageDefinition adfPageDefinition;
        IBaseObject baseObject = (IBaseObject)DTRTvContextUtil.getPageDefinition((IOEPEContext)context);
        if (baseObject != null && (adfPageDefinition = (PageDefinition)baseObject.getDecoratedObject()) != null) {
            return Collections.singleton(new Pair((Object)baseObject, (Object)adfPageDefinition));
        }
        return Collections.emptyList();
    }

    private void notifyPropertyChange(IChangeSummary summary, Collection<Pair<IBaseObject, Object>> pairs) {
        IDTRTManager manager = DTRTvContextUtil.getManager((IOEPEContext)this.getCommandStack());
        block0: for (Pair<IBaseObject, Object> pair : pairs) {
            for (IElementChange iElementChange : summary.getChanges()) {
                if (!manager.areEqualElements(manager.getElement(iElementChange), pair.getSecond())) continue;
                ((IBaseObject)pair.getFirst()).handlePropertyChange((Object[])IBaseObject.CachedProperty.values());
                continue block0;
            }
        }
    }

    protected void assertUndo() throws Exception {
        super.assertUndo();
        DTRTUtil.assertTrue((this.summary != null ? 1 : 0) != 0, (String)Messages.changeSummaryUnavailableToUndo);
        DTRTUtil.assertTrue((boolean)DTRTvContextUtil.getManager((IOEPEContext)this.getCommandStack()).canApply(this.getSummary()), (String)Messages.changeSummaryCannotBeApplied);
    }

    protected void assertRedo() throws Exception {
        super.assertRedo();
        DTRTUtil.assertTrue((this.summary != null ? 1 : 0) != 0, (String)Messages.changeSummaryUnavailableToRedo);
        DTRTUtil.assertTrue((boolean)DTRTvContextUtil.getManager((IOEPEContext)this.getCommandStack()).canApply(this.getSummary()), (String)Messages.changeSummaryCannotBeApplied);
    }

    private class CommandRunnable
    implements ICommandRunnable {
        private CommandRunnable() {
        }

        public void dispose() {
        }

        public boolean isDisposed() {
            return false;
        }

        public void run() {
        }

        public List<?> run(ICommandStack commandStack, ICommand.CommandOperation operation, IProgressMonitor monitor) throws Exception {
            IChangeSummary changeSummary = UndoableRunnableCommand.this.summary;
            UndoableRunnableCommand.this.summary = null;
            ICommand.CommandOperation nextOperation = ICommand.CommandOperation.nextOperation((ICommand)UndoableRunnableCommand.this);
            IDTRTManager manager = DTRTvContextUtil.getManager((IOEPEContext)UndoableRunnableCommand.this.getCommandStack());
            Collection pairs = UndoableRunnableCommand.this.getObjectAndElement(UndoableRunnableCommand.this.getCommandStack(), manager);
            changeSummary = manager.apply(changeSummary);
            if (pairs.isEmpty()) {
                pairs = UndoableRunnableCommand.this.getObjectAndElement(UndoableRunnableCommand.this.getCommandStack(), manager);
            }
            UndoableRunnableCommand.this.notifyPropertyChange(changeSummary, pairs);
            if (changeSummary != null && manager.canApply(changeSummary)) {
                UndoableRunnableCommand.this.summary = changeSummary;
            }
            assert (nextOperation != null);
            return nextOperation == ICommand.CommandOperation.UNDO ? null : UndoableRunnableCommand.this.executionAffectedObjects;
        }
    }
}

