/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.editor.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.validator.EditorValidationStore;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CompositeFeatureValidationStatusProvider
extends ValidationStatusProvider {
    private final ArrayList<EditorValidationStore.FeatureValidationStatusProvider> statusProviders = new ArrayList();
    private WritableList targets;
    private WritableList models;
    private IObservableValue validationStatus;

    public CompositeFeatureValidationStatusProvider(Collection<? extends EStructuralFeature> featuresToTrack, Map<EStructuralFeature, EditorValidationStore.FeatureValidationStatusProvider> diagnostics) {
        for (EStructuralFeature eStructuralFeature : featuresToTrack) {
            if (eStructuralFeature == null) continue;
            EditorValidationStore.FeatureValidationStatusProvider provider = diagnostics.get(eStructuralFeature);
            this.statusProviders.add(provider);
        }
    }

    public void dispose() {
        super.dispose();
        for (EditorValidationStore.FeatureValidationStatusProvider provider : this.statusProviders) {
            provider.dispose();
        }
        this.statusProviders.clear();
    }

    public IObservableValue getValidationStatus() {
        if (this.validationStatus == null) {
            final ArrayList<IObservableValue> statusObservables = new ArrayList<IObservableValue>(this.statusProviders.size());
            for (EditorValidationStore.FeatureValidationStatusProvider provider : this.statusProviders) {
                IObservableValue validationStatus = provider.getValidationStatus();
                statusObservables.add(validationStatus);
            }
            this.validationStatus = new AbstractObservableValue(){
                private boolean isListening = false;
                private EventPropagator propagator = new EventPropagator(new PropagateRunnable(){

                    @Override
                    public void propagate(ValueDiff diff) {
                        this.fireValueChange(diff);
                    }
                });

                public synchronized void addValueChangeListener(IValueChangeListener listener) {
                    super.addValueChangeListener(listener);
                }

                public synchronized void removeValueChangeListener(IValueChangeListener listener) {
                    super.removeValueChangeListener(listener);
                }

                protected Object calculate() {
                    MultiStatus multiStatus = new MultiStatus("oracle.eclipse.tools.adf.dtrt.v120102", 0, "This is container error and should not be seen", null);
                    for (final IObservableValue statusObservable : statusObservables) {
                        if (!this.isListening) {
                            statusObservable.addValueChangeListener((IValueChangeListener)this.propagator);
                            statusObservable.addDisposeListener(new IDisposeListener(){

                                public void handleDispose(DisposeEvent event) {
                                    statusObservable.removeValueChangeListener((IValueChangeListener)propagator);
                                }
                            });
                        }
                        IStatus value = (IStatus)statusObservable.getValue();
                        multiStatus.add(value);
                    }
                    this.isListening = true;
                    return multiStatus;
                }

                public synchronized void dispose() {
                    super.dispose();
                    for (IObservableValue statusObservable : statusObservables) {
                        statusObservable.dispose();
                    }
                    statusObservables.clear();
                }

                public Object getValueType() {
                    return IStatus.class;
                }

                protected Object doGetValue() {
                    return this.calculate();
                }
            };
        }
        return this.validationStatus;
    }

    public IObservableList getTargets() {
        if (this.targets == null) {
            this.targets = new WritableList();
        }
        return this.targets;
    }

    public IObservableList getModels() {
        if (this.models == null) {
            this.models = new WritableList();
        }
        return this.models;
    }

    private static class EventPropagator
    implements IValueChangeListener {
        private final PropagateRunnable runnable;

        public EventPropagator(PropagateRunnable runnable) {
            this.runnable = runnable;
        }

        public void handleValueChange(ValueChangeEvent event) {
            this.runnable.propagate(event.diff);
        }
    }

    private static abstract class PropagateRunnable {
        private PropagateRunnable() {
        }

        public abstract void propagate(ValueDiff var1);
    }
}

