/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.editor.provider;

import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.OperationDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.provider.DtrtAdaptingFilter;
import org.eclipse.jface.viewers.Viewer;

public class MethodOperationsFilter
extends DtrtAdaptingFilter {
    private final boolean excludeMethods;
    private final boolean includeConstructor;
    public static final MethodOperationsFilter EXCLUDE_METHOD_OPERATIONS = new MethodOperationsFilter(true, false);
    public static final MethodOperationsFilter INCLUDE_ONLY_METHOD_OPERATIONS = new MethodOperationsFilter(false, false);
    public static final MethodOperationsFilter INCLUDE_ONLY_METHOD_OPERATIONS_AND_CONSTRUCTORS = new MethodOperationsFilter(false, true);

    public MethodOperationsFilter(boolean excludeMethods, boolean includeConstructor) {
        this.excludeMethods = excludeMethods;
        this.includeConstructor = includeConstructor;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        Object adaptedElement = this.adapt(element);
        if (adaptedElement instanceof OperationDefinition) {
            if (this.excludeMethods) {
                return !DTRTvUtil.isMethod((NamedDefinition)adaptedElement);
            }
            boolean isMethod = DTRTvUtil.isMethod((NamedDefinition)adaptedElement);
            boolean isConstructor = DTRTvUtil.isConstructor((NamedDefinition)adaptedElement);
            return isMethod || isConstructor && this.includeConstructor;
        }
        return true;
    }
}

