/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.editor.dialog.advisor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IExecutable;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IStructuredTypeObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.dialog.advisor.IteratorSelection;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IteratorBinding;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.ObjectImplUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.dialog.advisor.FilterIdMatcher;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.dialog.advisor.IteratorComboUpdater;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;

public class IteratorComboUpdaterForAccessorIterator
extends IteratorComboUpdater {
    private final FilterIdMatcher matcher;

    public IteratorComboUpdaterForAccessorIterator(Realm realm, IObservableValue triggeringModel, IPageDefinition pageDef, FilterIdMatcher filterIdMatcher) {
        super(realm, triggeringModel, pageDef);
        this.matcher = filterIdMatcher;
    }

    public IteratorComboUpdaterForAccessorIterator(IObservableValue triggeringModel, IPageDefinition pageDef, FilterIdMatcher filterIdMatcher) {
        this(Realm.getDefault(), triggeringModel, pageDef, filterIdMatcher);
    }

    protected List<?> calculate() {
        ArrayList<IteratorSelection> newList = Collections.EMPTY_LIST;
        Object value = this.getTriggeringModel().getValue();
        if (value instanceof IDataControlObject && ObjectImplUtil.needsIterator((IStructuredTypeObject)((IDataControlObject)value))) {
            newList = new ArrayList<IteratorSelection>(2);
            IDataControlObject dataControlObject = (IDataControlObject)value;
            int definitionType = ObjectImplUtil.getDefinition((IStructuredTypeObject)dataControlObject);
            for (IExecutable executable : this.getPageDef().getExecutables()) {
                if (!(executable instanceof IteratorBinding) || !this.matcher.matches(executable)) continue;
                IDataControlObject iteratorDataControlObject = executable.getDataControlObject();
                boolean useIterator = false;
                switch (definitionType) {
                    case 40: {
                        useIterator = ObjectImplUtil.isValidIteratorParentForAccessorOnChild(iteratorDataControlObject, dataControlObject);
                    }
                }
                if (!useIterator) continue;
                newList.add(new IteratorSelection((IteratorBinding)executable));
            }
        }
        return newList;
    }

    public Object getElementType() {
        return IteratorSelection.class;
    }
}

