/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.editor.binding;

import java.util.Set;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdt.model.objects.Variable;
import oracle.adfdt.model.objects.VariablesIterator;
import oracle.binding.meta.NamedDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.binding.IsValidDecoratedInstanceValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class IsDecoratedDefinitionTypeValidator
extends IsValidDecoratedInstanceValidator {
    private Set<Integer> definitionTypes;

    public IsDecoratedDefinitionTypeValidator(Class<?> type, String errorMessage, Set<Integer> definitionTypes) {
        super(type, errorMessage);
        this.definitionTypes = definitionTypes;
    }

    public IsDecoratedDefinitionTypeValidator(Set<Class> types, String errorMessage, Set<Integer> definitionTypes) {
        super(types, errorMessage);
        this.definitionTypes = definitionTypes;
    }

    public IStatus validate(Object value) {
        Object adapted = this.adapt(value);
        if (!(adapted == null || adapted instanceof NamedDefinition || adapted instanceof DataControl || adapted instanceof Variable || adapted instanceof VariablesIterator)) {
            throw new IllegalArgumentException("Arguments to IsDecoratedDefinitionTypeValidator must adapt to NamedDefinition objects");
        }
        IStatus superStatus = super.validate(value);
        if (superStatus.isOK()) {
            if (adapted instanceof NamedDefinition) {
                if (!this.definitionTypes.contains(((NamedDefinition)adapted).getDefinitionType())) {
                    superStatus = new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", this.getErrorMessage());
                }
            } else if (adapted instanceof Variable && !this.definitionTypes.contains(80)) {
                superStatus = new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", this.getErrorMessage());
            }
        }
        return superStatus;
    }
}

