/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.editor;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.NamedDefinition;
import oracle.eclipse.tools.adf.dtrt.command.CompoundCommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructuredTypeObject;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DataControlObjectContentProvider;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DelegatingObjectContentProvider;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DescribableLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.provider.IObjectContentProviderDelegate;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.DescribableViewer;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.BaseCtrlValueBindingEditor;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.UIHelpContext;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.binding.ErrorTolerantEObjectObservableValue;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.converter.DataControlObjectLookup;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.converter.DataControlObjectToClassConverter;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.converter.IdToDataControlObjectConverter;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.dialog.AccessorSelectionDialog;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.dialog.AttributeSelectionDialog;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.dialog.advisor.ListSourceAttributeSelectionValueCreationAdvisor;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.dialog.advisor.ListTargetAttributeSelectionValueCreationAdvisor;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.provider.AttributeRowValueLabelProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.provider.DtrtAdaptingFilter;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.provider.ListBindingAttributeProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.provider.NamedDefinitionContentProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.provider.VariableIteratorContentProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.validator.AssignableTypeValidator;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.SetCommandFactory;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ExecutablePackage;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IBaseObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlList;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.ADFTypeResolver;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.DataControlJavaTypeResolver;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.OEPEContextImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.command.SelectionOperationHandler;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.EditorLabelMessages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.binding.SingleArrayElementObservableValue;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.DynamicListBoundComboPropertyEditor;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.ListBoundComboPropertyEditor;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.PopupControlDecorationUpdater;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.PropertyEditorFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.SelectionBasedEditorFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.TableFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.TablePropertyEditor;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.converter.ChainingConverter;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.converter.DataControlObjectToIdConverter;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.converter.IObjectToLabelConverter;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.converter.StringArrayToStringConverter;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.dialog.strategy.AttributeBindingDialogCreationStrategy;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.AbstractAttributeRowEditingSupport;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.AttributeRowValue;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.ListBindingAttributeLabelProvider;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.provider.TableAttributeEditingSupport;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.viewer.ComboPropertyEditorViewer;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.viewer.FormTextEditorViewer;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.viewer.PropertyEditorViewer;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.viewer.TablePropertyEditorViewer;
import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.TextDialogPropertyEditor;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ICtrlListBindingEditor
extends BaseCtrlValueBindingEditor<ICtrlList> {
    private static final int LIST_ATTR_TABLE_COLUMN_IDX = 1;
    private static final int TARGET_ATTR_TABLE_COLUMN_IDX = 0;
    private PropertyEditorViewer<ListBoundComboPropertyEditor> displayAttributes;
    private FormTextEditorViewer listIteratorText;
    private PropertyEditorViewer<TablePropertyEditor> attributesTable;
    private PropertyEditorViewer<TextDialogPropertyEditor> targetAttributeTextDialog;
    private PropertyEditorViewer<TextDialogPropertyEditor> listSourceAttributeDialogText;
    protected AttributeSelectionDialog attributeSelectionDialog;
    private AccessorSelectionDialog listSourceAttributeSelectionDialog;
    private Binding targetAttributeBinding;
    private WritableList displayItems;
    private FormTextEditorViewer listDataControlText;
    private Binding displayAttributesComboUpdateBinding;
    private WritableValue forceDisplayToRecalculate = new WritableValue();
    private RemoveMappingRunnable removeMappingHandler;

    public ICtrlListBindingEditor(ICtrlList eObj, IPageDefinitionContext editorContext) {
        super(eObj, editorContext);
        this.addValidationFeature((EStructuralFeature)ExecutablePackage.Literals.ICONTROL_BINDING__ITER_BINDING_NAME);
        this.addValidationFeature((EStructuralFeature)ExecutablePackage.Literals.ICTRL_LIST__LIST_ITERATOR_BINDING_NAME);
        this.addValidationFeature((EStructuralFeature)ExecutablePackage.Literals.ICTRL_LIST__LIST_ATTR_NAMES);
        this.addValidationFeature((EStructuralFeature)ExecutablePackage.Literals.ICTRL_LIST__LIST_DISPLAY_ATTR_NAMES);
        this.addValidationFeature((EStructuralFeature)ExecutablePackage.Literals.ICTRL_VALUE__TARGET_BINDING);
        this.addValidationFeature((EStructuralFeature)ExecutablePackage.Literals.ICTRL_LIST__LIST_SOURCE_BINDING);
    }

    @Override
    public void bindControls(DataBindingContext context, Object model) {
        super.bindControls(context, model);
        this.bindTargetAttributeText(context, model);
        this.bindListIteratorText(context);
        this.bindDisplayAttributesTable(context);
        this.bindListSourceAttributeText(context, model);
        this.bindAttributesTable(context, model);
        this.bindListDataControl(context, model);
    }

    @Override
    public void dispose() {
        if (this.attributesTable != null) {
            this.attributesTable.dispose();
            this.attributesTable = null;
        }
        super.dispose();
    }

    @Override
    protected void refreshUI(ICommand command) {
        super.refreshUI(command);
        this.attributesTable.refresh();
        this.displayAttributes.refresh();
    }

    private void bindListDataControl(DataBindingContext context, Object model) {
        ErrorTolerantEObjectObservableValue modelObservable = new ErrorTolerantEObjectObservableValue((IOEPEExecutableContext)this.getContext(), (IBaseObject)this.getModel(), (EStructuralFeature)ExecutablePackage.Literals.ICTRL_LIST__LIST_DATA_CONTROL);
        this.manageObservable((IObservable)modelObservable);
        this.listDataControlText.bind(context, (IObservableValue)modelObservable, this.toolkit);
        this.listDataControlText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ICtrlListBindingEditor.this.notifyObjectSelectionListeners((ISelection)new StructuredSelection(e.getHref()));
            }
        });
    }

    private void bindTargetAttributeText(DataBindingContext context, Object model) {
        this.targetAttributeBinding = this.bind(context, this.targetAttributeTextDialog.getPropertyEditor(), (ICtrlList)this.getModel(), (EStructuralFeature)ExecutablePackage.Literals.ICTRL_VALUE__TARGET_BINDING, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)new IObjectToLabelConverter()), Arrays.asList(ExecutablePackage.Literals.ICTRL_VALUE__TARGET_BINDING));
        this.getValidationStore().getModels().add((Object)new ErrorTolerantEObjectObservableValue((IOEPEExecutableContext)this.getContext(), (IBaseObject)this.getModel(), (EStructuralFeature)ExecutablePackage.Literals.ICTRL_VALUE__TARGET_BINDING));
    }

    private void bindListSourceAttributeText(DataBindingContext context, Object model) {
        this.bind(context, this.listSourceAttributeDialogText.getPropertyEditor(), (ICtrlList)this.getModel(), (EStructuralFeature)ExecutablePackage.Literals.ICTRL_LIST__LIST_SOURCE_BINDING, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)new IObjectToLabelConverter()), this.createTextControlValidationDecorator(context, this.listSourceAttributeDialogText.getPropertyEditor()), Collections.singletonList(ExecutablePackage.Literals.ICTRL_LIST__LIST_ITERATOR_BINDING_NAME));
        IObservableValue targetAttr = (IObservableValue)this.targetAttributeBinding.getModel();
        DataControlObjectToClassConverter dcToClassConverter = new DataControlObjectToClassConverter(OEPEContextImpl.getTranslator((IOEPEContext)this.getContext()));
        WritableValue mustBeAssignableTo = new WritableValue(dcToClassConverter.convert(targetAttr.getValue()), NamedDefinition.class);
        context.bindValue((IObservableValue)mustBeAssignableTo, targetAttr, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)dcToClassConverter));
        DataBindingContext dialogContext = new DataBindingContext();
        this.listSourceAttributeSelectionDialog = new AccessorSelectionDialog(((TextDialogPropertyEditor)this.listSourceAttributeDialogText.getPropertyEditor()).getControl().getShell(), (ILabelProvider)new DescribableLabelProvider(), (ITreeContentProvider)new DataControlObjectContentProvider(), new ListSourceAttributeSelectionValueCreationAdvisor(dialogContext, this.getContext(), (ICtrlList)this.getModel(), (IValidator)new AssignableTypeValidator(new DataControlJavaTypeResolver((IOEPEContext)this.getContext()), mustBeAssignableTo), UIHelpContext.EDIT_LIST_SOURCE_BINDING_DLG.getId()), new DtrtAdaptingFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                AttributeDefinition attributeDefinition;
                Object namedDef = this.adapt(element);
                return !(namedDef instanceof NamedDefinition) || ((NamedDefinition)namedDef).getDefinitionType() != 30 || "element".equals((attributeDefinition = (AttributeDefinition)namedDef).getName()) && attributeDefinition.getFullName() != null && attributeDefinition.getFullName().endsWith(".element");
            }
        });
        this.listSourceAttributeSelectionDialog.setInput(DTRTObjectUtil.getDataControls((IDataControlProvider)this.getContext()));
    }

    private void bindAttributesTable(DataBindingContext context, Object model) {
        ListBindingAttributeProvider provider = new ListBindingAttributeProvider();
        ((TablePropertyEditor)this.attributesTable.getPropertyEditor()).setContentProvider((IContentProvider)provider);
        ((TablePropertyEditor)this.attributesTable.getPropertyEditor()).setLabelProvider((ITableLabelProvider)new ListBindingAttributeLabelProvider());
        ((TablePropertyEditor)this.attributesTable.getPropertyEditor()).setInput(this.getModel());
        this.addCellEditors(context, this.attributesTable);
        ValidationStatusProvider validationStatus = this.getValidationStore().getValidationStatus(Arrays.asList(ExecutablePackage.Literals.ICTRL_LIST__LIST_ATTR_NAMES, ExecutablePackage.Literals.ICTRL_VALUE__ATTR_NAMES));
        final IObservableValue listAttrObservable = EMFObservables.observeValue(this.getModel(), (EStructuralFeature)ExecutablePackage.Literals.ICTRL_LIST__LIST_ATTR_NAMES);
        this.manageObservable((IObservable)listAttrObservable);
        IValueChangeListener tableModelChangeUpdater = new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                ICtrlListBindingEditor.this.redrawUI();
            }
        };
        listAttrObservable.addValueChangeListener(tableModelChangeUpdater);
        this.getValidationStore().getModels().add((Object)listAttrObservable);
        validationStatus.getModels().add((Object)listAttrObservable);
        final IObservableValue attrObservable = EMFObservables.observeValue(this.getModel(), (EStructuralFeature)ExecutablePackage.Literals.ICTRL_VALUE__ATTR_NAMES);
        this.manageObservable((IObservable)attrObservable);
        attrObservable.addValueChangeListener(tableModelChangeUpdater);
        this.getValidationStore().getModels().add((Object)attrObservable);
        validationStatus.getModels().add((Object)attrObservable);
        validationStatus.getTargets().add((Object)ViewersObservables.observeInput((Viewer)((TablePropertyEditor)this.attributesTable.getPropertyEditor()).getViewer()));
        ControlDecorationSupport.create((ValidationStatusProvider)validationStatus, (int)16512, null, (ControlDecorationUpdater)new PopupControlDecorationUpdater(context, this.toolkit, ((TablePropertyEditor)this.attributesTable.getPropertyEditor()).getBindingControl(), validationStatus.getValidationStatus()));
        ComputedValue enablement = new ComputedValue(){

            protected Object calculate() {
                IObservableValue validationObservable = ICtrlListBindingEditor.this.getValidationStore().getValidationStatus(Arrays.asList(ExecutablePackage.Literals.ICONTROL_BINDING__ITER_BINDING_NAME, ExecutablePackage.Literals.ICTRL_LIST__LIST_ITERATOR_BINDING_NAME)).getValidationStatus();
                if (((IStatus)validationObservable.getValue()).getSeverity() == 4) {
                    return Boolean.FALSE;
                }
                attrObservable.getValue();
                listAttrObservable.getValue();
                IStructuredTypeObject targetBinding = ((ICtrlList)ICtrlListBindingEditor.this.getModel()).getTargetBinding();
                IDataControlObject listSourceBinding = ((ICtrlList)ICtrlListBindingEditor.this.getModel()).getListSourceBinding();
                if (!this.isSimpleAttribute(targetBinding) && !this.isSimpleAttribute((IStructuredTypeObject)listSourceBinding)) {
                    return true;
                }
                return false;
            }

            private boolean isSimpleAttribute(IStructuredTypeObject ctrlObj) {
                if (ctrlObj instanceof IDataControlObject) {
                    return ADFTypeResolver.INSTANCE.isSimpleTypeAttribute((IDataControlObject)ctrlObj);
                }
                return false;
            }
        };
        context.bindValue(((TablePropertyEditor)this.attributesTable.getPropertyEditor()).getEnablementObservable(), (IObservableValue)enablement, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy());
    }

    private void bindDisplayAttributesTable(DataBindingContext context) {
        ErrorTolerantEObjectObservableValue trueModel = new ErrorTolerantEObjectObservableValue((IOEPEExecutableContext)this.getContext(), (IBaseObject)this.getModel(), (EStructuralFeature)ExecutablePackage.Literals.ICTRL_LIST__LIST_DISPLAY_ATTR_NAMES);
        this.manageObservable((IObservable)trueModel);
        ErrorTolerantEObjectObservableValue listBindingAttribute = new ErrorTolerantEObjectObservableValue((IOEPEExecutableContext)this.getContext(), (IBaseObject)this.getModel(), (EStructuralFeature)ExecutablePackage.Literals.ICTRL_LIST__LIST_ITERATOR_BINDING_NAME);
        this.manageObservable((IObservable)listBindingAttribute);
        DataControlObjectLookup lookup = new DataControlObjectLookup((IObservableValue)listBindingAttribute, this.getContext());
        SingleArrayElementObservableValue arrayElementObservable = new SingleArrayElementObservableValue(0, String.class, (IObservableValue)trueModel, true);
        this.manageObservable((IObservable)arrayElementObservable);
        StringArrayToStringConverter converter = new StringArrayToStringConverter(0);
        IdToDataControlObjectConverter dataControlObjectConverter = new IdToDataControlObjectConverter(lookup);
        ComputedList comboList = new ComputedList((IObservableValue)listBindingAttribute, lookup){
            private final /* synthetic */ IObservableValue val$listBindingAttribute;
            private final /* synthetic */ DataControlObjectLookup val$lookup;
            {
                this.val$listBindingAttribute = iObservableValue;
                this.val$lookup = dataControlObjectLookup;
            }

            protected List calculate() {
                this.val$listBindingAttribute.getValue();
                ICtrlListBindingEditor.this.forceDisplayToRecalculate.getValue();
                return this.val$lookup.getAttributeChildren();
            }
        };
        this.manageObservable((IObservable)comboList);
        final AtomicBoolean isRefreshingList = new AtomicBoolean();
        this.displayAttributesComboUpdateBinding = context.bindList(((DynamicListBoundComboPropertyEditor)this.displayAttributes.getPropertyEditor()).getListItems(), (IObservableList)comboList, new UpdateListStrategy(), new UpdateListStrategy(){

            protected IStatus doAdd(IObservableList observableList, Object element, int index) {
                try {
                    isRefreshingList.set(true);
                    IStatus iStatus = super.doAdd(observableList, element, index);
                    return iStatus;
                }
                finally {
                    isRefreshingList.set(false);
                }
            }

            protected IStatus doRemove(IObservableList observableList, int index) {
                try {
                    isRefreshingList.set(true);
                    IStatus iStatus = super.doRemove(observableList, index);
                    return iStatus;
                }
                finally {
                    isRefreshingList.set(false);
                }
            }

            protected IStatus doMove(IObservableList observableList, int oldIndex, int newIndex) {
                try {
                    isRefreshingList.set(true);
                    IStatus iStatus = super.doMove(observableList, oldIndex, newIndex);
                    return iStatus;
                }
                finally {
                    isRefreshingList.set(false);
                }
            }

            protected IStatus doReplace(IObservableList observableList, int index, Object element) {
                try {
                    isRefreshingList.set(true);
                    IStatus iStatus = super.doReplace(observableList, index, element);
                    return iStatus;
                }
                finally {
                    isRefreshingList.set(false);
                }
            }
        });
        IObservableValue uiObservable = ((ListBoundComboPropertyEditor)this.displayAttributes.getPropertyEditor()).getObservableValue(2);
        Binding bindValue = context.bindValue(uiObservable, (IObservableValue)arrayElementObservable, new UpdateValueStrategy(){

            protected IStatus doSet(IObservableValue observableValue, Object value) {
                if (!isRefreshingList.get() && value != null) {
                    return super.doSet(observableValue, value);
                }
                return Status.OK_STATUS;
            }
        }.setConverter((IConverter)new DataControlObjectToIdConverter()), new UpdateValueStrategy().setConverter((IConverter)new ChainingConverter((IConverter)converter, (IConverter)dataControlObjectConverter)));
        ValidationStatusProvider validationStatus = this.getValidationStore().getValidationStatus((EStructuralFeature)ExecutablePackage.Literals.ICTRL_LIST__LIST_DISPLAY_ATTR_NAMES);
        this.getValidationStore().getTargets().add((Object)bindValue);
        validationStatus.getTargets().add((Object)bindValue.getTarget());
        this.getValidationStore().getModels().add((Object)trueModel);
        validationStatus.getModels().add((Object)trueModel);
        ControlDecorationSupport.create((ValidationStatusProvider)validationStatus, (int)16512, null, (ControlDecorationUpdater)new PopupControlDecorationUpdater(context, this.toolkit, (Control)((ListBoundComboPropertyEditor)this.displayAttributes.getPropertyEditor()).getBindingControl(), validationStatus.getValidationStatus()));
        this.bindEnablementToValidFeature(context, this.displayAttributes.getPropertyEditor(), Arrays.asList(ExecutablePackage.Literals.ICONTROL_BINDING__ITER_BINDING_NAME, ExecutablePackage.Literals.ICTRL_LIST__LIST_ITERATOR_BINDING_NAME));
    }

    private void bindListIteratorText(DataBindingContext context) {
        ErrorTolerantEObjectObservableValue modelObservable = new ErrorTolerantEObjectObservableValue((IOEPEExecutableContext)this.getContext(), (IBaseObject)this.getModel(), (EStructuralFeature)ExecutablePackage.Literals.ICTRL_LIST__LIST_ITERATOR_BINDING_NAME);
        this.manageObservable((IObservable)modelObservable);
        this.listIteratorText.bind(context, (IObservableValue)modelObservable, this.toolkit);
        this.listIteratorText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ICtrlListBindingEditor.this.notifyObjectSelectionListeners((ISelection)new StructuredSelection(e.getHref()));
            }
        });
        this.bindEnablementToValidFeature(context, this.listIteratorText.getPropertyEditor(), (EStructuralFeature)ExecutablePackage.Literals.ICONTROL_BINDING__ITER_BINDING_NAME);
    }

    @Override
    protected void addControls(IManagedForm managedForm, FormToolkit toolkit, Composite parent) {
        DTRTUIUtil.createSectionLabel((FormToolkit)toolkit, (Composite)parent, (String)EditorLabelMessages.objectLabel);
        this.objectViewer = new DescribableViewer();
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.objectViewer.createControl(toolkit, parent, false, false));
        this.setTypeLabel(this.createTypeLabelFormText(parent));
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.getTypeLabel().createControl(toolkit, parent, false, false));
        this.createTargetAttributeControls(toolkit, parent);
        this.iteratorText = this.createIteratorText(toolkit, parent);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.iteratorText.createControl(toolkit, parent, false, false));
        this.dataControlText = this.createDataControlText(toolkit, parent);
        Control createControl = this.dataControlText.createControl(toolkit, parent, false, false);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)createControl);
        Label title = DTRTUIUtil.createSectionLabel((FormToolkit)toolkit, (Composite)parent, (String)EditorLabelMessages.ICtrlListBindingEditor_0);
        GridDataFactory.swtDefaults().span(2, 1).indent(0, 10).grab(true, false).align(4, 0x1000000).applyTo((Control)title);
        Label separator = toolkit.createSeparator(parent, 256);
        GridDataFactory.swtDefaults().span(2, 1).grab(true, false).indent(0, 0).align(4, 0x1000000).applyTo((Control)separator);
        Label spacer = DTRTUIUtil.createSectionLabel((FormToolkit)toolkit, (Composite)parent, (String)"");
        GridDataFactory.swtDefaults().span(2, 1).grab(true, false).indent(0, -15).align(4, 0x1000000).applyTo((Control)spacer);
        this.createListSourceAttributeControls(toolkit, parent);
        this.listIteratorText = this.createListIteratorText(toolkit, parent);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.listIteratorText.createControl(toolkit, parent, false, false));
        this.listDataControlText = this.createDataControlText(toolkit, parent);
        Control listDataControl = this.listDataControlText.createControl(toolkit, parent, false, false);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)listDataControl);
        this.displayAttributes = this.createDisplayAttributesCombo(parent);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.displayAttributes.createControl(toolkit, parent, false, false));
        this.attributesTable = this.createAttributesTable(toolkit, parent);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.attributesTable.createControl(toolkit, parent, false, false));
    }

    private void createListSourceAttributeControls(FormToolkit toolkit, Composite parent) {
        DTRTUIUtil.createSectionLabel((FormToolkit)toolkit, (Composite)parent, (String)EditorLabelMessages.ICtrlListBindingEditor_ListSourceAttribute);
        AttributeBindingDialogCreationStrategy dialogCreationStrategy = new AttributeBindingDialogCreationStrategy(DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.ACTION_BROWSE)){

            protected void doOpenDialog() {
                int open = ICtrlListBindingEditor.this.listSourceAttributeSelectionDialog.open();
                if (open == 0) {
                    ICtrlListBindingEditor.this.forceDisplayToRecalculate.setValue((Object)String.valueOf(System.currentTimeMillis()));
                    ICtrlListBindingEditor.this.displayAttributesComboUpdateBinding.updateModelToTarget();
                }
            }
        };
        this.listSourceAttributeDialogText = this.createAttributesText(toolkit, parent, (DialogCreationStrategy)dialogCreationStrategy, EditorLabelMessages.ICtrlListBindingEditor_ListSourceAttribute);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.listSourceAttributeDialogText.createControl(toolkit, parent, false, false));
    }

    private void createTargetAttributeControls(FormToolkit toolkit, Composite parent) {
        DTRTUIUtil.createSectionLabel((FormToolkit)toolkit, (Composite)parent, (String)EditorLabelMessages.ICtrlListBindingEditor_TargetAttribute);
        AttributeBindingDialogCreationStrategy dialogCreationStrategy = new AttributeBindingDialogCreationStrategy(DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.ACTION_BROWSE)){

            protected void doOpenDialog() {
                DataBindingContext dialogContext = new DataBindingContext();
                ICtrlListBindingEditor.this.attributeSelectionDialog = new AttributeSelectionDialog(((TextDialogPropertyEditor)ICtrlListBindingEditor.this.targetAttributeTextDialog.getPropertyEditor()).getControl().getShell(), (ILabelProvider)new DescribableLabelProvider(), (ITreeContentProvider)new DelegatingObjectContentProvider(new IObjectContentProviderDelegate[]{new DataControlObjectContentProvider(), new VariableIteratorContentProvider()}), new ListTargetAttributeSelectionValueCreationAdvisor(dialogContext, ICtrlListBindingEditor.this.getContext(), (ICtrlList)ICtrlListBindingEditor.this.getModel(), UIHelpContext.EDIT_LIST_TARGET_BINDING_DLG.getId()));
                ICtrlListBindingEditor.this.attributeSelectionDialog.setInput(ICtrlListBindingEditor.this.getBindRoots());
                ICtrlListBindingEditor.this.attributeSelectionDialog.open();
            }
        };
        this.targetAttributeTextDialog = this.createAttributesText(toolkit, parent, (DialogCreationStrategy)dialogCreationStrategy, EditorLabelMessages.ICtrlListBindingEditor_TargetAttribute);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.targetAttributeTextDialog.createControl(toolkit, parent, false, false));
    }

    @Override
    protected List<Object> getBindRoots() {
        List<Object> bindRoots = super.getBindRoots();
        this.maybeAddVariableIteratorToBindRoots(bindRoots);
        return bindRoots;
    }

    @Override
    protected PropertyEditorViewer<TextDialogPropertyEditor> createAttributesText(FormToolkit toolkit, Composite editorComposite, DialogCreationStrategy dialogCreationStrategy, String label) {
        return new PropertyEditorViewer((PropertyEditorFactory)this.createReadOnlyLabeledTextEditorWithDialogButtonFactory(toolkit, editorComposite, label, dialogCreationStrategy));
    }

    protected PropertyEditorViewer<TablePropertyEditor> createAttributesTable(FormToolkit toolkit, Composite editorComposite) {
        Label label = DTRTUIUtil.createSectionLabel((FormToolkit)toolkit, (Composite)editorComposite, (String)EditorLabelMessages.ICtrlListBindingEditor_FieldMappings);
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)label);
        TableFactory tableFactory = TableFactory.create().defaults().addColumn(TableFactory.TableColumnFactory.create().defaults().resizable(true).text(EditorLabelMessages.ICtrlListBindingEditor_AttributeName)).addColumn(TableFactory.TableColumnFactory.create().defaults().resizable(true).text(EditorLabelMessages.ICtrlListBindingEditor_ListAttributeMapping));
        TablePropertyEditorViewer editor = new TablePropertyEditorViewer(this.createTablePropertyEditorFactory(toolkit, editorComposite).editor(this.createTableEditorFactory()), tableFactory);
        return editor;
    }

    private SelectionBasedEditorFactory createTableEditorFactory() {
        SelectionBasedEditorFactory tableEditorFactory = new SelectionBasedEditorFactory();
        oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.ActionFactory actionFactory = new oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.ActionFactory();
        actionFactory.image(ImageDescriptor.createFromImage((Image)DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.ACTION_ADD)));
        actionFactory.handler((SelectionOperationHandler)new AddMappingRunnable((IOEPEExecutableContext)this.getContext(), (ICtrlList)this.getModel()));
        tableEditorFactory.actionAdd(actionFactory);
        actionFactory = new oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.ActionFactory();
        actionFactory.image(ImageDescriptor.createFromImage((Image)DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.ACTION_DELETE)));
        this.removeMappingHandler = new RemoveMappingRunnable((IOEPEExecutableContext)this.getContext(), (ICtrlList)this.getModel());
        actionFactory.handler((SelectionOperationHandler)this.removeMappingHandler);
        tableEditorFactory.actionRemove(actionFactory);
        return tableEditorFactory;
    }

    private void addCellEditors(DataBindingContext dbc, PropertyEditorViewer<TablePropertyEditor> attributesTable) {
        this.createComboEditor(attributesTable, (EStructuralFeature)ExecutablePackage.Literals.ICTRL_VALUE__ATTR_NAMES, (EStructuralFeature)ExecutablePackage.Literals.ICONTROL_BINDING__ITER_BINDING_NAME, (EStructuralFeature)ExecutablePackage.Literals.ICTRL_VALUE__TARGET_BINDING, 0);
        this.createComboEditor(attributesTable, (EStructuralFeature)ExecutablePackage.Literals.ICTRL_LIST__LIST_ATTR_NAMES, (EStructuralFeature)ExecutablePackage.Literals.ICTRL_LIST__LIST_ITERATOR_BINDING_NAME, (EStructuralFeature)ExecutablePackage.Literals.ICTRL_LIST__LIST_SOURCE_BINDING, 1);
    }

    private void createComboEditor(PropertyEditorViewer<TablePropertyEditor> attributesTable, EStructuralFeature feature, EStructuralFeature iteratorFeature, EStructuralFeature bindingFeature, final int columnIndex) {
        TableViewer viewer = ((TablePropertyEditor)attributesTable.getPropertyEditor()).getViewer();
        ComboBoxViewerCellEditor cellEditor = new ComboBoxViewerCellEditor((Composite)viewer.getTable(), 8);
        cellEditor.setContentProvider((IStructuredContentProvider)new NamedDefinitionContentProvider(iteratorFeature, bindingFeature));
        cellEditor.setLabelProvider((IBaseLabelProvider)new AttributeRowValueLabelProvider());
        cellEditor.setInput(this.getModel());
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, viewer.getTable().getColumn(columnIndex));
        TableAttributeEditingSupport editingSupport = new TableAttributeEditingSupport((ColumnViewer)viewer, (CellEditor)cellEditor, columnIndex, (SelectionOperationHandler)new ChangeAttributeRunnable((IOEPEExecutableContext)this.getContext(), (ICtrlList)this.getModel(), feature), new AbstractAttributeRowEditingSupport.CanEditValidator(){

            public IStatus validate(Object value) {
                IStructuredTypeObject targetBinding = ((ICtrlList)ICtrlListBindingEditor.this.getModel()).getTargetBinding();
                if (targetBinding instanceof IDataControlObject && ADFTypeResolver.INSTANCE.isSimpleTypeAttribute((IDataControlObject)targetBinding)) {
                    return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", EditorLabelMessages.ICtrlListBindingEditor_1);
                }
                return Status.OK_STATUS;
            }
        });
        viewerColumn.setEditingSupport((EditingSupport)editingSupport);
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof AttributeRowValue) {
                    List value = ((AttributeRowValue)element).getValue();
                    if (value != null && value.size() > columnIndex) {
                        Object object = value.get(columnIndex);
                        String label = object != null ? object.toString() : "";
                        cell.setText(label);
                    } else {
                        cell.setText("");
                    }
                }
            }
        });
    }

    private FormTextEditorViewer createListIteratorText(FormToolkit toolkit, Composite editorComposite) {
        return new FormTextEditorViewer(this.createFormTextEditorFactory(toolkit, editorComposite, EditorLabelMessages.BaseCtrlValueBindingEditor_Iterator, null, 10), this.getContext(), true);
    }

    private PropertyEditorViewer<ListBoundComboPropertyEditor> createDisplayAttributesCombo(Composite editorComposite) {
        this.displayItems = new WritableList();
        return new ComboPropertyEditorViewer(this.createLabeledDynamicComboPropertyEditorFactory(editorComposite, (List<Object>)this.displayItems, (ILabelProvider)new DescribableLabelProvider(), EditorLabelMessages.ICtrlListBindingEditor_DisplayAttribute), true);
    }

    public void handleGlobalActionExecution(String actionId, Control control, Event event) {
        if (actionId.equals(ActionFactory.DELETE.getId()) && control == ((TablePropertyEditor)this.attributesTable.getPropertyEditor()).getViewer().getControl()) {
            ICommand command = this.removeMappingHandler.createHandlerCommand(((TablePropertyEditor)this.attributesTable.getPropertyEditor()).getViewer().getSelection());
            this.removeMappingHandler.execute(command);
        }
    }

    public static class AddMappingRunnable
    extends SelectionOperationHandler.DefaultExecutingSelectionOperationHandler {
        private final ICtrlList model;

        public AddMappingRunnable(IOEPEExecutableContext context, ICtrlList model) {
            super(context);
            this.model = model;
        }

        public ICommand createHandlerCommand(ISelection selection) {
            String[] newListNames;
            CompoundCommand command = new CompoundCommand(EditorLabelMessages.ICtrlListBindingEditor_AddNewMapping);
            String[] newAttrNames = this.copyAndAppendNew(this.model.getAttrNames());
            if (newAttrNames != null) {
                command.addCommand(new SetCommandFactory(this.getContext(), this.model, (EStructuralFeature)ExecutablePackage.Literals.ICTRL_VALUE__ATTR_NAMES).create(newAttrNames));
            }
            if ((newListNames = this.copyAndAppendNew(this.model.getListAttrNames())) != null) {
                command.addCommand(new SetCommandFactory(this.getContext(), this.model, (EStructuralFeature)ExecutablePackage.Literals.ICTRL_LIST__LIST_ATTR_NAMES).create(newListNames));
            }
            return command;
        }

        private String[] copyAndAppendNew(String[] source) {
            String[] newArray = null;
            if (source != null) {
                newArray = new String[source.length + 1];
                System.arraycopy(source, 0, newArray, 0, source.length);
            } else {
                newArray = new String[1];
            }
            newArray[newArray.length - 1] = "newAttribute";
            return newArray;
        }

        public Object getNewValue(ISelection selection) {
            throw new UnsupportedOperationException();
        }
    }

    public static class ChangeAttributeRunnable
    extends SelectionOperationHandler.DefaultExecutingSelectionOperationHandler {
        private final ICtrlList binding;
        private final EStructuralFeature feature;

        public ChangeAttributeRunnable(IOEPEExecutableContext context, ICtrlList binding, EStructuralFeature feature) {
            super(context);
            this.binding = binding;
            this.feature = feature;
        }

        public Object getNewValue(ISelection selection) {
            Iterator iterator = ((IStructuredSelection)selection).iterator();
            Object changeElement = iterator.next();
            if (changeElement instanceof AttributeRowValue) {
                int index = ((AttributeRowValue)changeElement).getIndex();
                String[] attrNames = (String[])this.binding.eGet(this.feature);
                if (attrNames != null) {
                    Object dataControlObject;
                    Object newValue;
                    int newAttrNamesLength = Math.max(attrNames.length, index + 1);
                    Object[] newAttrNames = new String[newAttrNamesLength];
                    System.arraycopy(attrNames, 0, newAttrNames, 0, attrNames.length);
                    if (newAttrNamesLength > attrNames.length) {
                        Arrays.fill(newAttrNames, attrNames.length, newAttrNamesLength, "");
                    }
                    if ((newValue = iterator.next()) instanceof AttributeRowValue && (dataControlObject = ((AttributeRowValue)newValue).getValue().get(0)) instanceof IDataControlObject) {
                        newAttrNames[index] = ((IDataControlObject)dataControlObject).getId();
                    }
                    return newAttrNames;
                }
            }
            return null;
        }

        public ICommand createHandlerCommand(ISelection selection) {
            Object newValue = this.getNewValue(selection);
            return new SetCommandFactory(this.getContext(), this.binding, this.feature).create(newValue);
        }
    }

    public static class RemoveMappingRunnable
    extends SelectionOperationHandler.DefaultExecutingSelectionOperationHandler {
        private final ICtrlList model;

        public RemoveMappingRunnable(IOEPEExecutableContext context, ICtrlList model) {
            super(context);
            this.model = model;
        }

        private ICommand getValue(ISelection selection) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            if (firstElement instanceof AttributeRowValue) {
                String[] newListAttrNames;
                int numCommandsAdded = 0;
                CompoundCommand command = new CompoundCommand(EditorLabelMessages.ICtrlListBindingEditor_RemoveMapping);
                int index = ((AttributeRowValue)firstElement).getIndex();
                String[] newAttrNames = this.removeAndPack(this.model.getAttrNames(), index);
                if (newAttrNames != null) {
                    command.addCommand(new SetCommandFactory(this.getContext(), this.model, (EStructuralFeature)ExecutablePackage.Literals.ICTRL_VALUE__ATTR_NAMES).create(newAttrNames));
                    ++numCommandsAdded;
                }
                if ((newListAttrNames = this.removeAndPack(this.model.getListAttrNames(), index)) != null) {
                    command.addCommand(new SetCommandFactory(this.getContext(), this.model, (EStructuralFeature)ExecutablePackage.Literals.ICTRL_LIST__LIST_ATTR_NAMES).create(newListAttrNames));
                    ++numCommandsAdded;
                }
                if (numCommandsAdded > 0) {
                    return command;
                }
            }
            return null;
        }

        private String[] removeAndPack(String[] source, int removeAtIndex) {
            if (source != null && source.length > removeAtIndex) {
                String[] newArray = new String[source.length - 1];
                int i = 0;
                while (i < source.length) {
                    if (i < removeAtIndex && i < newArray.length) {
                        newArray[i] = source[i];
                    } else if (i > removeAtIndex && i - 1 < newArray.length) {
                        newArray[i - 1] = source[i];
                    }
                    ++i;
                }
                if (newArray.length == 0) {
                    newArray = new String[]{""};
                }
                return newArray;
            }
            return null;
        }

        public ICommand createHandlerCommand(ISelection selection) {
            return this.getValue(selection);
        }

        public Object getNewValue(ISelection selection) {
            throw new UnsupportedOperationException();
        }
    }
}

