/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.editor;

import java.util.Collection;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IObjectLocatorContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.ui.context.IUIObjectEditor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.ActionBindingEditor;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.AttributeValueBindingEditor;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.BooleanCheckboxBindingEditor;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.IAccessorIteratorEditor;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.ICtrlListBindingEditor;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.IMethodIteratorEditor;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.InvokeActionEditor;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.IteratorBindingEditor;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.LOVListBindingEditor;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.MethodActionBindingEditor;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.TaskFlowBindingEditor;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.TreeBindingEditor;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.VariablesIteratorEditor;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.DTTaskFlowBinding;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IAccessorIterator;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IActionBindingReference;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IBaseObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlAction;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlAttrs;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlBool;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlHier;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlList;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.ICtrlMethodAction;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IMethodIteratorBinding;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IVariablesIterator;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IteratorBinding;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.UnsupportedControlBinding;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.UnsupportedExecutable;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.util.ExecutableSwitch;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.util.ExecutableValidator;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.DataControlJavaTypeResolver;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.OEPEContextImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.EditorLabelMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.Diagnostician;

public final class EMFContextUtil {
    public static IStatus validate(OEPEContextImpl context, IObject object, IProgressMonitor monitor) throws Exception {
        if (!(object instanceof IBaseObject)) {
            return new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", context.getNotInContextObjectMessage(object));
        }
        if (!(object instanceof UnsupportedControlBinding) && !(object instanceof UnsupportedExecutable)) {
            if (object instanceof IPageDefinition) {
                MultiStatus pageDefinitionStatus = new MultiStatus("oracle.eclipse.tools.adf.dtrt.v120102", 0, EditorLabelMessages.PageDefinitionValidation, null);
                IStatus status = EMFContextUtil.doValidate(context, object, monitor);
                if (status != null && !status.isOK()) {
                    pageDefinitionStatus.add(status);
                }
                for (IBindingObject bindingObject : DTRTObjectUtil.getBindingObjects((IPageDefinition)((IPageDefinition)object))) {
                    status = EMFContextUtil.doValidate(context, (IObject)bindingObject, monitor);
                    if (status == null || status.isOK()) continue;
                    pageDefinitionStatus.add(status);
                }
                return pageDefinitionStatus;
            }
            return EMFContextUtil.doValidate(context, object, monitor);
        }
        return null;
    }

    private static IStatus doValidate(OEPEContextImpl context, IObject object, IProgressMonitor monitor) throws Exception {
        Map<Object, Object> validationContext;
        IBaseObject baseObject;
        Diagnostic diagnostic;
        DataControlJavaTypeResolver typeResolver = null;
        if (context instanceof IPageDefinitionContext || context instanceof IWebPageContext) {
            typeResolver = new DataControlJavaTypeResolver((IOEPEContext)context);
        } else if (context instanceof IObjectLocatorContext) {
            IFile file;
            IFile iFile = file = context.isKnown(object) ? context.getAccessibleFile(object) : null;
            if (file != null) {
                typeResolver = new DataControlJavaTypeResolver((IOEPEContext)context, file.getProject());
            }
        }
        if (typeResolver != null && ((diagnostic = Diagnostician.INSTANCE.validate((EObject)(baseObject = (IBaseObject)object), validationContext = ExecutableValidator.createFeatureOnlyValidationContext((Collection<EStructuralFeature>)baseObject.eClass().getEAllStructuralFeatures(), typeResolver))).getSeverity() == 4 || diagnostic.getSeverity() == 2)) {
            return BasicDiagnostic.toIStatus((Diagnostic)diagnostic);
        }
        return null;
    }

    public static IUIObjectEditor createObjectEditor(OEPEContextImpl context, IObject object) {
        if (!(context instanceof IPageDefinitionContext)) {
            return null;
        }
        final IPageDefinitionContext pageDefinitionContext = (IPageDefinitionContext)context;
        IUIObjectEditor editor = (IUIObjectEditor)new ExecutableSwitch<IUIObjectEditor>(){

            @Override
            public IUIObjectEditor defaultCase(EObject object) {
                return null;
            }

            @Override
            public IUIObjectEditor caseICtrlAttrs(ICtrlAttrs object) {
                return new AttributeValueBindingEditor(object, pageDefinitionContext);
            }

            @Override
            public IUIObjectEditor caseIteratorBinding(IteratorBinding object) {
                return new IteratorBindingEditor(object, pageDefinitionContext);
            }

            @Override
            public IUIObjectEditor caseIAccessorIterator(IAccessorIterator object) {
                return new IAccessorIteratorEditor(object, pageDefinitionContext);
            }

            @Override
            public IUIObjectEditor caseIMethodIteratorBinding(IMethodIteratorBinding object) {
                return new IMethodIteratorEditor(object, pageDefinitionContext);
            }

            @Override
            public IUIObjectEditor caseIVariablesIterator(IVariablesIterator object) {
                return new VariablesIteratorEditor(object, pageDefinitionContext);
            }

            @Override
            public IUIObjectEditor caseICtrlList(ICtrlList object) {
                if (object.getServerListBindingName() != null) {
                    return new LOVListBindingEditor(object, pageDefinitionContext);
                }
                return new ICtrlListBindingEditor(object, pageDefinitionContext);
            }

            @Override
            public IUIObjectEditor caseICtrlAction(ICtrlAction object) {
                return new ActionBindingEditor(object, pageDefinitionContext);
            }

            @Override
            public IUIObjectEditor caseICtrlMethodAction(ICtrlMethodAction object) {
                return new MethodActionBindingEditor(object, pageDefinitionContext);
            }

            @Override
            public IUIObjectEditor caseICtrlHier(ICtrlHier object) {
                return new TreeBindingEditor(object, pageDefinitionContext);
            }

            @Override
            public IUIObjectEditor caseICtrlBool(ICtrlBool object) {
                return new BooleanCheckboxBindingEditor(object, pageDefinitionContext);
            }

            @Override
            public IUIObjectEditor caseDTTaskFlowBinding(DTTaskFlowBinding object) {
                return new TaskFlowBindingEditor(object, pageDefinitionContext);
            }

            @Override
            public IUIObjectEditor caseIActionBindingReference(IActionBindingReference object) {
                return new InvokeActionEditor(object, pageDefinitionContext);
            }
        }.doSwitch((EObject)object);
        return editor;
    }
}

