/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.lovwizard;

import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DescribableLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.BaseWizardPage;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.DescribableViewerComparator;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectCustomization;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.lovwizard.LOVWizardModel;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.lovwizard.Messages;
import oracle.eclipse.tools.common.ui.CommonImages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

class LOVUIOptionsPage
extends BaseWizardPage {
    private LOVWizardModel model;
    private ComboViewer controlTypeViewer;
    private Composite attributeViewerComposite;
    private CheckboxTableViewer attributeViewer;
    private Button upButton;
    private Button downButton;

    public LOVUIOptionsPage(LOVWizardModel model) {
        super(LOVUIOptionsPage.class.getName(), Messages.LOVUIOptionsPageTitle, null);
        this.model = model;
        this.setMessage(Messages.LOVUIOptionsPageMessage);
        this.setPageComplete(false);
    }

    public void dispose() {
        this.model = null;
        this.controlTypeViewer = null;
        this.attributeViewerComposite = null;
        this.attributeViewer = null;
        this.upButton = null;
        this.downButton = null;
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).applyTo(composite);
        DTRTUIUtil.applyGrabAllGridData((Control)composite);
        new Label(composite, 0).setText(Messages.LOVControlTypeLabel);
        this.controlTypeViewer = new ComboViewer(composite, 2056);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.controlTypeViewer.getControl());
        this.controlTypeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.controlTypeViewer.setLabelProvider((IBaseLabelProvider)new DescribableLabelProvider());
        this.controlTypeViewer.setComparator((ViewerComparator)new DescribableViewerComparator());
        this.controlTypeViewer.setInput((Object)StructureObjectCustomization.LOVControlType.values());
        this.controlTypeViewer.setSelection((ISelection)new StructuredSelection((Object)this.model.getLOV().getControlType()));
        this.controlTypeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                LOVUIOptionsPage.this.model.getLOV().setControlType((StructureObjectCustomization.LOVControlType)((Object)sel.getFirstElement()));
                LOVUIOptionsPage.this.getContainer().updateButtons();
            }
        });
        this.attributeViewerComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(5, 3).applyTo(this.attributeViewerComposite);
        DTRTUIUtil.applyGrabAllGridData((Control)this.attributeViewerComposite).horizontalSpan = 2;
        Label dislayAttributesLabel = new Label(this.attributeViewerComposite, 0);
        dislayAttributesLabel.setText(Messages.LOVDisplayAttributes);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)dislayAttributesLabel).horizontalSpan = 2;
        this.attributeViewer = CheckboxTableViewer.newCheckList((Composite)this.attributeViewerComposite, (int)2048);
        DTRTUIUtil.applyGrabAllGridData((Control)this.attributeViewer.getControl());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.attributeViewer);
        this.attributeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.attributeViewer.setLabelProvider((IBaseLabelProvider)new DescribableLabelProvider());
        Composite innerComposite = new Composite(this.attributeViewerComposite, 0);
        GridLayoutFactory.fillDefaults().applyTo(innerComposite);
        GridData gd = new GridData(0x1000000, 0x1000000, false, true);
        innerComposite.setLayoutData((Object)gd);
        this.upButton = new Button(innerComposite, 8);
        GridData gd1 = new GridData(0x1000000, 0x1000000, false, false);
        this.upButton.setLayoutData((Object)gd1);
        this.upButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_UP));
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LOVUIOptionsPage.this.moveItem(-1);
            }
        });
        this.downButton = new Button(innerComposite, 8);
        GridData gd2 = new GridData(0x1000000, 0x1000000, false, false);
        this.upButton.setLayoutData((Object)gd2);
        this.downButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_DOWN));
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LOVUIOptionsPage.this.moveItem(1);
            }
        });
        this.attributeViewer.setInput(this.model.getAvailableDisplayAttributes());
        this.attributeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                LOVUIOptionsPage.this.enableMoveButtons(selection, LOVUIOptionsPage.this.attributeViewer.getTable().getSelectionIndex());
            }
        });
        this.attributeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IStructureChild structureChild = (IStructureChild)event.getElement();
                if (event.getChecked()) {
                    LOVUIOptionsPage.this.model.getCheckedDisplayAttributes().add(structureChild);
                } else {
                    LOVUIOptionsPage.this.model.getCheckedDisplayAttributes().remove(structureChild);
                }
                LOVUIOptionsPage.this.model.updateLOV();
                LOVUIOptionsPage.this.validatePage();
            }
        });
        this.setControl((Control)composite);
    }

    private void moveItem(int i) {
        int current = this.attributeViewer.getTable().getSelectionIndex();
        IStructureChild structureChild = (IStructureChild)this.attributeViewer.getElementAt(current);
        this.model.getAvailableDisplayAttributes().remove(structureChild);
        this.model.getAvailableDisplayAttributes().add(current + i, structureChild);
        this.attributeViewer.setInput(this.model.getAvailableDisplayAttributes());
        this.enableMoveButtons((IStructuredSelection)new StructuredSelection((Object)structureChild), current + i);
        this.model.updateLOV();
        this.getContainer().updateButtons();
    }

    private void enableMoveButtons(IStructuredSelection selection, int index) {
        if (selection == null || selection.size() == 0 || selection.size() > 1) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        } else {
            this.upButton.setEnabled(index > 0);
            this.downButton.setEnabled(index < this.attributeViewer.getTable().getItemCount() - 1);
        }
    }

    public void validatePage() {
        IStatus status = this.validateAttributes();
        if (this.getContainer().getCurrentPage() == this) {
            if (!status.isOK()) {
                this.setErrorMessage(status.getMessage());
            } else {
                this.setErrorMessage(null);
            }
        }
        this.setPageComplete(status.isOK());
    }

    private IStatus validateAttributes() {
        return !this.model.getAllAccessorAttributes().isEmpty() && this.model.getCheckedDisplayAttributes().isEmpty() ? new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", Messages.noDisplayAttributeChecked) : Status.OK_STATUS;
    }

    protected void aboutToBecomeVisible(boolean firstTime) throws Exception {
        if (this.model.getAvailableDisplayAttributes().isEmpty()) {
            this.setMessage(Messages.LOVUIOptionsPageWithoutAttributesMessage);
            this.attributeViewerComposite.setVisible(false);
        } else {
            this.setMessage(Messages.LOVUIOptionsPageMessage);
            this.attributeViewer.refresh();
            this.attributeViewer.setCheckedElements(this.model.getCheckedDisplayAttributes().toArray());
            this.attributeViewerComposite.setVisible(true);
        }
    }
}

