/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.editor;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.command.ISetCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.ui.context.BasicStructureObjectEditor;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.UIExceptionHandler;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.DescribableViewer;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.IDescribableViewerListener;
import oracle.eclipse.tools.adf.dtrt.util.ContextAdapter;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectCustomization;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.command.StructureObjectSetCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.editor.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.editor.ResolvedLOVDialog;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.lovwizard.StructureObjectSetCommandLOVWizardParticipant;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

class StructureObjectEditor
extends BasicStructureObjectEditor
implements IDescribableViewerListener {
    private static ExpandableCompositeHandler expandableCompositeHandler;
    private IDataControlContext context;
    private DTRTUIUtil.ExpandableCompositeAdapter expandableCompositeAdapter;
    private DataBindingContext dataBindingContext;
    private FormToolkit toolkit;
    private CustomizationFeatureObservableValue labelModelObservableValue;
    private ISWTObservableValue labelTextObservableValue;
    private CustomizationFeatureObservableValue toolTipTextModelObservableValue;
    private ISWTObservableValue toolTipTextTextObservableValue;
    private StructureObjectCustomization.LOV lov;
    private Composite lovParent;

    public StructureObjectEditor(IDataControlContext context, IStructureChild object) {
        super((IStructureObject)object);
        this.context = context;
    }

    public void dispose() {
        if (this.dataBindingContext != null) {
            this.dataBindingContext.dispose();
            this.dataBindingContext = null;
        }
        if (this.labelTextObservableValue != null) {
            this.labelTextObservableValue.dispose();
            this.labelTextObservableValue = null;
        }
        if (this.toolTipTextTextObservableValue != null) {
            this.toolTipTextTextObservableValue.dispose();
            this.toolTipTextTextObservableValue = null;
        }
        if (this.labelModelObservableValue != null) {
            this.labelModelObservableValue.dispose();
            this.labelModelObservableValue = null;
        }
        if (this.toolTipTextModelObservableValue != null) {
            this.toolTipTextModelObservableValue.dispose();
            this.toolTipTextModelObservableValue = null;
        }
        this.lov = null;
        this.context = null;
        this.expandableCompositeAdapter = null;
        this.toolkit = null;
        this.lovParent = null;
        super.dispose();
    }

    public IStructureChild getObject() {
        return (IStructureChild)super.getObject();
    }

    protected void addControls(IManagedForm managedForm, FormToolkit toolkit, Composite parent) {
        super.addControls(managedForm, toolkit, parent);
        this.toolkit = toolkit;
        if (this.expandableCompositeAdapter == null) {
            if (expandableCompositeHandler == null) {
                expandableCompositeHandler = new ExpandableCompositeHandler();
            }
            this.expandableCompositeAdapter = expandableCompositeHandler.getExpandableCompositeAdapter(managedForm, this.context);
        }
        int expandableCompositeStyle = 610;
        this.createUIHintControls(toolkit, parent, expandableCompositeStyle);
        this.createLOVParent(toolkit, parent, expandableCompositeStyle);
    }

    private void createUIHintControls(FormToolkit toolkit, Composite parent, int expandableCompositeStyle) {
        Composite expandableCompositeClient = this.createExpandableComposite(toolkit, parent, expandableCompositeStyle, Messages.uiHints);
        DTRTUIUtil.createSectionLabel((FormToolkit)toolkit, (Composite)expandableCompositeClient, (String)Messages.labelLabel);
        Text labelText = toolkit.createText(expandableCompositeClient, null);
        labelText.setToolTipText(Messages.toolTipTextToolTipText);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)labelText);
        this.labelTextObservableValue = WidgetProperties.text((int)24).observeDelayed(3000, (Widget)labelText);
        DTRTUIUtil.createSectionLabel((FormToolkit)toolkit, (Composite)expandableCompositeClient, (String)Messages.toolTipTextLabel);
        Text toolTipTextText = toolkit.createText(expandableCompositeClient, null);
        toolTipTextText.setToolTipText(Messages.toolTipTextToolTipText);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)toolTipTextText);
        this.toolTipTextTextObservableValue = WidgetProperties.text((int)24).observeDelayed(3000, (Widget)toolTipTextText);
    }

    private void createLOVParent(FormToolkit toolkit, Composite parent, int expandableCompositeStyle) {
        Composite expandableCompositeClient = this.createExpandableComposite(toolkit, parent, expandableCompositeStyle, Messages.lov);
        this.lovParent = toolkit.createComposite(expandableCompositeClient, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(LayoutConstants.getSpacing().x + 3, LayoutConstants.getSpacing().y).applyTo(this.lovParent);
        DTRTUIUtil.applyGrabAllGridData((Control)this.lovParent).horizontalSpan = 2;
    }

    private Composite createExpandableComposite(FormToolkit toolkit, Composite parent, int expandableCompositeStyle, String text) {
        expandableCompositeStyle = this.expandableCompositeAdapter.adjustExpandedState(text, expandableCompositeStyle);
        ExpandableComposite expandableComposite = DTRTUIUtil.createExpandableComposite((FormToolkit)toolkit, (Composite)parent, (int)expandableCompositeStyle, (boolean)false);
        Composite ancestor = parent;
        while (ancestor != null && !(ancestor instanceof Shell)) {
            if (ancestor instanceof Section) {
                expandableComposite.setTitleBarForeground(((Section)ancestor).getTitleBarForeground());
                break;
            }
            ancestor = ancestor.getParent();
        }
        DTRTUIUtil.applyGrabAllGridData((Control)expandableComposite).horizontalSpan = 2;
        GridData gridData = DTRTUIUtil.applyGrabHorizontallyGridData((Control)expandableComposite);
        gridData.horizontalSpan = 2;
        gridData.verticalIndent = 5;
        expandableComposite.setText(text);
        expandableComposite.addExpansionListener((IExpansionListener)this.expandableCompositeAdapter);
        this.expandableCompositeAdapter.setId(expandableComposite, text);
        Composite expandableCompositeClient = toolkit.createComposite((Composite)expandableComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(expandableCompositeClient);
        expandableComposite.setClient((Control)expandableCompositeClient);
        return expandableCompositeClient;
    }

    public boolean isStale() {
        if (this.getClient() != null && !this.getClient().isObjectEditorStale()) {
            ICommand command = this.getHandledCommand();
            return command != null && command.getLastOperation() != ICommand.CommandOperation.EXECUTION;
        }
        return true;
    }

    public void refresh() {
        IDescribable property;
        super.refresh();
        if (this.dataBindingContext == null) {
            this.dataBindingContext = new DataBindingContext();
            this.labelModelObservableValue = new CustomizationFeatureObservableValue(this.context, (IStructureObject)this.getObject(), StructureObjectCustomization.SetableFeature.LABEL);
            this.dataBindingContext.bindValue((IObservableValue)this.labelTextObservableValue, (IObservableValue)this.labelModelObservableValue);
            this.toolTipTextModelObservableValue = new CustomizationFeatureObservableValue(this.context, (IStructureObject)this.getObject(), StructureObjectCustomization.SetableFeature.TOOL_TIP_TEXT);
            this.dataBindingContext.bindValue((IObservableValue)this.toolTipTextTextObservableValue, (IObservableValue)this.toolTipTextModelObservableValue);
        } else {
            this.dataBindingContext.updateTargets();
        }
        this.updateLOV();
        ICommand command = this.getHandledCommand();
        if (command instanceof ISetCommand && command.getLastOperation() != ICommand.CommandOperation.EXECUTION && (property = ((ISetCommand)command).getProperty()) instanceof StructureObjectCustomization.SetableFeature) {
            switch ((StructureObjectCustomization.SetableFeature)property) {
                case LABEL: 
                case TOOL_TIP_TEXT: {
                    Text text = property == StructureObjectCustomization.SetableFeature.LABEL ? (Text)this.labelTextObservableValue.getWidget() : (Text)this.toolTipTextTextObservableValue.getWidget();
                    text.selectAll();
                    text.setFocus();
                    break;
                }
                case LOVFeature: {
                    this.lovParent.setFocus();
                }
            }
        }
    }

    private void updateLOV() {
        StructureObjectCustomization customization;
        this.lov = null;
        if (this.getObject() != null && this.getObject().isCustomized() && (customization = StructureUtil.getCustomization((IStructureObject)this.getObject())) != null) {
            this.lov = customization.getLOV();
        }
        this.updateLOVControls();
    }

    private ICommand getHandledCommand() {
        ICommand command;
        if (this.getClient() != null && (command = this.getClient().getHandledCommand()) != null && command.getAffectedObjects().contains(this.getObject())) {
            return command;
        }
        return null;
    }

    private void updateLOVControls() {
        boolean hadChildren;
        boolean bl = hadChildren = DTRTUIUtil.disposeChildren((Composite)this.lovParent) > 0;
        if (this.lov != null) {
            IStatus status;
            DTRTUIUtil.createSectionLabel((FormToolkit)this.toolkit, (Composite)this.lovParent, (String)Messages.listNameLabel);
            LOVNameDescribable describable = new LOVNameDescribable();
            describable.addListener(this);
            IStatus lovStatus = null;
            if (this.getClient() != null && (status = this.getClient().getValidationStatus((IObject)this.getObject())) != null && (lovStatus = DTRTUtil.getStatus((IStatus)status, (int)4, (int)202)) == null) {
                lovStatus = DTRTUtil.getStatus((IStatus)status, (int)2, (int)202);
            }
            DTRTUIUtil.applyGrabHorizontallyGridData((Control)describable.createControl(this.toolkit, this.lovParent, this.lov.getName(), lovStatus));
            int defaultBorderStyle = this.toolkit.getBorderStyle();
            this.toolkit.setBorderStyle(0);
            try {
                DTRTUIUtil.createSectionLabel((FormToolkit)this.toolkit, (Composite)this.lovParent, (String)Messages.sourceLabel);
                Text lovViewInstanceText = this.toolkit.createText(this.lovParent, this.lov.getViewInstanceName());
                lovViewInstanceText.setEditable(false);
                DTRTUIUtil.applyGrabHorizontallyGridData((Control)lovViewInstanceText);
                if (this.lov.getListAttributeName() != null) {
                    DTRTUIUtil.createSectionLabel((FormToolkit)this.toolkit, (Composite)this.lovParent, (String)Messages.sourceAttributeLabel);
                    Text lovListAttributeText = this.toolkit.createText(this.lovParent, this.lov.getListAttributeName());
                    lovListAttributeText.setEditable(false);
                    DTRTUIUtil.applyGrabHorizontallyGridData((Control)lovListAttributeText);
                }
            }
            finally {
                this.toolkit.setBorderStyle(defaultBorderStyle);
            }
            Hyperlink showLOVSourcesHyperlink = this.toolkit.createHyperlink(this.lovParent, Messages.showLOVSources, 64);
            DTRTUIUtil.applyGrabHorizontallyGridData((Control)showLOVSourcesHyperlink).horizontalSpan = 2;
            showLOVSourcesHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    StructureObjectEditor.this.showResolvedLOVs();
                }
            });
        } else {
            DTRTUIUtil.createSectionLabel((FormToolkit)this.toolkit, (Composite)this.lovParent, (String)Messages.listNameLabel);
            LOVNameDescribable describable = new LOVNameDescribable();
            describable.addListener(this);
            DTRTUIUtil.applyGrabHorizontallyGridData((Control)describable.createControl(this.toolkit, this.lovParent, null, null));
        }
        if (hadChildren) {
            try {
                DTRTUIUtil.controlChanged((Control)this.lovParent);
            }
            catch (Exception exception) {}
            this.lovParent.redraw();
            this.lovParent.update();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleEvent(IDescribable describable, IDescribableViewerListener.ActionType type) {
        StructureObjectSetCommand command = (StructureObjectSetCommand)this.context.createCommand(StructureObjectSetCommand.class);
        command.setObject((IObject)this.getObject());
        command.setProperty(StructureObjectCustomization.SetableFeature.LOVFeature);
        StructureObjectSetCommandLOVWizardParticipant participant = null;
        if (type == IDescribableViewerListener.ActionType.BROWSE) {
            command.setLOVSetOperation(StructureObjectSetCommand.LOVSetOperation.DELETE);
        } else {
            command.setValue(this.lov);
            command.setLOVSetOperation(type == IDescribableViewerListener.ActionType.CREATE ? StructureObjectSetCommand.LOVSetOperation.CREATE : StructureObjectSetCommand.LOVSetOperation.EDIT);
            participant = new StructureObjectSetCommandLOVWizardParticipant(this.getShell());
            command.setParticipant(participant);
        }
        this.context.setExecuteCommand((ICommand)command);
        IStatus status = this.context.canExecute();
        if (status.isOK()) {
            try {
                try {
                    this.context.execute(null);
                    this.updateLOV();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    if (participant == null) return;
                    participant.dispose();
                    return;
                }
                catch (Exception exception) {
                    new UIExceptionHandler().setShell(this.getShell());
                    if (participant == null) return;
                    participant.dispose();
                    return;
                }
            }
            finally {
                if (participant != null) {
                    participant.dispose();
                }
            }
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commandExecutionProblemTitle, (String)DTRTUtil.getLeafStatus((IStatus)status).getMessage());
        }
    }

    private void showResolvedLOVs() {
        Collection<? extends StructureUtil.ResolvedLOV> resolvedLOVs = StructureUtil.resolveLOV(this.getObject(), this.lov);
        if (resolvedLOVs.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)NLS.bind((String)Messages.showSourcesDialogTitle, (Object)this.lov.getName()), (String)Messages.noResolvedLOV);
        } else {
            ISelection selection;
            ResolvedLOVDialog dialog = new ResolvedLOVDialog(this.getShell(), this.getObject(), resolvedLOVs);
            DTRTUIUtil.centerDialog((Shell)this.getShell(), (Dialog)dialog);
            dialog.getShell().setText(Messages.showSourcesDialogTitle);
            if (dialog.open() == 0 && (selection = dialog.getSelection()) != null) {
                this.notifyObjectSelectionListeners(selection);
            }
            dialog.dispose();
        }
    }

    private Shell getShell() {
        return this.lovParent.getShell();
    }

    private static class CustomizationFeatureObservableValue
    extends AbstractObservableValue {
        private IDataControlContext context;
        private IStructureObject structureObject;
        private StructureObjectCustomization.SetableFeature feature;

        public CustomizationFeatureObservableValue(IDataControlContext context, IStructureObject structureObject, StructureObjectCustomization.SetableFeature feature) {
            this.context = context;
            this.structureObject = structureObject;
            this.feature = feature;
        }

        public synchronized void dispose() {
            this.context = null;
            this.structureObject = null;
            this.feature = null;
            super.dispose();
        }

        public Object getValueType() {
            return this.feature.getType();
        }

        protected Object doGetValue() {
            StructureObjectCustomization customization;
            if (this.structureObject.isCustomized() && (customization = StructureUtil.getCustomization(this.structureObject)) != null) {
                return customization.getValue(this.feature);
            }
            return null;
        }

        protected void doSetValue(Object value) {
            ISetCommand command = (ISetCommand)this.context.createCommand(ISetCommand.class);
            command.setObject((IObject)this.structureObject);
            command.setProperty((IDescribable)this.feature);
            command.setValue(value);
            this.context.setExecuteCommand((ICommand)command);
            try {
                this.context.execute(null);
            }
            catch (Exception exception) {
                UIExceptionHandler.DEFAULT.handleException(exception);
            }
        }
    }

    private static class ExpandableCompositeHandler
    extends ContextAdapter {
        private Map<IDataControlContext, DTRTUIUtil.ExpandableCompositeAdapter> expandableCompositeAdapterMap;

        private ExpandableCompositeHandler() {
        }

        public DTRTUIUtil.ExpandableCompositeAdapter getExpandableCompositeAdapter(IManagedForm managedForm, IDataControlContext context) {
            DTRTUIUtil.ExpandableCompositeAdapter expandableCompositeAdapter;
            if (this.expandableCompositeAdapterMap == null) {
                this.expandableCompositeAdapterMap = new IdentityHashMap<IDataControlContext, DTRTUIUtil.ExpandableCompositeAdapter>();
            }
            if ((expandableCompositeAdapter = this.expandableCompositeAdapterMap.get(context)) == null) {
                expandableCompositeAdapter = new DTRTUIUtil.ExpandableCompositeAdapter(managedForm);
                this.expandableCompositeAdapterMap.put(context, expandableCompositeAdapter);
                context.addListener((IOEPEContext.IContextListener)this);
            }
            return expandableCompositeAdapter;
        }

        public void handleDispose(IOEPEContext context) {
            if (this.expandableCompositeAdapterMap != null) {
                DTRTUIUtil.ExpandableCompositeAdapter expandableCompositeAdapter = this.expandableCompositeAdapterMap.remove(context);
                if (expandableCompositeAdapter != null) {
                    expandableCompositeAdapter.dispose();
                }
                if (this.expandableCompositeAdapterMap.isEmpty()) {
                    this.expandableCompositeAdapterMap = null;
                }
            }
        }
    }

    private static class LOVNameDescribable
    extends DescribableViewer {
        private LOVNameDescribable() {
        }

        public Control createControl(FormToolkit toolkit, Composite parent, String text, IStatus status) {
            this.setNullString(text);
            this.setStatus(status);
            return this.createControl(toolkit, parent, text != null, true, status != null && !status.isOK());
        }

        protected ImageHyperlink createBrowseHyperlink(FormToolkit toolkit, Composite parent) {
            ImageHyperlink imageHyperlink = toolkit.createImageHyperlink(parent, 0x1000000);
            imageHyperlink.setToolTipText(Messages.editLOV);
            imageHyperlink.setImage(DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.ACTION_EDIT));
            imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    LOVNameDescribable.this.handleEvent(null);
                }
            });
            return imageHyperlink;
        }

        protected ImageHyperlink createCreationHyperlink(FormToolkit toolkit, Composite parent) {
            if (this.getNullString() != null) {
                ImageHyperlink imageHyperlink = toolkit.createImageHyperlink(parent, 0x1000000);
                imageHyperlink.setToolTipText(Messages.deleteLOV);
                imageHyperlink.setImage(DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.ACTION_DELETE));
                imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        LOVNameDescribable.this.handleEvent(IDescribableViewerListener.ActionType.BROWSE);
                    }
                });
                return imageHyperlink;
            }
            return super.createCreationHyperlink(toolkit, parent);
        }
    }
}

