/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.adf.model.adapter.dataformat.StructureDef;
import oracle.adf.model.utils.StandardOperationDef;
import oracle.adfdt.model.datacontrols.AdapterLazyStructure;
import oracle.adfdt.model.datacontrols.AdapterStructureDefinition;
import oracle.adfdt.model.objects.BeanStructure;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.DataControlDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.OperationDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.jdt.IMemberFilter;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.JDTUtil;
import oracle.eclipse.tools.adf.dtrt.jdt.TypeInfo;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlChild;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.ui.util.IOpenable;
import oracle.eclipse.tools.adf.dtrt.ui.util.OpenableJavaElement;
import oracle.eclipse.tools.adf.dtrt.ui.util.OpenableResource;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.BasicDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.DTRTContentType;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.util.LRUMap;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.BeanDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.AccessorDefinitionStructureChild;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.AttributeDefinitionStructureChild;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.BaseStructureObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.BasicNamedDefinitionStructureChild;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.IReferencedStructureProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.NamedDefinitionKey;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.NamedDefinitionStructureObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.OperationDefinitionStructureChild;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureDefinitionStructure;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectCustomization;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectType;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectValidator;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.persdef.PDefViewObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;

public final class StructureUtil {
    public static final String PROP_LABEL_KEY = "DTRT_StructureObject_Label";
    private static Map<List<String>, BaseDescriptor> descriptorCache;
    static final BasicDescriptor ADF_STRUCTURE_DESCRIPTOR;

    static {
        ADF_STRUCTURE_DESCRIPTOR = new BasicDescriptor(Messages.adfStructure, Messages.adfStructureToolTipText, (ImageManager.IImageData)DTRTBundleIcon.STRUCTURE);
    }

    private StructureUtil() {
    }

    static BaseDescriptor getDescriptor(String label, String toolTipText, ImageManager.IImageData imageData) {
        if (label != null) {
            List<String> key;
            BaseDescriptor descriptor;
            if (descriptorCache == null) {
                descriptorCache = new LRUMap(20, 2000, 50);
            }
            if ((descriptor = descriptorCache.get(key = Arrays.asList(label, toolTipText, imageData != null ? imageData.getKey() : null))) == null) {
                descriptor = new BasicDescriptor(label, toolTipText, imageData);
                descriptorCache.put(key, descriptor);
            }
            return descriptor;
        }
        return null;
    }

    public static StructureProvider getStructureProvider(IStructureObject structureObject) {
        IStructure structure = DTRTObjectUtil.getStructure((IStructureObject)structureObject);
        return structure instanceof StructureDefinitionStructure ? ((StructureDefinitionStructure)structure).getStructureProvider() : null;
    }

    public static boolean isCollection(IStructureChild structureChild) {
        return structureChild instanceof AccessorDefinitionStructureChild && ((AccessorDefinitionStructureChild)structureChild).isCollection();
    }

    public static NamedDefinition toNamedDefinition(IStructureObject structureObject) {
        return structureObject instanceof NamedDefinitionStructureObject ? (NamedDefinition)((NamedDefinitionStructureObject)structureObject).getNamedDefinition() : null;
    }

    public static List<IStructureChild> findChildren(IStructureObject structureObject, StructureObjectType ... structureObjectTypes) {
        List children;
        if (structureObject != null && structureObjectTypes != null && structureObjectTypes.length > 0 && !(children = structureObject.getChildren()).isEmpty()) {
            ArrayList<IStructureChild> list = new ArrayList<IStructureChild>(children.size());
            for (IStructureChild child : children) {
                StructureObjectType structureObjectType = StructureObjectType.getStructureObjectType((IStructureObject)child);
                if (DTRTUtil.indexOf((Object[])structureObjectTypes, (Object)((Object)structureObjectType)) < 0) continue;
                list.add(child);
            }
            if (!list.isEmpty()) {
                return list;
            }
        }
        return new ArrayList<IStructureChild>(0);
    }

    public static IStructureObject findFirstParent(IStructureChild structureChild, StructureObjectType structureObjectType) {
        if (structureChild != null && structureObjectType != null) {
            IStructureObject parent = structureChild.getParent();
            while (parent != null) {
                StructureObjectType type = StructureObjectType.getStructureObjectType(parent);
                if (type == structureObjectType) {
                    return parent;
                }
                parent = parent.getParent();
            }
        }
        return null;
    }

    public static IStructureChild findFirstChild(IStructureObject structureObject, StructureObjectType structureObjectType) {
        if (structureObject != null && structureObjectType != null) {
            for (IStructureChild child : structureObject.getChildren()) {
                StructureObjectType type = StructureObjectType.getStructureObjectType((IStructureObject)child);
                if (type != structureObjectType) continue;
                return child;
            }
        }
        return null;
    }

    public static BeanStructure getBeanStructure(IStructure structure) {
        NamedDefinition namedDefinition = StructureUtil.toNamedDefinition((IStructureObject)structure);
        return namedDefinition instanceof StructureDefinition ? StructureUtil.getBeanStructure((StructureDefinition)namedDefinition) : null;
    }

    static BeanStructure getBeanStructure(StructureDefinition structureDefinition) {
        return structureDefinition instanceof AdapterStructureDefinition ? ((AdapterStructureDefinition)structureDefinition).getBeanStructure() : (structureDefinition instanceof AdapterLazyStructure ? ((AdapterLazyStructure)structureDefinition).getBeanStructure() : null);
    }

    static String getSourceName(StructureDefinition structureDefinition) {
        if (structureDefinition != null) {
            BeanStructure beanStructure = StructureUtil.getBeanStructure(structureDefinition);
            return beanStructure != null ? beanStructure.getBeanClass() : structureDefinition.getFullName();
        }
        return null;
    }

    static StructureDefinition getStructureDefinition(AccessorDefinition accessorDefinition, boolean collectionStructureDefinition) {
        if (accessorDefinition != null) {
            try {
                return collectionStructureDefinition ? accessorDefinition.getCollectionStructure() : accessorDefinition.getStructure();
            }
            catch (Exception e) {
                DTRTvBundle.log(e);
            }
        }
        return null;
    }

    static IStructure addStructureDefinition(List<IStructure> list, StructureProvider structureProvider, StructureDefinition structureDefinition) {
        if (structureProvider != null && list != null && structureDefinition != null) {
            IStructure structure = structureProvider.getStructure(structureDefinition);
            if (structure != null) {
                list.add(structure);
            }
            return structure;
        }
        return null;
    }

    static void addAttributeDefinitions(IStructureObject parent, List<IStructureChild> list, DefinitionContainer definitionContainer, IStructureChild.StructureChildKind kind) {
        if (parent != null && list != null && definitionContainer != null && !definitionContainer.isEmpty()) {
            for (Object object : definitionContainer) {
                if (!(object instanceof AttributeDefinition)) continue;
                AttributeDefinition attributeDefinition = (AttributeDefinition)object;
                if (PDefViewObject.isExtrinsic((NamedDefinition)attributeDefinition)) {
                    kind = IStructureChild.StructureChildKind.EXTRINSIC;
                }
                list.add(StructureUtil.createAttributeDefinitionStructureChild(parent, attributeDefinition, kind));
            }
        }
    }

    static AttributeDefinitionStructureChild createAttributeDefinitionStructureChild(IStructureObject parent, AttributeDefinition attributeDefinition, IStructureChild.StructureChildKind kind) {
        if (parent == null || attributeDefinition == null || kind == null) {
            throw new IllegalArgumentException("No argument can be null");
        }
        AttributeDefinitionStructureChild child = attributeDefinition instanceof AccessorDefinition ? new AccessorDefinitionStructureChild(parent, (AccessorDefinition)attributeDefinition, kind) : new AttributeDefinitionStructureChild(parent, attributeDefinition, kind);
        child.initialize();
        return child;
    }

    static void addBasicNamedDefinitions(IStructureObject parent, List<IStructureChild> list, DefinitionContainer definitionContainer, IStructureChild.StructureChildKind kind) {
        if (parent != null && list != null && definitionContainer != null && !definitionContainer.isEmpty()) {
            for (Object object : definitionContainer) {
                if (!(object instanceof NamedDefinition)) continue;
                BasicNamedDefinitionStructureChild child = new BasicNamedDefinitionStructureChild(parent, (NamedDefinition)object, kind);
                child.initialize();
                list.add(child);
            }
        }
    }

    static void addOperationDefinitions(IStructureObject parent, List<IStructureChild> list, DefinitionContainer definitionContainer, IStructureChild.StructureChildKind kind) {
        if (parent != null && list != null && definitionContainer != null && !definitionContainer.isEmpty()) {
            for (Object object : definitionContainer) {
                OperationDefinitionStructureChild child;
                OperationDefinitionStructureChild operationDefinitionStructureChild = object instanceof StandardOperationDef ? new OperationDefinitionStructureChild(parent, (OperationDefinition)object, IStructureChild.StructureChildKind.IMPLICIT) : (child = object instanceof OperationDefinition ? new OperationDefinitionStructureChild(parent, (OperationDefinition)object, kind) : null);
                if (child == null) continue;
                child.initialize();
                list.add(child);
            }
        }
    }

    static IStructureChild findCorrespondingStructureChild(List<? extends IStructureChild> children, NamedDefinition namedDefinition) {
        for (IStructureChild iStructureChild : children) {
            IStructureChild iStructureChild2;
            if (iStructureChild instanceof NamedDefinitionStructureObject && NamedDefinitionKey.shallowEquals(namedDefinition, ((NamedDefinitionStructureObject)iStructureChild).getNamedDefinition())) {
                return iStructureChild;
            }
            if (iStructureChild == null || (iStructureChild2 = StructureUtil.findCorrespondingStructureChild(iStructureChild.getChildren(), namedDefinition)) == null) continue;
            return iStructureChild2;
        }
        return null;
    }

    static StructureDefinition findParentStructureDefinition(NamedDefinition namedDefinition) {
        Definition definition = namedDefinition.getDefinitionParent();
        while (definition instanceof NamedDefinition) {
            if (definition instanceof AccessorDefinition) {
                return ((AccessorDefinition)definition).getStructure();
            }
            if (definition instanceof DataControlDefinition) {
                return ((DataControlDefinition)definition).getStructure();
            }
            if (definition instanceof StructureDefinition) {
                return (StructureDefinition)definition;
            }
            definition = ((NamedDefinition)definition).getDefinitionParent();
        }
        return null;
    }

    public static IFile getDeclarationFile(IStructureObject structureObject) {
        return structureObject instanceof NamedDefinitionStructureObject ? ((NamedDefinitionStructureObject)structureObject).getDeclarationFile() : null;
    }

    static IOpenable createDeclarationOpenable(IFile declarationFile) {
        return new DeclarationOpenableResource(declarationFile);
    }

    private static String computeTypeLabelForDeclarationFile(IFile declarationFile) {
        if (declarationFile != null) {
            DTRTContentType contentType = DTRTContentType.getDTRTContentType((IFile)declarationFile);
            if (contentType != null) {
                return contentType.getDescriptor().getLabel();
            }
            if (JavaCore.isJavaLikeFileName((String)declarationFile.getName())) {
                return Messages.javaFileOpenable;
            }
        }
        return null;
    }

    static IOpenable createJavaOpenable(IJavaElement javaElement) {
        OpenableJavaElement openable = new OpenableJavaElement(javaElement, false);
        openable.setTypeLabel(Messages.javaOpenable);
        return openable;
    }

    static String getCollectionElementSourceType(IStructureChild structureChild) {
        if (StructureUtil.isCollection(structureChild)) {
            for (IStructure referencedStructure : structureChild.getReferencedStructures()) {
                IStructureChild element = (IStructureChild)DTRTObjectUtil.find((Collection)referencedStructure.getChildren(), (String)"element");
                if (element == null) continue;
                return DTRTUtil.getLabel((IDescriptor)element.getSourceTypeDescriptor());
            }
        }
        return null;
    }

    public static boolean isKnown(IDTRTManager manager, IStructureObject structureObject) {
        return manager != null && manager.getStructureProvider() == StructureUtil.getStructureProvider(structureObject);
    }

    public static <T extends IStructureObject> T getStructureObject(IDTRTManager manager, T externalStructureObject) {
        if (manager != null && !manager.isDisposed() && DTRTObjectUtil.isNotDisposed(externalStructureObject)) {
            NamedDefinition externalNamedDefinition;
            IStructure externalStructure;
            if (StructureUtil.isKnown(manager, externalStructureObject)) {
                return externalStructureObject;
            }
            URI structureObjectURI = externalStructureObject.getURI();
            if (BaseStructureObject.isStructureObjectURI(structureObjectURI) && (externalStructure = DTRTObjectUtil.getStructure(externalStructureObject)) != null && (externalNamedDefinition = StructureUtil.toNamedDefinition((IStructureObject)externalStructure)) instanceof StructureDefinition) {
                StructureDefinition externalStructureDefinition = (StructureDefinition)externalNamedDefinition;
                StructureProvider structureProvider = manager.getStructureProvider();
                StructureDefinitionStructure structure = structureProvider.getCachedStructure(externalStructureDefinition);
                if (structure == null) {
                    BeanStructure externalBeanStructure = StructureUtil.getBeanStructure(externalStructure);
                    if (externalBeanStructure != null) {
                        BeanStructure beanStructure = manager.getBeanStructure(externalBeanStructure.getFullName(), false);
                        if (beanStructure != null) {
                            AdapterLazyStructure structureDefinition = new AdapterLazyStructure(beanStructure.getDesigntimeContext(), null, beanStructure);
                            structure = structureProvider.getStructure((StructureDefinition)structureDefinition);
                        }
                    } else {
                        IType type = (IType)DTRTUtil.getAdapter((IAdaptable)externalStructure, IType.class);
                        if (type != null) {
                            try {
                                StructureDef structureDefinition = BeanDataControlProvider.loadStructureDef(manager, type);
                                structure = structureProvider.getStructure((StructureDefinition)structureDefinition);
                            }
                            catch (Exception e) {
                                DTRTvBundle.log(e);
                            }
                        }
                    }
                }
                if (structure != null) {
                    IObject object = DTRTObjectUtil.find(Collections.singleton(structure), (URI)structureObjectURI);
                    if (externalStructureObject instanceof IStructure ? object instanceof IStructure : object instanceof IStructureChild) {
                        return (T)((IStructureObject)object);
                    }
                }
            }
        }
        return null;
    }

    private static IOpenable createCustomizationOpenable(IFile customizationFile) {
        OpenableResource openable = new OpenableResource(customizationFile);
        openable.setTypeLabel(Messages.customizationOpenable);
        return openable;
    }

    static void handleCustomizationFiles(Set<IOpenable> openables, Collection<? extends IFile> customizationFiles) {
        HashMap<IResource, IOpenable> customizationFileOpenableMap = new HashMap<IResource, IOpenable>(openables.size());
        for (IOpenable iOpenable : openables) {
            if (!(iOpenable instanceof OpenableResource) || !Messages.customizationOpenable.equals(iOpenable.getTypeLabel())) continue;
            customizationFileOpenableMap.put((IResource)((OpenableResource)iOpenable).getDecoratedObject(), iOpenable);
        }
        for (IFile iFile : customizationFiles) {
            IOpenable openable = (IOpenable)customizationFileOpenableMap.remove(iFile);
            if (openable != null) continue;
            openables.add(StructureUtil.createCustomizationOpenable(iFile));
        }
        for (IOpenable iOpenable : customizationFileOpenableMap.values()) {
            openables.remove(iOpenable);
        }
    }

    public static IStructure findReferencedStructure(IStructure structure, String referencedStructureId, int maxDepth) {
        return structure != null && referencedStructureId != null && maxDepth > 0 ? StructureUtil.findReferencedStructure(structure, referencedStructureId, maxDepth, 0) : null;
    }

    private static IStructure findReferencedStructure(IStructure structure, String referencedStructureId, int maxDepth, int depth) {
        if (referencedStructureId.equals(structure.getId())) {
            return structure;
        }
        if (depth < maxDepth) {
            for (IStructureChild structureChild : structure.getChildren()) {
                for (IStructure referencedStructure : structureChild.getReferencedStructures()) {
                    IStructure struct = StructureUtil.findReferencedStructure(referencedStructure, referencedStructureId, maxDepth, depth + 1);
                    if (struct == null) continue;
                    return struct;
                }
            }
        }
        return null;
    }

    public static StructureObjectCustomization getCustomization(IStructureObject structureObject) {
        return StructureUtil.getCustomization(structureObject, false);
    }

    public static StructureObjectCustomization getCustomization(IStructureObject structureObject, boolean create) {
        if (structureObject instanceof AttributeDefinitionStructureChild) {
            AttributeDefinitionStructureChild attributeDefinitionStructureChild = (AttributeDefinitionStructureChild)structureObject;
            StructureObjectCustomization customization = attributeDefinitionStructureChild.getCustomization();
            assert (customization == null || !customization.isDisposed()) : structureObject;
            if (customization == null && create && structureObject.canCustomize()) {
                customization = StructureObjectCustomization.getCustomization(attributeDefinitionStructureChild, true);
                assert (customization != null);
                attributeDefinitionStructureChild.doSetCustomization(customization);
            }
            return customization;
        }
        return null;
    }

    public static Set<? extends ResolvedLOV> computeResolvedLOVs(IStructureChild structureChild) {
        if (structureChild != null && structureChild.canCustomize()) {
            IStructure parentStructure = DTRTObjectUtil.getStructure((IStructureObject)structureChild);
            HashSet<ResolvedLOV> resolvedLOVs = new HashSet<ResolvedLOV>();
            StructureProvider structureProvider = StructureUtil.getStructureProvider((IStructureObject)structureChild);
            structureProvider.setStructureLoadingNotificationEnabled(false);
            try {
                StructureUtil.loadReferencedStructures(new HashSet<IStructureObject>(), structureProvider.getStructures(), 5);
                Set<? extends IStructure> referencingStructures = structureProvider.getAllReferencingStructures(parentStructure);
                if (!referencingStructures.isEmpty()) {
                    HashMap<IStructureChild, IStructureChild> accessorMatchMap = new HashMap<IStructureChild, IStructureChild>();
                    HashMap<IStructureChild, IStructureChild> matchMap = new HashMap<IStructureChild, IStructureChild>();
                    for (IStructure iStructure : referencingStructures) {
                        if (parentStructure.equals((Object)iStructure)) continue;
                        try {
                            StructureUtil.analyzeStructure(accessorMatchMap, matchMap, structureProvider, resolvedLOVs, structureChild, iStructure);
                        }
                        catch (Exception e) {
                            DTRTvBundle.log(e);
                        }
                    }
                }
            }
            finally {
                structureProvider.setStructureLoadingNotificationEnabled(true);
            }
            if (!resolvedLOVs.isEmpty()) {
                return Collections.unmodifiableSet(resolvedLOVs);
            }
        }
        return Collections.emptySet();
    }

    public static Collection<? extends ResolvedLOV> resolveLOV(IStructureChild customizedStructureChild, StructureObjectCustomization.LOV lov) {
        return StructureUtil.resolveLOV(customizedStructureChild, lov, true);
    }

    public static Collection<? extends ResolvedLOV> resolveLOV(IStructureChild customizedStructureChild, StructureObjectCustomization.LOV lov, boolean validateLOV) {
        String viewInstanceName;
        if (customizedStructureChild != null && (validateLOV ? StructureUtil.isValidLOV((IStructureObject)customizedStructureChild, lov) : lov != null) && (viewInstanceName = lov.getViewInstanceName()) != null && viewInstanceName.startsWith("datacontrol.")) {
            IStructure customizedStructure = DTRTObjectUtil.getStructure((IStructureObject)customizedStructureChild);
            String accessorId = viewInstanceName.substring("datacontrol.".length());
            HashSet<ResolvedLOV> resolvedLOVs = new HashSet<ResolvedLOV>();
            StructureProvider structureProvider = StructureUtil.getStructureProvider((IStructureObject)customizedStructureChild);
            structureProvider.setStructureLoadingNotificationEnabled(false);
            try {
                StructureUtil.loadReferencedStructures(new HashSet<IStructureObject>(), structureProvider.getStructures(), 5);
                Set<? extends IStructure> referencingStructures = structureProvider.getAllReferencingStructures(customizedStructure);
                if (!referencingStructures.isEmpty()) {
                    HashMap<IStructureChild, IStructureChild> matchMap = new HashMap<IStructureChild, IStructureChild>();
                    for (IStructure iStructure : referencingStructures) {
                        if (customizedStructure.equals((Object)iStructure)) continue;
                        try {
                            StructureUtil.analyzeStructure(matchMap, structureProvider, resolvedLOVs, customizedStructureChild, accessorId, lov.getListAttributeName(), iStructure);
                        }
                        catch (Exception e) {
                            DTRTvBundle.log(e);
                        }
                    }
                }
            }
            finally {
                structureProvider.setStructureLoadingNotificationEnabled(true);
            }
            if (!resolvedLOVs.isEmpty()) {
                return Collections.unmodifiableSet(resolvedLOVs);
            }
        }
        return Collections.emptySet();
    }

    public static List<? extends StructureObjectCustomization.LOV> computeResolvableLOVs(IDataControlChild dataControlChild) {
        StructureObjectCustomization customization;
        StructureObjectCustomization.LOV lov;
        Collection<? extends ResolvedLOV> resolvedLOVs;
        IStructureChild structureChild;
        IDataControl dataControl;
        if (dataControlChild != null && (dataControl = DTRTObjectUtil.getDataControl((IDataControlObject)dataControlChild)) != null && (structureChild = dataControlChild.getStructureObject()) != null && structureChild.isCustomized() && !(resolvedLOVs = StructureUtil.resolveLOV(dataControl, structureChild, lov = (customization = StructureUtil.getCustomization((IStructureObject)structureChild)).getLOV())).isEmpty()) {
            return Collections.singletonList(lov);
        }
        return Collections.emptyList();
    }

    private static boolean isValidLOV(IStructureObject structureObject, StructureObjectCustomization.LOV lov) {
        return lov != null && StructureObjectValidator.INSTANCE.validate(structureObject, lov).isOK();
    }

    private static void loadReferencedStructures(Set<IStructureObject> visisted, Collection<? extends IStructureObject> loadedStructureObjects, int maxDepth) {
        if (maxDepth > 0 && !loadedStructureObjects.isEmpty()) {
            for (IStructureObject iStructureObject : loadedStructureObjects) {
                if (!visisted.add(iStructureObject)) continue;
                for (IStructureChild structureChild : iStructureObject.getChildren()) {
                    if (structureChild instanceof IReferencedStructureProvider && !((IReferencedStructureProvider)structureChild).isReferencedStructuresInitialzed()) {
                        StructureUtil.loadReferencedStructures(visisted, structureChild.getReferencedStructures(), maxDepth - 1);
                    }
                    StructureUtil.loadReferencedStructures(visisted, structureChild.getChildren(), maxDepth - 1);
                }
            }
        }
    }

    private static Collection<? extends ResolvedLOV> resolveLOV(IDataControl dataControl, IStructureChild customizedStructureChild, StructureObjectCustomization.LOV lov) {
        IStructure customizedStructure;
        String viewInstanceName;
        IStructure dataControlStructure;
        if (dataControl != null && customizedStructureChild != null && StructureUtil.isValidLOV((IStructureObject)customizedStructureChild, lov) && (dataControlStructure = dataControl.getStructureObject()) != null && (viewInstanceName = lov.getViewInstanceName()) != null && viewInstanceName.startsWith("datacontrol.") && !dataControlStructure.equals((Object)(customizedStructure = DTRTObjectUtil.getStructure((IStructureObject)customizedStructureChild)))) {
            String accessorId = viewInstanceName.substring("datacontrol.".length());
            HashSet<ResolvedLOV> resolvedLOVs = new HashSet<ResolvedLOV>();
            StructureProvider structureProvider = StructureUtil.getStructureProvider((IStructureObject)customizedStructureChild);
            if (structureProvider.references(dataControlStructure, customizedStructure)) {
                try {
                    StructureUtil.analyzeStructure(new HashMap<IStructureChild, IStructureChild>(), structureProvider, resolvedLOVs, customizedStructureChild, accessorId, lov.getListAttributeName(), dataControlStructure);
                }
                catch (Exception e) {
                    DTRTvBundle.log(e);
                }
            }
            if (!resolvedLOVs.isEmpty()) {
                return Collections.unmodifiableSet(resolvedLOVs);
            }
        }
        return Collections.emptySet();
    }

    private static void analyzeStructure(Map<IStructureChild, IStructureChild> matchMap, StructureProvider structureProvider, Set<ResolvedLOV> resolvedLOVs, IStructureChild customizedStructureChild, String lovAccessorId, String lovAccessorAttributeId, IStructure structure) throws CoreException {
        ITypeHelper typeHelper = structureProvider.getManager().getTypeHelper();
        IType typeToMatch = StructureUtil.getType(typeHelper, customizedStructureChild);
        StructureObjectType customizedStructureChildType = StructureObjectType.getStructureObjectType((IStructureObject)customizedStructureChild);
        assert (customizedStructureChildType != null);
        for (IStructureChild accessor : StructureUtil.findChildren((IStructureObject)structure, StructureObjectType.ACCESSOR)) {
            if (!lovAccessorId.equals(accessor.getId()) || !StructureUtil.isCollection(accessor)) continue;
            if (lovAccessorAttributeId == null) {
                if (customizedStructureChildType == StructureObjectType.ATTRIBUTE || !StructureUtil.accessorMatches(matchMap, typeHelper, accessor, customizedStructureChild, typeToMatch)) continue;
                resolvedLOVs.add(new ResolvedLOV(accessor, null));
                continue;
            }
            for (IStructure referencedStructure : accessor.getReferencedStructures()) {
                IStructureChild referencedStructureChild = (IStructureChild)DTRTObjectUtil.find((Collection)referencedStructure.getChildren(), (String)lovAccessorAttributeId);
                if (referencedStructureChild == null || !StructureUtil.matches(matchMap, typeHelper, referencedStructureChild, customizedStructureChild, typeToMatch)) continue;
                resolvedLOVs.add(new ResolvedLOV(accessor, referencedStructureChild));
            }
        }
    }

    private static boolean accessorMatches(Map<IStructureChild, IStructureChild> matchMap, ITypeHelper typeHelper, IStructureChild accessor, IStructureChild structureChildToMatch, IType typeToMatch) throws CoreException {
        IType accessorType;
        assert (!StructureUtil.isCollection(structureChildToMatch));
        if (matchMap.containsKey(accessor)) {
            return DTRTUtil.equals((Object)structureChildToMatch, (Object)matchMap.get(accessor));
        }
        StructureObjectType structureObjectType = StructureObjectType.getStructureObjectType((IStructureObject)structureChildToMatch);
        if ((structureObjectType == StructureObjectType.ACCESSOR || structureObjectType == StructureObjectType.ATTRIBUTE) && typeToMatch != null && typeHelper.isCollection(accessorType = StructureUtil.getType(typeHelper, accessor))) {
            for (IStructure accessorReferencedStructure : accessor.getReferencedStructures()) {
                String sourceType;
                IStructureChild element;
                IType type = (IType)DTRTUtil.getAdapter((IAdaptable)accessorReferencedStructure, IType.class);
                if (type == null && (element = (IStructureChild)DTRTObjectUtil.find((Collection)accessorReferencedStructure.getChildren(), (String)"element")) != null && (sourceType = DTRTUtil.getLabel((IDescriptor)element.getSourceTypeDescriptor())) != null) {
                    type = typeHelper.findType(accessorType.getJavaProject(), sourceType);
                }
                if (type == null) continue;
                try {
                    if (!JDTUtil.equals((IType)typeToMatch, (IType)type) && !typeHelper.getSuperTypes(type, true, true, true, new IMemberFilter[0]).contains(typeToMatch)) continue;
                    matchMap.put(accessor, structureChildToMatch);
                    return true;
                }
                catch (Exception exception) {}
            }
        }
        matchMap.put(accessor, null);
        return false;
    }

    private static IType getType(ITypeHelper typeHelper, IStructureChild structureChild) throws CoreException {
        TypeInfo typeInfo;
        IJavaElement javaElement = (IJavaElement)DTRTUtil.getAdapter((IAdaptable)structureChild, IJavaElement.class);
        if (javaElement instanceof IType) {
            return (IType)javaElement;
        }
        if (javaElement != null && (typeInfo = JDTUtil.getTypeInfo((ITypeHelper)typeHelper, (IJavaElement)javaElement)) != null) {
            return typeHelper.findType(javaElement.getJavaProject(), typeInfo.getClassName());
        }
        return null;
    }

    private static boolean matches(Map<IStructureChild, IStructureChild> matchMap, ITypeHelper typeHelper, IStructureChild structureChild, IStructureChild structureChildToMatch, IType typeToMatch) throws CoreException {
        assert (!StructureUtil.isCollection(structureChildToMatch));
        if (StructureObjectType.getStructureObjectType((IStructureObject)structureChildToMatch) == StructureObjectType.getStructureObjectType((IStructureObject)structureChild) && !StructureUtil.isCollection(structureChild)) {
            if (matchMap.containsKey(structureChild)) {
                return DTRTUtil.equals((Object)structureChildToMatch, (Object)matchMap.get(structureChild));
            }
            if (DTRTUtil.equals((Object)structureChild.getSourceTypeDescriptor(), (Object)structureChildToMatch.getSourceTypeDescriptor())) {
                matchMap.put(structureChild, structureChildToMatch);
                return true;
            }
            if (typeToMatch == null) {
                typeToMatch = StructureUtil.getType(typeHelper, structureChildToMatch);
            }
            if (typeToMatch != null) {
                String sourceType;
                IType type = StructureUtil.getType(typeHelper, structureChild);
                if (type == null && (sourceType = DTRTUtil.getLabel((IDescriptor)structureChild.getSourceTypeDescriptor())) != null) {
                    type = typeHelper.findType(typeToMatch.getJavaProject(), sourceType);
                }
                if (type != null) {
                    try {
                        if (JDTUtil.equals((IType)typeToMatch, (IType)type) || typeHelper.getSuperTypes(type, true, true, true, new IMemberFilter[0]).contains(typeToMatch)) {
                            matchMap.put(structureChild, structureChildToMatch);
                            return true;
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        matchMap.put(structureChild, null);
        return false;
    }

    private static void analyzeStructure(Map<IStructureChild, IStructureChild> accessorMatchMap, Map<IStructureChild, IStructureChild> matchMap, StructureProvider structureProvider, Set<ResolvedLOV> resolvedLOVs, IStructureChild structureChild, IStructure structure) throws CoreException {
        ITypeHelper typeHelper = structureProvider.getManager().getTypeHelper();
        IType typeToMatch = StructureUtil.getType(typeHelper, structureChild);
        StructureObjectType structureChildType = StructureObjectType.getStructureObjectType((IStructureObject)structureChild);
        assert (structureChildType != null);
        for (IStructureChild accessor : StructureUtil.findChildren((IStructureObject)structure, StructureObjectType.ACCESSOR)) {
            if (!StructureUtil.isCollection(accessor)) continue;
            if (structureChildType != StructureObjectType.ATTRIBUTE && StructureUtil.accessorMatches(accessorMatchMap, typeHelper, accessor, structureChild, typeToMatch)) {
                resolvedLOVs.add(new ResolvedLOV(accessor, null));
            }
            for (IStructure referencedStructure : accessor.getReferencedStructures()) {
                for (IStructureChild referencedStructureChild : StructureUtil.findChildren((IStructureObject)referencedStructure, StructureObjectType.getStructureObjectType((IStructureObject)structureChild))) {
                    if (!StructureUtil.matches(matchMap, typeHelper, referencedStructureChild, structureChild, typeToMatch)) continue;
                    resolvedLOVs.add(new ResolvedLOV(accessor, referencedStructureChild));
                }
            }
        }
    }

    public static ResolvedLOV findResolvedLOV(Collection<? extends ResolvedLOV> resolvedLOVs, IStructureChild structureChild) {
        if (resolvedLOVs != null && !resolvedLOVs.isEmpty() && structureChild != null) {
            for (ResolvedLOV resolvedLOV : resolvedLOVs) {
                if (!(resolvedLOV.getListAttribute() == null ? DTRTUtil.equals((Object)resolvedLOV.getViewInstance(), (Object)structureChild) : DTRTUtil.equals((Object)resolvedLOV.getListAttribute(), (Object)structureChild))) continue;
                return resolvedLOV;
            }
        }
        return null;
    }

    private static class DeclarationOpenableResource
    extends OpenableResource {
        public DeclarationOpenableResource(IFile file) {
            super(file);
            String declarationType = StructureUtil.computeTypeLabelForDeclarationFile(file);
            this.setTypeLabel(declarationType != null ? declarationType : Messages.declarationOpenable);
        }
    }

    public static final class ResolvedLOV {
        private final IStructureChild viewInstance;
        private final IStructureChild listAttribute;

        private ResolvedLOV(IStructureChild viewInstance, IStructureChild listAttribute) {
            assert (viewInstance != null);
            this.viewInstance = viewInstance;
            this.listAttribute = listAttribute;
        }

        public IStructureChild getViewInstance() {
            return this.viewInstance;
        }

        public IStructureChild getListAttribute() {
            return this.listAttribute;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.listAttribute == null ? 0 : this.listAttribute.hashCode());
            result = 31 * result + (this.viewInstance == null ? 0 : this.viewInstance.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ResolvedLOV other = (ResolvedLOV)obj;
            return DTRTUtil.equals((Object)this.viewInstance, (Object)other.viewInstance) && DTRTUtil.equals((Object)this.listAttribute, (Object)other.listAttribute);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ResolvedLOV [viewInstance=");
            builder.append(this.viewInstance);
            builder.append(", listAttribute=");
            builder.append(this.listAttribute);
            builder.append("]");
            return builder.toString();
        }
    }
}

