/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.adfdt.model.objects.BeanStructure;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.jdt.JDTUtil;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDisposable;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.AttributeDefinitionStructureChild;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.AttributeDefinitionStructureChildData;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.NamedDefinitionKey;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.NamedDefinitionStructureObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.NamedDefinitionStructureObjectData;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureDefinitionStructure;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.sapphire.util.IdentityHashSet;

public final class StructureProvider
implements IDisposable {
    private IDTRTManager manager;
    private Map<NamedDefinitionKey, StructureDefinitionStructure> structureCache;
    private Map<URI, NamedDefinitionStructureObjectData> namedDefinitionStructureObjectDataCache;
    private Map<IStructure, Set<IStructure>> referenceMap;
    private boolean structureLoadingNotificationEnabled = true;
    private boolean notifyStructureLoadingWhenEnabled;

    public StructureProvider(IDTRTManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("manager cannot be null");
        }
        this.manager = manager;
    }

    public void dispose() {
        this.manager = null;
        this.reset();
    }

    IDTRTManager getManager() {
        return this.manager;
    }

    public void reset() {
        if (this.structureCache != null) {
            DTRTUtil.dispose(this.structureCache.values());
            this.structureCache.clear();
            this.structureCache = null;
        }
        if (this.namedDefinitionStructureObjectDataCache != null) {
            DTRTUtil.dispose(this.namedDefinitionStructureObjectDataCache.values());
            this.namedDefinitionStructureObjectDataCache.clear();
            this.namedDefinitionStructureObjectDataCache = null;
        }
        if (this.referenceMap != null) {
            this.referenceMap.clear();
            this.referenceMap = null;
        }
    }

    public void reset(IType type) {
        if (this.structureCache != null && type != null) {
            IdentityHashSet toDispose = new IdentityHashSet();
            for (IStructure iStructure : this.structureCache.values()) {
                IJavaElement structureJavaElement;
                if (!DTRTObjectUtil.isNotDisposed((IObject)iStructure) || !((structureJavaElement = ((StructureDefinitionStructure)iStructure).getJavaElement()) instanceof IMember) || !JDTUtil.equals((IType)type, (Object)structureJavaElement) && !JDTUtil.isMemberOf((IType)type, (IMember)((IMember)structureJavaElement))) continue;
                toDispose.add(iStructure);
            }
            if (!toDispose.isEmpty()) {
                if (this.referenceMap != null) {
                    boolean bl;
                    do {
                        boolean bl2 = false;
                        for (IStructure referencedStructure : new ArrayList(toDispose)) {
                            Set<IStructure> referencingStructures = this.referenceMap.remove(referencedStructure);
                            if (referencingStructures == null || referencingStructures.isEmpty() || !toDispose.addAll(referencingStructures)) continue;
                            bl = true;
                        }
                    } while (bl);
                    if (this.referenceMap.isEmpty()) {
                        this.referenceMap = null;
                    }
                }
                DTRTUtil.dispose((Collection)toDispose);
            }
        }
    }

    public void reset(URI beanStructureURI) {
        if (this.structureCache != null && beanStructureURI != null) {
            IdentityHashSet toDispose = new IdentityHashSet();
            for (IStructure iStructure : this.structureCache.values()) {
                BeanStructure beanStructure;
                if (!DTRTObjectUtil.isNotDisposed((IObject)iStructure) || (beanStructure = StructureUtil.getBeanStructure(iStructure)) != null && !beanStructureURI.equals(this.getManager().getElementURI(beanStructure))) continue;
                toDispose.add(iStructure);
            }
            if (!toDispose.isEmpty()) {
                if (this.referenceMap != null) {
                    boolean bl;
                    do {
                        boolean bl2 = false;
                        for (IStructure referencedStructure : new ArrayList(toDispose)) {
                            Set<IStructure> referencingStructures = this.referenceMap.remove(referencedStructure);
                            if (referencingStructures == null || referencingStructures.isEmpty() || !toDispose.addAll(referencingStructures)) continue;
                            bl = true;
                        }
                    } while (bl);
                    if (this.referenceMap.isEmpty()) {
                        this.referenceMap = null;
                    }
                }
                DTRTUtil.dispose((Collection)toDispose);
            }
        }
    }

    public Collection<? extends IStructure> getStructures() {
        if (this.structureCache != null) {
            HashSet<StructureDefinitionStructure> structures = new HashSet<StructureDefinitionStructure>(this.structureCache.size());
            for (NamedDefinitionKey key : new ArrayList<NamedDefinitionKey>(this.structureCache.keySet())) {
                StructureDefinitionStructure structure = this.getCachedStructure(key);
                if (structure == null) continue;
                structures.add(structure);
            }
            return DTRTUtil.toUnmodifiablePrunedList(structures);
        }
        return Collections.emptyList();
    }

    public IStructure getStructure(StructureDefinition structureDefinition) {
        if (structureDefinition != null) {
            StructureDefinitionStructure structure = this.getCachedStructure(structureDefinition);
            if (structure == null) {
                structure = this.cacheStructure(structureDefinition, new StructureDefinitionStructure(this, structureDefinition));
            }
            return structure;
        }
        return null;
    }

    public IStructureChild getStructureChild(NamedDefinition namedDefinition) {
        StructureDefinition structureDefinition;
        if (namedDefinition != null && (structureDefinition = StructureUtil.findParentStructureDefinition(namedDefinition)) != null) {
            StructureDefinitionStructure parentStructure = this.getCachedStructure(structureDefinition);
            if (parentStructure == null) {
                parentStructure = (StructureDefinitionStructure)this.getStructure(structureDefinition);
            }
            if (parentStructure != null) {
                return StructureUtil.findCorrespondingStructureChild(parentStructure.getChildren(), namedDefinition);
            }
        }
        return null;
    }

    StructureDefinitionStructure getCachedStructure(StructureDefinition structureDefinition) {
        return this.structureCache != null ? this.getCachedStructure(new NamedDefinitionKey((NamedDefinition)structureDefinition)) : null;
    }

    private StructureDefinitionStructure getCachedStructure(NamedDefinitionKey key) {
        if (this.structureCache != null) {
            StructureDefinitionStructure structure = this.structureCache.get(key);
            if (structure != null && this.isStale(structure)) {
                structure = null;
                this.structureCache.remove(key);
                if (this.structureCache.isEmpty()) {
                    this.structureCache = null;
                }
            }
            return structure;
        }
        return null;
    }

    private StructureDefinitionStructure cacheStructure(StructureDefinition structureDefinition, StructureDefinitionStructure structure) {
        assert (structure != null);
        assert (!structure.isDisposed());
        if (this.structureCache == null) {
            this.structureCache = new HashMap<NamedDefinitionKey, StructureDefinitionStructure>();
        }
        this.structureCache.put(new NamedDefinitionKey((NamedDefinition)structureDefinition), structure);
        structure.initialize();
        this.notifyStructureLoading();
        return structure;
    }

    void setStructureLoadingNotificationEnabled(boolean enabled) {
        if (enabled != this.structureLoadingNotificationEnabled) {
            this.structureLoadingNotificationEnabled = enabled;
            if (enabled && this.notifyStructureLoadingWhenEnabled) {
                this.notifyStructureLoadingWhenEnabled = false;
                this.notifyStructureLoading();
            }
        }
    }

    public boolean isStructureLoadingNotificationEnabled() {
        return this.structureLoadingNotificationEnabled;
    }

    private void notifyStructureLoading() {
        if (this.isStructureLoadingNotificationEnabled()) {
            this.getManager().handleStructureLoading();
        } else {
            this.notifyStructureLoadingWhenEnabled = true;
        }
    }

    private boolean isStale(StructureDefinitionStructure structure) {
        if (!DTRTObjectUtil.isNotDisposed((IObject)structure)) {
            return true;
        }
        BeanStructure beanStructure = StructureUtil.getBeanStructure(structure);
        if (beanStructure != null) {
            return this.getManager().isStale(beanStructure);
        }
        return false;
    }

    NamedDefinitionStructureObjectData getNameDefinitionStructureObjectData(NamedDefinitionStructureObject<?> namedDefinitionStructureObject) {
        if (namedDefinitionStructureObject != null && !namedDefinitionStructureObject.isDisposed()) {
            NamedDefinitionStructureObjectData data;
            if (this.namedDefinitionStructureObjectDataCache == null) {
                this.namedDefinitionStructureObjectDataCache = new HashMap<URI, NamedDefinitionStructureObjectData>();
            }
            if ((data = this.namedDefinitionStructureObjectDataCache.get(namedDefinitionStructureObject.getURI())) == null) {
                data = namedDefinitionStructureObject instanceof AttributeDefinitionStructureChild ? new AttributeDefinitionStructureChildData() : new NamedDefinitionStructureObjectData();
                this.namedDefinitionStructureObjectDataCache.put(namedDefinitionStructureObject.getURI(), data);
            }
            return data;
        }
        return null;
    }

    public void handleReferencedStructure(IStructure referencingStructure, IStructure referencedStructure) {
        if (DTRTObjectUtil.isNotDisposed((IObject)referencingStructure) && DTRTObjectUtil.isNotDisposed((IObject)referencedStructure) && !DTRTUtil.equals((Object)referencingStructure, (Object)referencedStructure)) {
            IdentityHashSet referencingStructures;
            if (this.referenceMap == null) {
                this.referenceMap = new HashMap<IStructure, Set<IStructure>>();
            }
            if ((referencingStructures = this.referenceMap.get(referencedStructure)) == null) {
                referencingStructures = new IdentityHashSet();
                this.referenceMap.put(referencedStructure, (Set<IStructure>)referencingStructures);
            }
            referencingStructures.add((IStructure)referencingStructure);
        }
    }

    Set<? extends IStructure> getAllReferencingStructures(IStructure referencedStructure) {
        if (this.referenceMap != null && !this.referenceMap.isEmpty()) {
            HashSet<IStructure> referencingStructures = new HashSet<IStructure>();
            this.doGetAllReferencingStructures(referencingStructures, referencedStructure);
            if (!referencingStructures.isEmpty()) {
                return Collections.unmodifiableSet(referencingStructures);
            }
        }
        return Collections.emptySet();
    }

    private void doGetAllReferencingStructures(Set<IStructure> set, IStructure referencedStructure) {
        Set<IStructure> referencingStructures;
        if (DTRTObjectUtil.isNotDisposed((IObject)referencedStructure) && (referencingStructures = this.referenceMap.get(referencedStructure)) != null) {
            Iterator<IStructure> i = referencingStructures.iterator();
            while (i.hasNext()) {
                IStructure referencingStructure = i.next();
                if (DTRTObjectUtil.isNotDisposed((IObject)referencingStructure)) {
                    if (set.contains(referencingStructure)) continue;
                    set.add(referencingStructure);
                    this.doGetAllReferencingStructures(set, referencingStructure);
                    continue;
                }
                i.remove();
            }
        }
    }

    boolean references(IStructure referencingStructure, IStructure referencedStructure) {
        return this.references(new HashSet<IStructure>(), referencingStructure, referencedStructure);
    }

    boolean references(Set<IStructure> visited, IStructure referencingStructure, IStructure referencedStructure) {
        Set<IStructure> referencingStructures;
        if (DTRTObjectUtil.isNotDisposed((IObject)referencingStructure) && DTRTObjectUtil.isNotDisposed((IObject)referencedStructure) && this.referenceMap != null && !this.referenceMap.isEmpty() && visited.add(referencedStructure) && (referencingStructures = this.referenceMap.get(referencedStructure)) != null) {
            if (referencingStructures.contains(referencingStructure)) {
                return true;
            }
            for (IStructure structure : referencingStructures) {
                if (!this.references(visited, structure, referencedStructure)) continue;
                return true;
            }
        }
        return false;
    }
}

